<?php
/*------------------------------------
* Product Video Extention
* Author  CMSMart Team
* Copyright Copyright (C) 2012 http://cmsmart.net. All Rights Reserved.
* @license - http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
* Websites: http://cmsmart.net
* Email: team@cmsmart.net
* Technical Support: http://cmsmart.net/support_ticket/
* Forum - http://cmsmart.net/forum
-----------------------------------------------------*/
class Cmsmart_Productvideo_Block_Adminhtml_Pendingvideo_Edit_Tab_Form extends Mage_Adminhtml_Block_Widget_Form
{
  protected function _prepareForm()
  {
      $form = new Varien_Data_Form();
      $this->setForm($form);
      $fieldset = $form->addFieldset('pendingvideo_form', array('legend'=>Mage::helper('productvideo')->__('Video information')));
     
		$config = Mage::helper('productvideo')->getConfigData();
		$video_data = Mage::registry('pendingvideo_data');
		$product_load = Mage::getModel('catalog/product')->load($video_data->getProductId());
		$result = '<a href="'.Mage::helper('adminhtml')->getUrl('adminhtml/catalog_product/edit/index/id',array('id'=> $video_data->getProductId())).'" target="_blank">'.$product_load->getName().'</a> ';
		
		$pathUrl = Mage::helper('productvideo')->getMediaPathUrl();
		$product_id = $video_data->getProductId();
		
		if($video_data->getThumbnail()!=''){
			$video_thumbnail_path_url = $pathUrl['thumbnail_product'].$product_id.'/'.$video_data->getThumbnail();
		}else{
			$video_thumbnail_path_url = $pathUrl['thumbnail_product'].$config['thumbnail_image'];
		}
		
		if($video_data->getProvider()==='local'){
			$videoLocalConfig = Mage::helper('productvideo')->getVideoLocalConfigData();
			$iframeSrc .= 'vdo='.$pathUrl['video_product'].$product_id.'/'.$video_data->getVideoId();
			$iframeSrc .= '&splashscreen='.$video_thumbnail_path_url;
			$iframeSrc .= '&sound='.$videoLocalConfig['sound'];
			$iframeSrc .= '&buffer='.$videoLocalConfig['buffer'];
			$iframeSrc .='&autoplay=false';
			$src = '<embed width="500" height="350" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" allowscriptaccess="always" wmode="transparent" quality="best" allowfullscreen="true" flashvars="&'.$iframeSrc.'" src="'. $pathUrl['flash_player'].'">';
		}elseif($video_data->getProvider()==='youtube'){
			$src = '<iframe src="//www.youtube.com/embed/'.$video_data->getVideoId().'?wmode=opaque" width="500" height="350" frameborder="0"  webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
		}elseif($video_data->getProvider()==='vimeo'){
			$src = '<iframe src="//player.vimeo.com/video/'.$video_data->getVideoId().'" width="500" height="350" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
		}elseif($video_data->getProvider()==='dailymotion'){
			$src = '<iframe frameborder="0" width="568" height="270" src="//www.dailymotion.com/embed/video/'.$video_data->getVideoId().'" allowfullscreen></iframe>';
		}elseif($video_data->getProvider()==='twitch'){
			$src = '
				<object type="application/x-shockwave-flash" height=270" width="568" id="live_embed_player_flash" data="http://www.twitch.tv/widgets/live_embed_player.swf?channel='.$video_data->getVideoId().'" bgcolor="#000000"><param name="allowFullScreen" value="true" />
					<param name="allowScriptAccess" value="always" />
					<param name="allowNetworking" value="all" />
					<param name="movie" value="http://www.twitch.tv/widgets/live_embed_player.swf" />
					<param name="flashvars" value="hostname=www.twitch.tv&channel='.$video_data->getVideoId().'&auto_play=true&start_volume=25" />
				</object>
			';
		}

	
	  $fieldset->addField('thumbnail', 'note', array(
          'label'     => Mage::helper('productvideo')->__('Video'),
          'name'      => 'thumbnail',
		  'text'     => $src,
      ));
	  
	  $fieldset->addField('provider', 'note', array(
          'label'     => Mage::helper('productvideo')->__('Provider Source'),
          'name'      => 'provider',
		  'text'     => '<b>'.strtoupper($video_data->getProvider()).'</b>',
      ));
	  
      $fieldset->addField('video_name', 'text', array(
          'label'     => Mage::helper('productvideo')->__('Video Name'),
          'class'     => 'required-entry',
          'required'  => true,
		  'style'	  => 'width: 500px;',
          'name'      => 'video_name',
      ));
	  
	  
	  $fieldset->addField('author_name', 'text', array(
          'label'     => Mage::helper('productvideo')->__('Author Name'),
          'class'     => 'required-entry',
          'required'  => true,
          'name'      => 'author_name',
      ));
	  
	  $fieldset->addField('author_email', 'text', array(
          'label'     => Mage::helper('productvideo')->__('Author Email'),
          'class'     => 'required-entry',
          'required'  => true,
          'name'      => 'author_email',
      ));
	  
	  $fieldset->addField('product_id', 'note', array(
          'label'     => Mage::helper('productvideo')->__('Product'),
          'name'      => 'product_id',
		  'text'     => '<b>'.$result.'</b>',
      ));
	  
	  $fieldset->addField('date_created', 'date', array(
            'name'      => 'date_created',
            'title'     => Mage::helper('productvideo')->__('Date Created'),
            'label'     => Mage::helper('productvideo')->__('Date Created'),
      		'image'     => $this->getSkinUrl('images/grid-cal.gif'), 
			'format'    => 'yyyy-MM-dd',
      )); 
	  
	  $fieldset->addField('author_comment', 'editor', array(
          'name'      => 'author_comment',
          'label'     => Mage::helper('productvideo')->__('Author Comment'),
          'title'     => Mage::helper('productvideo')->__('Author Comment'),
          'style'     => 'width:500px; height:120px;',
          'wysiwyg'   => false,
      ));

      /* $fieldset->addField('filename', 'file', array(
          'label'     => Mage::helper('productvideo')->__('File'),
          'required'  => false,
          'name'      => 'filename',
	  )); */
		
	  $statuses = Mage::getSingleton('productvideo/status')->getOptionArray();
	  
      $fieldset->addField('status', 'select', array(
          'label'     => Mage::helper('productvideo')->__('Status'),
          'name'      => 'status',
          'values'    =>  $statuses,
      ));
     
	  /* rating video */
	  $fieldset = $form->addFieldset('allvideo_form_rating', array('legend'=>Mage::helper('productvideo')->__('Rating Video')));
	  $fieldset->addField('rate_video', 'text', array(
          'label'     => Mage::helper('productvideo')->__('Video Rate'),
          'name'      => 'rate_video',
		  'note'	  => Mage::helper('productvideo')->__('Unit %'),
      ));
	  
	  $fieldset->addField('vote_rating', 'text', array(
          'label'     => Mage::helper('productvideo')->__('Video Vote'),
          'name'      => 'vote_rating',
      ));
	  
      if ( Mage::getSingleton('adminhtml/session')->getPendingvideoData() )
      {
          $form->setValues(Mage::getSingleton('adminhtml/session')->getPendingvideoData());
          Mage::getSingleton('adminhtml/session')->setPendingvideoData(null);
      } elseif ( Mage::registry('pendingvideo_data') ) {
          $form->setValues(Mage::registry('pendingvideo_data')->getData());
      }
      return parent::_prepareForm();
  }
}