<?php
/*------------------------------------
* Product Video Extention
* Author  CMSMart Team
* Copyright Copyright (C) 2012 http://cmsmart.net. All Rights Reserved.
* @license - http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
* Websites: http://cmsmart.net
* Email: team@cmsmart.net
* Technical Support: http://cmsmart.net/support_ticket/
* Forum - http://cmsmart.net/forum
-----------------------------------------------------*/
class Cmsmart_Productvideo_Helper_Data extends Mage_Core_Helper_Abstract
{	
	public function getConfigData(){
		$config['new_media'] = 1;
		/*$config['new_media'] = Mage::getStoreConfig('productvideo/display_setting/new_media');*/
		$config['show_play_icon'] = Mage::getStoreConfig('productvideo/display_setting/show_play_icon');
		$config['video_width'] = Mage::getStoreConfig('productvideo/display_setting/video_width')=='' ? 256 : Mage::getStoreConfig('productvideo/display_setting/video_width');
		$config['video_height'] = Mage::getStoreConfig('productvideo/display_setting/video_height')=='' ? 150 : Mage::getStoreConfig('productvideo/display_setting/video_height');
		$config['display_style'] = Mage::getStoreConfig('productvideo/display_setting/display_style');
                $config['zoom'] = Mage::getStoreConfig('productvideo/display_setting/zoom');
                $config['zoom_width'] = Mage::getStoreConfig('productvideo/display_setting/zoom_width')=='' ? 300 : Mage::getStoreConfig('productvideo/display_setting/zoom_width');
		$config['zoom_height'] = Mage::getStoreConfig('productvideo/display_setting/zoom_height')=='' ? 300 : Mage::getStoreConfig('productvideo/display_setting/zoom_height');
		$config['popup_width'] = Mage::getStoreConfig('productvideo/display_setting/popup_width')=='' ? 640 : Mage::getStoreConfig('productvideo/display_setting/popup_width');
		$config['popup_height'] = Mage::getStoreConfig('productvideo/display_setting/popup_height')==''? 360 : Mage::getStoreConfig('productvideo/display_setting/popup_height');
		
		$config['thumbnail_size'] = Mage::getStoreConfig('productvideo/thumbnail/thumbnail_size')=='' ? 1 : Mage::getStoreConfig('productvideo/thumbnail/thumbnail_size');
		$config['thumbnail_width'] = Mage::getStoreConfig('productvideo/thumbnail/thumbnail_width')=='' ? 56 : Mage::getStoreConfig('productvideo/thumbnail/thumbnail_width');
		$config['thumbnail_height'] = Mage::getStoreConfig('productvideo/thumbnail/thumbnail_height')=='' ? 56 : Mage::getStoreConfig('productvideo/thumbnail/thumbnail_height');
		$config['thumbnail_slide'] = Mage::getStoreConfig('productvideo/thumbnail/thumbnail_slide');
		$config['thumbnail_slide_in_popup'] = Mage::getStoreConfig('productvideo/thumbnail/thumbnail_slide_in_popup');
		$config['thumbnail_slide_speed'] = Mage::getStoreConfig('productvideo/thumbnail/thumbnail_slide_speed')=='' ? 1 : Mage::getStoreConfig('productvideo/thumbnail/thumbnail_slide_speed');
		$config['thumbnail_image'] = Mage::getStoreConfig('productvideo/thumbnail/thumbnail_image')=='' ? 'default/default.jpg' : Mage::getStoreConfig('productvideo/thumbnail/thumbnail_image');
		
		return $config;
	}
	
	public function getVideoLocalConfigData(){
		$config['sound'] = Mage::getStoreConfig('productvideo/video_local_setting/sound');
		$config['buffer'] = Mage::getStoreConfig('productvideo/video_local_setting/buffer');
		$config['autoplay'] = Mage::getStoreConfig('productvideo/video_local_setting/autoplay');
		$config['click_tag'] = Mage::getStoreConfig('productvideo/video_local_setting/click_tag');
		$config['end_video_action'] = Mage::getStoreConfig('productvideo/video_local_setting/end_video_action');
		$config['use_adv'] = Mage::getStoreConfig('productvideo/video_local_setting/use_adv');
		$config['adv_url'] = Mage::getStoreConfig('productvideo/video_local_setting/adv_url');
		$config['adv_description'] = Mage::getStoreConfig('productvideo/video_local_setting/adv_description');
		$config['use_logo'] = Mage::getStoreConfig('productvideo/video_local_setting/use_logo');
		$config['logo'] = Mage::getStoreConfig('productvideo/video_local_setting/logo');
		$config['logo_position'] = Mage::getStoreConfig('productvideo/video_local_setting/logo_position');
		$config['loop'] = Mage::getStoreConfig('productvideo/video_local_setting/loop');
		/*$config['tracker'] = Mage::getStoreConfig('productvideo/video_local_setting/tracker');*/
		
		return $config;
	}
	public function getFileUploadSize(){
		$config['video_size'] = Mage::getStoreConfig('productvideo/general/video_size')=='' ? 10 : Mage::getStoreConfig('productvideo/general/video_size');
		$config['thumbnail_size'] = Mage::getStoreConfig('productvideo/thumbnail/thumbnail_size')=='' ? 1 : Mage::getStoreConfig('productvideo/thumbnail/thumbnail_size');
	
		return $config;
	}
	public function getThumbnailDefault(){
		$config['thumbnail_width'] = Mage::getStoreConfig('productvideo/thumbnail/thumbnail_width')=='' ? 56 : Mage::getStoreConfig('productvideo/thumbnail/thumbnail_width');
		$config['thumbnail_height'] = Mage::getStoreConfig('productvideo/thumbnail/thumbnail_height')=='' ? 56 : Mage::getStoreConfig('productvideo/thumbnail/thumbnail_height');
		$config['thumbnail_image'] = Mage::getStoreConfig('productvideo/thumbnail/thumbnail_image')=='' ? 'default/default.jpg' : Mage::getStoreConfig('productvideo/thumbnail/thumbnail_image');
		
		return $config;
	}
	public function getVideoDimensionConfig(){
		$config['video_width'] = Mage::getStoreConfig('productvideo/display_setting/video_width')=='' ? 256 : Mage::getStoreConfig('productvideo/display_setting/video_width');
		$config['video_height'] = Mage::getStoreConfig('productvideo/display_setting/video_height')=='' ? 150 : Mage::getStoreConfig('productvideo/display_setting/video_height');
		
		return $config;
	}
	public function getPopupDimensionConfig(){
		$config['popup_width'] = Mage::getStoreConfig('productvideo/display_setting/popup_width')=='' ? 640 : Mage::getStoreConfig('productvideo/display_setting/popup_width');
		$config['popup_height'] = Mage::getStoreConfig('productvideo/display_setting/popup_height')==''? 360 : Mage::getStoreConfig('productvideo/display_setting/popup_height');
		
		return $config;
	}
	
	public function getMediaPathUrl(){
		$path['cmsmart'] = Mage::getBaseUrl('media').'cmsmart/';
		$path['cmsmart_productvideo'] = Mage::getBaseUrl('media').'cmsmart/productvideo/';
		$path['thumbnail_product'] = Mage::getBaseUrl('media').'cmsmart/productvideo/thumbnail/product/';
		$path['video_product'] = Mage::getBaseUrl('media').'cmsmart/productvideo/video/product/';
		$path['flash_player'] = Mage::getBaseUrl('media').'cmsmart/productvideo/player.swf';
		return $path;
	}
	
	public function getUploadVideoTemplate()
	{
		return 
			Mage::app()->getLayout()
			->createBlock('core/template')
			->setTemplate('cmsmart/productvideo/uploadvideo.phtml')->toHtml();
	}
	
	/* delete video from dir */
	public function deleleVideoFileDir($id){
		$product_thumbnail_path_dir = Mage::getBaseDir('media').DS.'cmsmart'.DS.'productvideo'.DS.'thumbnail'.DS.'product';
		$product_video_path_dir = Mage::getBaseDir('media').DS.'cmsmart'.DS.'productvideo'.DS.'video'.DS.'product';
		$resultData = array();
		
		try{
			$productVideoModel = Mage::getModel('productvideo/productvideo');
			$videoData = $productVideoModel->load($id);
			
			/* DELETE VIDEO THUMBNAIL IMAGE */
			if($videoData->getThumbnail()!=''){
				$multiThumbnail = Mage::getModel('productvideo/productvideo')->getCollection()->addFieldToFilter('thumbnail',array('eq'=>$videoData->getThumbnail()))->getSize();
				if($multiThumbnail<=1){
					try{
						unlink($product_thumbnail_path_dir.DS.$videoData->getProductId().DS.$videoData->getThumbnail());
					}catch(Exception $e){
						$resultData['error'] = $e->getMessage();
					}
				}
			}
			
			/* DELETE VIDEO FILE */
			if($videoData->getProvider()==='local'){
				$multiVideo = Mage::getModel('productvideo/productvideo')->getCollection()->addFieldToFilter('video_id',array('eq'=>$videoData->getVideoId()))->getSize();
		
				if($multiVideo<=1){
					try{
						unlink($product_video_path_dir.DS.$videoData->getProductId().DS.$videoData->getVideoId());
					}catch(Exception $e){
						$resultData['error'] = $e->getMessage();
					}
				}
			}
			
		}catch(Exception $e){
			$resultData['error'] = $e->getMessage();
		}
	}
	
	public function getCurrentStoreId(){
		return Mage::app()->getStore()->getStoreId();
	}
	
	public function getAllowCustomerGroup(){
		return Mage::getStoreConfig('productvideo/display_setting/allowed_groups', $this->getCurrentStoreId());
	}
	
	public function getAllowShowVideo(){
		return Mage::getStoreConfig('productvideo/display_setting/show_upload_video', $this->getCurrentStoreId());
	}
	
	public function getAllowRateVideo(){
		return Mage::getStoreConfig('productvideo/display_setting/show_rate_video', $this->getCurrentStoreId());
	}
	
	public function getStarRating($more_class = ""){
		if($this->getAllowRateVideo()){
			$html = '
				<div class="video_rating_star '.$more_class.'">
					<label class="lab_rate">'.$this->__("Rate for this video:").'</label>
					<div id="star">
						 <ul id="star0" class="star" onmousedown="star.update(event,this)" onmousemove="star.mouse(event,this);" title="Rate This!">
						  <li id="starCur0" class="curr" title="0" style="width: 0px;"></li>
						 </ul>
						 <div style="color: rgb(136, 136, 136); display: none;" id="starUser0" class="user">0%</div>
					</div>
				</div>
				<input type="hidden" value="" name="rate" id="rate"/>
				<input type="hidden" name="current_video_id" id="current_video_id" value="">
			';
		}
		
		return $html;
	}
	
	public function getClientId(){
		return trim(Mage::getStoreConfig('productvideo/youtube_api/client_id', $this->getCurrentStoreId()));
	}
	
	public function getClientSecret(){
		return trim(Mage::getStoreConfig('productvideo/youtube_api/client_secret', $this->getCurrentStoreId()));
	}
	
	public function getAllowShowNextPre(){
		return 0;
		return Mage::getStoreConfig('productvideo/display_setting/show_next_pre', $this->getCurrentStoreId());
	}
	
	public function getTypePopup(){
		return Mage::getStoreConfig('productvideo/display_setting/display_style', $this->getCurrentStoreId());
	}
}