<?php 
/*------------------------------------
* Product Video Extention
* Author  CMSMart Team
* Copyright Copyright (C) 2012 http://cmsmart.net. All Rights Reserved.
* @license - http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
* Websites: http://cmsmart.net
* Email: team@cmsmart.net
* Technical Support: http://cmsmart.net/support_ticket/
* Forum - http://cmsmart.net/forum
* Version 3.0.0
-----------------------------------------------------*/

	class Cmsmart_Productvideo_MediaController extends Mage_Core_Controller_Front_Action
	{
		public function indexAction(){
			$this->loadLayout();
			$this->renderLayout();
		}
		
		public function changeVideoAction(){
			$postData = $this->getRequest()->getPost();;
			$resultData = array();
			$config = Mage::helper('productvideo')->getVideoDimensionConfig();
			
			$videoData = Mage::getModel('productvideo/productvideo')->load($postData['vid']);
			
			if($videoData->getProvider() && $videoData->getProvider()!=''){
				$resultData['html'] = $this->changeVideo($videoData,$config['video_width'],$config['video_height']);
				$resultData['current_video'] = $postData['vid'];
				$resultData['current_rate_video'] = Mage::getModel('productvideo/productvideo')->getVideoRate($postData['vid']);
			}else{
				$resultData['error'] = $this->__('Can not find this video');
			}
			echo json_encode($resultData);
		}
		
		public function changePopupVideoAction(){
			$postData = $this->getRequest()->getPost();;
			$resultData = array();
			$model_video = Mage::getModel('productvideo/productvideo');
			
			$config = Mage::helper('productvideo')->getPopupDimensionConfig();
			
			$videoData = $model_video->load($postData['vid']);
			
			if($videoData->getProvider() && $videoData->getProvider()!=''){
				$resultData['html'] = $this->changeVideo($videoData,$config['popup_width'],$config['popup_height']);
			}else{
				$resultData['error'] = $this->__('Can not find this video');
			}
			
			/* fixcode */
			$videos = $model_video->getVideoCollectionOfProduct($videoData->getProductId());

			$video_arr = array();
			foreach($videos as $v){
				$video_arr[] = $v->getProductvideoId();
			} 
			$index = array_search($postData['vid'], $video_arr);
			$resultData['next_video'] = $video_arr[$index+1];
			$resultData['previous_video'] = $video_arr[$index-1];
			
			/* if next last element then next to start element */
			/* if($video_arr[$index+1] == $video_arr[count[$video_arr]-1]) 
				$resultData['next_video'] = $video_arr[0]; */
			
			/* if next last element then next to start element */
			/* if($video_arr[$index] == $video_arr[0]) 
				$resultData['previous_video'] = $video_arr[count($video_arr)-1]; */
			
			//echo $video_arr[$index];
			
			$resultData['current_video'] = $video_arr[$index];
			$resultData['current_rate_video'] = $model_video->getVideoRate($video_arr[$index]);
			/*end fixcode*/
			
			echo json_encode($resultData);
		}
		
		public function openPopupAction(){
			$postData = $this->getRequest()->getPost();
			$resultData = array();
			$model_video = Mage::getModel('productvideo/productvideo');
			
			$productData = Mage::getModel('catalog/product')->load($postData['pid']);
			$videos = $model_video->getVideoCollectionOfProduct($postData['pid']);

			/* fixcode get video ids */
			/* $video_arr = array();
			foreach($videos as $v){
				$video_arr[] = $v->getProductvideoId();
			} */ 
			
			$config = Mage::helper('productvideo')->getConfigData();
			$pathUrl = Mage::helper('productvideo')->getMediaPathUrl();
			
			if($postData['type']==='together_popup' || $postData['type']==='bar_popup' || $postData['type']==='bottom_popup'){
				
				
				/* POPUP DISPLAY CONTENT */
				$resultData['html'] = '<div id="productvideo-popup-display-item" class="" style="min-height:'.$config['popup_height'].'px" >';
				
				if(isset($postData['vid']) && $postData['vid']!=''){
					$videoData = Mage::getModel('productvideo/productvideo')->load($postData['vid']);
					if($videoData->getProvider() && $videoData->getProvider()!=''){
						$resultData['html'] .= $this->changeVideo($videoData,$config['popup_width'],$config['popup_height']);
					}else{
						$resultData['error'] = $this->__('Can not find this video');
					}
				}elseif(isset($postData['iid']) && $postData['iid']!=''){
					foreach($productData->getMediaGalleryImages() as $image){
						if($image->getValueId()==$postData['iid']){
							$_imghtml = '<img id="popup-image" width="'.$config['popup_width'].'" height="'.$config['popup_height'].'" src="'.$image->getUrl().'" alt="'.Mage::helper('core')->escapeHtml($image->getLabel()).'" title="'.Mage::helper('core')->escapeHtml($image->getLabel()).'"/>';
							$resultData['html'] .= Mage::helper('catalog/output')->productAttribute($productData, $_imghtml, 'image');
						}
					}
				}
				
				$resultData['html'] .= '</div>';
				/* END POPUP DISPLAY CONTENT */
				
				
				
				/* POPUP LIST ITEM CONTENT */
				if($config['thumbnail_slide_in_popup'] && $postData['type']==='together_popup'){
					$resultData['html'] .= '<div class="productvideo-popup-list-item-title">'.$this->__('More views').'</div>';
					$resultData['html'] .= '<div class="productvideo-image-slider-content-wrapper">';
					/* $resultData['html'] .= '<span onclick="imageSliderBackButton(this,'.$config['thumbnail_slide_speed'].');" title="'.$this->__('Back').'" class="productvideo-image-slider-back-button productvideo-image-slider-button disable" style="height:'.$config['thumbnail_height'].'px"></span>'; */
					$resultData['html'] .= '<div class="productvideo-image-slider-wrapper">';
					$resultData['html'] .= '<div class="box-nav"><a href="#" class="prev"></a> <a href="#" class="next"></a></div>';
					$resultData['html'] .= '<div class="productvideo-popup-list-item productvideo-image-slider">'; 
				}elseif(!$config['thumbnail_slide_in_popup'] && $postData['type']==='together_popup'){
					$resultData['html'] .= '<div class="productvideo-popup-list-item-title">'.$this->__('More views').'</div>';
					$resultData['html'] .= '<div class="productvideo-popup-list-item">';
				}
				if(count($productData->getMediaGalleryImages())>0 && ((isset($postData['iid']) && $postData['iid']!='') || $postData['type']==='together_popup' || $postData['type']==='bottom_popup')){
					
					/* fixcode next/previous */
					/*comment*/
					/* if($postData['type']=='bar_popup' || $postData['type']=='bottom_popup' && Mage::helper('productvideo')->getAllowShowNextPre()){
						$resultData['html'] .= '<a href="#" class="next" id="nb_prevStaticLink" style="display: none;" onClick = "my_next_pre_image(\'pre\'); return false;"></a><a href="#" class="prev" id="nb_nextStaticLink" style="display: none;" onClick = "my_next_pre_image(\'next\'); return false;"></a>';
					} */
					
					if($config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						
						$resultData['html'] .= '<div class="productvideo-popup-list-item-title image';
						if(isset($postData['iid']) && $postData['iid']!=''){
							$resultData['html'] .= ' selected">'.$this->__('Images').'</div>';
						}else{
							$resultData['html'] .= '">'.$this->__('Images').'</div>';
						}
						$resultData['html'] .= '<div class="productvideo-image-slider-content-wrapper">';
						/* $resultData['html'] .= '<span onclick="imageSliderBackButton(this,'.$config['thumbnail_slide_speed'].');" title="'.$this->__('Back').'" class="productvideo-image-slider-back-button productvideo-image-slider-button disable" style="height:'.$config['thumbnail_height'].'px"></span>'; */
						$resultData['html'] .= '<div class="productvideo-image-slider-wrapper">';
						/* next-pre for popup in style 03 */
						$resultData['html'] .= '<div class="box-nav-image"><a href="#" class="prev"></a> <a href="#" class="next"></a></div>';
						$resultData['html'] .= '<div class="productvideo-popup-list-item productvideo-image-slider productvideo-image-slider-image">';
						
					}elseif(!$config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
					
						$resultData['html'] .= '<div class="productvideo-popup-list-item-title image';
						if(isset($postData['iid']) && $postData['iid']!=''){
							$resultData['html'] .= ' selected">'.$this->__('Images').'</div>';
						}else{
							$resultData['html'] .= '">'.$this->__('Images').'</div>';
						}
						$resultData['html'] .= '<div class="productvideo-popup-list-item">';
					}
					
					foreach($productData->getMediaGalleryImages() as $image){
						$tmpClass = '';
						$tmpStyle = '';
						if($config['thumbnail_slide_in_popup']){
							$tmpStyle = 'width:'.$config['thumbnail_width'].'px';
						}
						if(isset($postData['iid']) && $postData['iid']!='' && $image->getValueId()==$postData['iid']){
							$tmpClass .= 'selected';
						}
						$resultData['html'] .= '<a href="#" class="productvideo-popup-item '.$tmpClass.'" onclick="return false;">
						<img class="image" width="'.$config['thumbnail_width'].'" height="'.$config['thumbnail_height'].'" src="'.$image->getUrl().'" alt="'.Mage::helper('core')->escapeHtml($image->getLabel()).'" title="'.Mage::helper('core')->escapeHtml($image->getLabel()).'"/></a>';
					}
					
					if($config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '</div>';
						$resultData['html'] .= '</div>';
						// $resultData['html'] .= '<span onclick="imageSliderNextButton(this,'.$config['thumbnail_slide_speed'].');"  title="'.$this->__('Next').'" class="productvideo-image-slider-next-button productvideo-image-slider-button" style="height:'.$config['thumbnail_height'].'px"></span>';
						$resultData['html'] .= '</div>';
					}elseif(!$config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '</div>';
					}
				}
				

				if($videos->getSize()>0 && ((isset($postData['vid']) && $postData['vid']!='') || $postData['type']==='together_popup'|| $postData['type']==='bottom_popup')){
					
					/* fixcode set value for current video_id */
					/* $index = array_search($postData['vid'], $video_arr);
					$resultData['html'] .= '<input type="hidden" name="next_video_id" id="next_video_id" value="'.$video_arr[$index+1].'">';
					$resultData['html'] .= '<input type="hidden" name="pre_video_id" id="pre_video_id" value="'.$video_arr[$index-1].'">'; */
					$resultData['html'] .= '<input type="hidden" name="current_video_id" id="current_video_id" value="'.$postData['vid'].'">'; 
					$resultData['html'] .= '<input type="hidden" name="rate_video_id" id="rate_video_id" value="'.$model_video->getVideoRate($postData['vid']).'">';
					$resultData['html'] .= '<input type="hidden" value="" name="rate" id="rate"/>'; /* rating when click star */
 
					
					/* fixcode next/previous */
					//$resultData['html'] .= '<a href="#" id="nb_prevStaticLink" onClick = "my_next_pre(\'pre\'); return false;"><span>Prev</span></a> / <a href="#" id="nb_nextStaticLink" onClick = "my_next_pre(\'next\'); return false;"><span>Next</span></a>';
					/*comment*/ 
					/* if($postData['type']=='bar_popup' && Mage::helper('productvideo')->getAllowShowNextPre()){
						$resultData['html'] .= '<a href="#" class="prev" id="nb_prevStaticLink" style="display: none;" onClick = "my_next_pre(\'pre\'); return false;"></a><a href="#" class="next" id="nb_nextStaticLink" style="display: none;" onClick = "my_next_pre(\'next\'); return false;"></a>';
					} */
					
					/* fixcode rating star */
					/* RATE VIDEO 05 */
					if(($postData['type']=='bottom_popup'||$postData['type']=='bar_popup') && Mage::helper('productvideo')->getAllowRateVideo()){
						$resultData['html'] .= '
								<div class="upload-video-write_review-table-row">
									<label class="lab_rate">'.$this->__("Rate for this video:").'</label>
									<div id="star">
										 <ul id="star0" class="star" onmousedown="star.update(event,this)" onmousemove="star.mouse(event,this);" title="Rate This!">
										  <li id="starCur0" class="curr" title="0" style="width:'. $model_video->getVideoRate($postData['vid']) .'px;"></li>
										 </ul>
										 <div style="color: rgb(136, 136, 136); display: none;" id="starUser0" class="user">0%</div>
									</div>
								</div>
								';	
					}					
					
					if($config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '<div class="productvideo-popup-list-item-title video';
						if(isset($postData['vid']) && $postData['vid']!=''){
							$resultData['html'] .= ' selected">'.$this->__('Videos').'</div>';
						}else{
							$resultData['html'] .= '">'.$this->__('Videos').'</div>';
						}
						$resultData['html'] .= '<div class="productvideo-image-slider-content-wrapper">';
						/* $resultData['html'] .= '<span onclick="imageSliderBackButton(this,'.$config['thumbnail_slide_speed'].');" title="'.$this->__('Back').'" class="productvideo-image-slider-back-button productvideo-image-slider-button disable" style="height:'.$config['thumbnail_height'].'px"></span>'; */
						/* next-pre for popup in style 03 */ 
						$resultData['html'] .= '<div class="productvideo-image-slider-wrapper">';
						$resultData['html'] .= '<div class="box-nav"><a href="#" class="prev"></a> <a href="#" class="next"></a></div>';
						$resultData['html'] .= '<div class="productvideo-popup-list-item productvideo-image-slider productvideo-image-slider-video">';
					}elseif(!$config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '<div class="productvideo-popup-list-item-title video';
						if(isset($postData['vid']) && $postData['vid']!=''){
							$resultData['html'] .= ' selected">'.$this->__('Videos').'</div>';
						}else{
							$resultData['html'] .= '">'.$this->__('Videos').'</div>';
						}
						$resultData['html'] .= '<div class="productvideo-popup-list-item">';
					}
					
					foreach ($videos as $video){
						$tmpClass = '';
						$tmpStyle = '';
						if($config['thumbnail_slide_in_popup']){
							$tmpStyle = 'width:'.$config['thumbnail_width'].'px';
						}
						if(isset($postData['vid']) && $postData['vid']!='' && $video->getProductvideoId()==$postData['vid']){
							$tmpClass .= 'selected';
						}
						if($video->getThumbnail()!==''){
							$video_thumbnail_path_url = $pathUrl['thumbnail_product'].$postData['pid'].'/'.$video->getThumbnail();
						}else{
							$video_thumbnail_path_url = $pathUrl['thumbnail_product'].$config['thumbnail_image'];
						}
						$resultData['html'] .= '<a href="#" class="productvideo-popup-item '.$tmpClass.'" onclick="return false;"><img id="productvideo-id-'.$video->getProductvideoId().'" class="video" src="'.$video_thumbnail_path_url.'" title="'.$video->getVideoName().'" width="'.$config['thumbnail_width'].'" height="'.$config['thumbnail_height'].'" alt="'.$video->getVideoId().'" />';
						if($config['show_play_icon']){
							$resultData['html'] .= '<span class="productvideo-play-icon"></span>';
						}
						$resultData['html'] .= '</a>';
					}
					
					if($config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '</div>';
						$resultData['html'] .= '</div>';
						// $resultData['html'] .= '<span onclick="imageSliderNextButton(this,'.$config['thumbnail_slide_speed'].');"  title="'.$this->__('Next').'" class="productvideo-image-slider-next-button productvideo-image-slider-button" style="height:'.$config['thumbnail_height'].'px"></span>';
						$resultData['html'] .= '</div>';
					}elseif(!$config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '</div>';
					}			
				}
				/* END POPUP LIST ITEM CONTENT */
				
				if($config['thumbnail_slide_in_popup'] && $postData['type']==='together_popup'){
					$resultData['html'] .= '</div>';
					$resultData['html'] .= '</div>';
					$resultData['html'] .= '</div>';
				}elseif(!$config['thumbnail_slide_in_popup'] && $postData['type']==='together_popup'){
					$resultData['html'] .= '</div>';
					$resultData['html'] .= '</div>';
				}
				/* POPUP Javascript */
				$changePopupVideo = Mage::getUrl('productvideo/media/changePopupVideo', array('_secure'=>(!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']==='on')));
				/* for click thumb video on list */
				
				$resultData['html'] .='<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery(".bottom_popup div.productvideo-image-slider-image").owlCarousel({
					items: 4,
					itemsCustom: [ 
					 [0,4], 
					 [480,4], 
					 [768,4], 
					 [992,4], 
					 [1200,6] 
					],
					pagination: false,
					slideSpeed : 800,
					 afterAction: function (e) {
					   if(this.$owlItems.length > this.options.items){
						   jQuery(".bottom_popup .box-nav").show();
					   }else{
						   jQuery(".bottom_popup .box-nav").hide();
					   }
					}            
						});
							jQuery(".bottom_popup .box-nav-image .prev").on("click", function(e){
						e.preventDefault();
						jQuery(".bottom_popup div.productvideo-image-slider-image").trigger("owl.prev");
						});
						jQuery(".bottom_popup .box-nav-image .next").on("click", function(e){
						e.preventDefault();
						jQuery(".bottom_popup div.productvideo-image-slider-image").trigger("owl.next");
					 }); 
					 jQuery(".bottom_popup div.productvideo-image-slider-video").owlCarousel({
					items: 4,
					itemsCustom: [ 
					 [0,4], 
					 [480,4], 
					 [768,4], 
					 [992,4], 
					 [1200,6] 
					],
					pagination: false,
					slideSpeed : 800,
					 afterAction: function (e) {
					   if(this.$owlItems.length > this.options.items){
						   jQuery(".bottom_popup .box-nav").show();
					   }else{
						   jQuery(".bottom_popup .box-nav").hide();
					   }
					}            
						});
							jQuery(".bottom_popup .box-nav .prev").on("click", function(e){
						e.preventDefault();
						jQuery(".bottom_popup div.productvideo-image-slider-video").trigger("owl.prev");
						});
						jQuery(".bottom_popup .box-nav .next").on("click", function(e){
						e.preventDefault();
						jQuery(".bottom_popup div.productvideo-image-slider-video").trigger("owl.next");
					 }); 
					jQuery(".together_popup div.productvideo-image-slider").owlCarousel({
					items: 4,
					itemsCustom: [ 
					 [0,4], 
					 [480,4], 
					 [768,4], 
					 [992,4], 
					 [1200,6] 
					],
					pagination: false,
					slideSpeed : 800,
					 afterAction: function (e) {
					   if(this.$owlItems.length > this.options.items){
						   jQuery(".together_popup .box-nav").show();
					   }else{
						   jQuery(".together_popup .box-nav").hide();
					   }
					}            
						});
						jQuery(".together_popup .box-nav .prev").on("click", function(e){
						e.preventDefault();
						jQuery(".together_popup div.productvideo-image-slider").trigger("owl.prev");
						});
						jQuery(".together_popup .box-nav .next").on("click", function(e){
						e.preventDefault();
						jQuery(".together_popup div.productvideo-image-slider").trigger("owl.next");
					 }); 
					jQuery(".bar_popup div.productvideo-image-slider-image").owlCarousel({
					items: 4,
					itemsCustom: [ 
					 [0,4], 
					 [480,4], 
					 [768,4], 
					 [992,4], 
					 [1200,6] 
					],
					pagination: false,
					slideSpeed : 800,
					 afterAction: function (e) {
					   if(this.$owlItems.length > this.options.items){
						   jQuery(".bar_popup .box-nav-image").show();
					   }else{
						   jQuery(".bar_popup .box-nav-image").hide();
					   }
					}            
						});
						jQuery(".bar_popup .box-nav-image .prev").on("click", function(e){
						e.preventDefault();
						jQuery(".bar_popup div.productvideo-image-slider-image").trigger("owl.prev");
						});
						jQuery(".bar_popup .box-nav-image .next").on("click", function(e){
						e.preventDefault();
						jQuery(".bar_popup div.productvideo-image-slider-image").trigger("owl.next");
					 }); 
					jQuery(".bar_popup div.productvideo-image-slider-video").owlCarousel({
					items: 4,
					itemsCustom: [ 
					 [0,4], 
					 [480,4], 
					 [768,4], 
					 [992,4], 
					 [1200,6] 
					],
					pagination: false,
					slideSpeed : 800,
					 afterAction: function (e) {
					   if(this.$owlItems.length > this.options.items){
						   jQuery(".bar_popup .box-nav").show();
					   }else{
						   jQuery(".bar_popup .box-nav").hide();
					   }
					}            
						});
						jQuery(".bar_popup .box-nav .prev").on("click", function(e){
						e.preventDefault();
						jQuery(".bar_popup div.productvideo-image-slider-video").trigger("owl.prev");
						});
						jQuery(".bar_popup .box-nav .next").on("click", function(e){
						e.preventDefault();
						jQuery(".bar_popup div.productvideo-image-slider-video").trigger("owl.next");
					 }); 
					
					jQuery(".productvideo-popup-item").click(function(){
						popupAthumbnail=jQuery(this);
						popupThumbnail=jQuery(this).children("img");
						if(!popupAthumbnail.hasClass("selected")){
							if(popupThumbnail.hasClass("video")){
								vid=popupThumbnail.attr("id").replace("productvideo-id-","");
								jQuery.ajax({
									type:"POST",url:"'.$changePopupVideo.'",
									data:{"vid":vid},
									beforeSend:function(){
										jQuery("#productvideo-popup-content-ajax").css("-moz-opacity:","0.2");
										jQuery("#productvideo-popup-content-ajax").css("-webkit-opacity","0.2");
										jQuery("#productvideo-popup-content-ajax").css("-ms-filter","progid:DXImageTransform.Microsoft.Alpha(Opacity=20)");
										jQuery("#productvideo-popup-content-ajax").css("opacity","0.2");
										jQuery("#productvideo-popup-display-item").html("");
										jQuery("#productvideo-popup-ajaxloading").css("display","block");},
									success:function(data){},
									complete:function(data){
										var responseData=jQuery.parseJSON(data.responseText);
										if(responseData.error){
											alert(responseData.error);
										}else{
											jQuery("#productvideo-popup-content-ajax").css("-moz-opacity:","1");
											jQuery("#productvideo-popup-content-ajax").css("-webkit-opacity","1");
											jQuery("#productvideo-popup-content-ajax").css("-ms-filter","progid:DXImageTransform.Microsoft.Alpha(Opacity=100)");
											jQuery("#productvideo-popup-content-ajax").css("opacity","1");
											jQuery(".productvideo-popup-item").removeClass("selected");
											popupAthumbnail.addClass("selected");
											jQuery("#productvideo-popup-ajaxloading").css("display","none");
											jQuery("#productvideo-popup-display-item").html(responseData.html);
											/* document.getElementById("next_video_id").value = responseData.next_video;
											document.getElementById("pre_video_id").value = responseData.previous_video; */
											document.getElementById("current_video_id").value = responseData.current_video; 
											document.getElementById("rate_video_id").value = responseData.current_rate_video;
											jQuery("#starCur0").css("width", document.getElementById("rate_video_id").value);
										}
									},error:function(response){
										alert(response.responseText);
									}
								});
							}
							if(popupThumbnail.hasClass("image")){
								isrc = popupThumbnail.attr("src");
								ilabel = popupThumbnail.attr("label");
								ititle = popupThumbnail.attr("title");
								jQuery(".productvideo-popup-item").removeClass("selected");
								popupAthumbnail.addClass("selected");
								jQuery("#productvideo-popup-display-item").html(\'<img id="popup-image" src="\'+isrc+\'" alt="\'+ilabel+\'" title="\'+ititle+\'" />\');
							}
						}
					});
					jQuery(".productvideo-play-icon").hover(function(){jQuery(this).animate({opacity: 1},500);},function(){jQuery(this).animate({opacity: 0.3},500);});
					jQuery("#productvideo-popup-content-ajax.bottom_popup .productvideo-popup-item").click(function(){
						jQuery("#productvideo-popup-content-ajax .productvideo-popup-list-item-title").removeClass("selected");
						titleClass = jQuery(this).children("img").attr("class");
						jQuery("#productvideo-popup-content-ajax .productvideo-popup-list-item-title").each(function(){
							if(jQuery(this).hasClass(titleClass)){
								jQuery(this).addClass("selected");
							}
						});
					});
				});
				</script>';
				
				/*$resultData['html'] .='<script type="text/javascript" src="'.Mage::getDesign()->getSkinUrl('js/cmsmart/productvideo/cmsmart_productvideo_popup.js').'"></script>';*/
				
				if($config['thumbnail_slide_in_popup']){
					$resultData['html'] .='<script type="text/javascript" src="'.Mage::getDesign()->getSkinUrl('js/cmsmart/productvideo/cmsmart_productvideo_slide.js').'"></script>';
				}
				/* END POPUP Javascript */
				
			}else{
				$resultData['error'] = $this->__('Display type is not defined!!!');
			}
			echo json_encode($resultData);
		}
		
		protected function changeVideo($videoData,$width=0,$height=0){
			$resultData = '';
			
			$pathUrl = Mage::helper('productvideo')->getMediaPathUrl();
			$config = Mage::helper('productvideo')->getConfigData();
			
			if($videoData->getThumbnail()!=''){
				$video_thumbnail_path_url = $pathUrl['thumbnail_product'].$videoData->getProductId().'/'.$videoData->getThumbnail();
			}else{
				$video_thumbnail_path_url = $pathUrl['thumbnail_product'].$config['thumbnail_image'];
			}
			
			if($videoData->getProvider()=='youtube'){
			
				/* RESULT YOUTUBE VIDEO HTML DATA */
				$resultData = '<iframe src="//www.youtube.com/embed/'.$videoData->getVideoId().'?wmode=opaque" height="'.$height.'" frameborder="0"  webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
				
				
			}elseif($videoData->getProvider()=='vimeo'){
				
				/* RESULT VIMEO VIDEO HTML DATA */
				$enableApi = 1;
				$playerId = 'vimeoplayer';
				$showTitle = 'false';
				$showPortrait = 'false';
				$autoPlay = 'false';
				$vimeoLoop = 'false';
				$autoPause = 'true';
				$controlColor = '';
				
				$resultData = '<iframe src="//player.vimeo.com/video/'.$videoData->getVideoId().'?api='.$enableApi.'&player_id='.$playerId.'&title='.$showTitle.'&height='.$height.'&portrait='.$showPortrait.'&autoplay='.$autoPlay.'&loop='.$vimeoLoop.'&autopause='.$autoPause.'" height="'.$height.'" frameborder="0"  webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
				
				/*if($enableApi){
					$resultData .= '<script type="text/javascript">
						jQuery(document).ready(function(){
							jQuery(".productvideo-tab-item").click(function(){
									document.getElementById("'.$playerId.'").api_pause();
							});
						});
						</script>';
				}*/
				
			}elseif($videoData->getProvider()=='dailymotion'){
				$resultData = '<iframe frameborder="0" height="'.$height.'" src="//www.dailymotion.com/embed/video/'.$videoData->getVideoId().'" allowfullscreen></iframe>';
			}elseif($videoData->getProvider()=='twitch'){
				$resultData = '
				<object type="application/x-shockwave-flash" height="'.$height.'" id="live_embed_player_flash" data="http://www.twitch.tv/widgets/live_embed_player.swf?channel='.$videoData->getVideoId().'" bgcolor="#000000"><param name="allowFullScreen" value="true" />
					<param name="allowScriptAccess" value="always" />
					<param name="allowNetworking" value="all" />
					<param name="movie" value="http://www.twitch.tv/widgets/live_embed_player.swf" />
					<param name="flashvars" value="hostname=www.twitch.tv&channel='.$videoData->getVideoId().'&auto_play=true&start_volume=25" />
				</object>
			';
			}elseif($videoData->getProvider()=='local'){
			
				/* RESULT LOCAL VIDEO HTML DATA */
				$videoLocalConfig = Mage::helper('productvideo')->getVideoLocalConfigData();
				
				$iframeSrc .= 'vdo='.$pathUrl['video_product'].$videoData->getProductId().'/'.$videoData->getVideoId();
				$iframeSrc .= '&splashscreen='.$video_thumbnail_path_url;
				$iframeSrc .= '&sound='.$videoLocalConfig['sound'];
				$iframeSrc .= '&buffer='.$videoLocalConfig['buffer'];
				if($videoLocalConfig['autoplay']==0): $iframeSrc .='&autoplay=false';
				else: $iframeSrc .='&autoplay=true'; endif;
				if($videoLocalConfig['click_tag']!=='') $iframeSrc .='&clickTAG='.$videoLocalConfig['click_tag'];
				if($videoLocalConfig['end_video_action']!=='') $iframeSrc .='&endclipaction='.$videoLocalConfig['end_video_action'];
				if($videoLocalConfig['use_adv']==1){
					$iframeSrc .= '&advert='.$videoLocalConfig['adv_url'];
					$iframeSrc .= '&advertdesc='.$videoLocalConfig['adv_description'];
				}
				/* if($videoLocalConfig['use_logo']==1){
					$iframeSrc .= '&mylogo='.$videoLocalConfig['logo'];
					$iframeSrc .= '&logoposition='.$videoLocalConfig['logo_position'];
				} */
				if($videoLocalConfig['loop']==0): $iframeSrc .='&loop=false';
				else: $iframeSrc .='&loop=true'; endif;
				/*
				$iframeSrc .= '&tracker=$videoLocalConfig['tracker']';
				;*/
				
				$resultData = '<embed height="'.$height.'" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" allowscriptaccess="always" wmode="transparent" quality="best" allowfullscreen="true" flashvars="&'. $iframeSrc.'" src="'.$pathUrl['flash_player'].'">';
				
			}
			
			$popup_style = Mage::app()->getRequest()->getParam('popup_style');
			$config = Mage::helper('productvideo')->getConfigData();
			
			if($popup_style != "02" && $config['display_style']!='bar_popup' && $config['display_style']!='bottom_popup' && $popup_style != "01" )
				$resultData .= Mage::helper('productvideo')->getStarRating("style_popup");
			
			return($resultData);
		}
		
		public function updateVideoRateAction(){
			die("test here");
		}
	}