<?php 
	class Cmsmart_Productvideo_IndexController extends Mage_Core_Controller_Front_Action
	{
		public function indexAction(){
			$this->loadLayout();
			$this->renderLayout();
		}
		public function addVideoAction(){
			$product_thumbnail_path_dir = Mage::getBaseDir('media').DS.'cmsmart'.DS.'productvideo'.DS.'thumbnail'.DS.'product';
			$product_video_path_dir = Mage::getBaseDir('media').DS.'cmsmart'.DS.'productvideo'.DS.'video'.DS.'product';
			$product_thumbnail_path_url = Mage::getBaseUrl('media').'cmsmart/productvideo/thumbnail/product/';
			
			$postData = $this->getRequest()->getPost();
			$resultData = array();
			$videoData = array();
			$videoId = '';
			$videoName = '';
			$videoThumbnail = '';
			$thumbnailUrl = '';
			$productVideoModel = Mage::getModel('productvideo/productvideo');
			
			/* CHECK ACTION TYPE */
			if(isset($postData) && $postData['action-type']==='add'){
			
				/* ADD NEW VIDEO FROM YOUTUBE OR VIMEO */
				if(strpos($postData['video-url'], 'youtu')!==FALSE){
					$videoData['provider'] = 'youtube';
					$youtubeId  = '';
					
					/* GET YOUTUBE VIDEO ID */
					if(strpos($postData['video-url'],'youtube.com')!==FALSE){
					
						/* http://www.youtube.com/embed/VIDEOID
						http://www.youtube.com/embed/VIDEOID?modestbranding=1&amp;rel=0
						http://www.youtube.com/v/VIDEO-ID?fs=1&amp;hl=en_US */
						$videoIdRegex = '/youtube.com\/(?:embed|v){1}\/([a-zA-Z0-9_\-]+)\??/i';
						if(!preg_match($videoIdRegex, $postData['video-url'], $results)){
							/* http://www.youtube.com/watch?v=VIDEOID */
							$videoIdRegex = '/youtube.com\/(?:watch\?v=){1}([a-zA-Z0-9_\-]+)\??/i';
						}
						
					} elseif(strpos($postData['video-url'],'youtu.be') !== FALSE){
						/* http://youtu.be/VIDEOID */
						$videoIdRegex = '/youtu.be\/([a-zA-Z0-9_]+)\??/i';
					}
					
					preg_match($videoIdRegex, $postData['video-url'], $results);
					$youtubeId = $results[1];
					$youtubeData = file_get_contents('http://gdata.youtube.com/feeds/api/videos/'.$youtubeId.'?v=2&alt=jsonc');
					$youtubeData = json_decode($youtubeData)->data;
					
					if($youtubeId!='' && $youtubeData->title){
						$videoId = $youtubeId;
						
						if($postData['video-name']===''){
							$videoName = $youtubeData->title;
						}else{
							$videoName = $postData['video-name'];
						}
						
						if(!isset($_FILES['video-thumbnail']['name']) || $_FILES['video-thumbnail']['name']!=''){
							$thumbnailUrl = $youtubeData->thumbnail->hqDefault;
						}
						
					}else{
						$resultData['error'] = $this->__('Video URL invalid');
					}
				}elseif(strpos($postData['video-url'], 'vimeo')!==FALSE){
					$videoData['provider'] = 'vimeo';
					$vimeoId = '';
					
					/* GET VIMEO VIDEO ID */
					if(strpos($video, 'player.vimeo.com')!==FALSE){
						/* http://player.vimeo.com/video/VIDEOID?title=0&amp;byline=0&amp;portrait=0 */
						$videoIdRegex = '/player.vimeo.com\/video\/([0-9]+)\??/i';
					} else {
						/* http://vimeo.com/VIDEOID */
						$videoIdRegex = '/vimeo.com\/([0-9]+)\??/i';
					}
					
					preg_match($videoIdRegex, $postData['video-url'], $results);
					$vimeoId = $results[1];
					$vimeoData = unserialize(file_get_contents('http://vimeo.com/api/v2/video/'.$vimeoId.'.php'));
					$vimeoData = $vimeoData[0];
					
					if($vimeoId!='' && $vimeoData['title']){
						$videoId = $vimeoId;
						
						if($postData['video-name']===''){
							$videoName = $vimeoData['title'];
						}else{
							$videoName = $postData['video-name'];
						}
						
						if(!isset($_FILES['video-thumbnail']['name']) || $_FILES['video-thumbnail']['name']!=''){
							$thumbnailUrl = $vimeoData['thumbnail_large'];
						}
						
					}else{
						$resultData['error'] = $this->__('Video URL invalid');
					}
				}else{
					$resultData['error'] = $this->__('Video URL invalid');
				}
			}elseif(isset($postData) && $postData['action-type']==='upload'){
			
				/* ADD NEW VIDEO FROM LOCAL HOST */
				$videoData['provider'] = 'local';
				$videoCol = Mage::getModel('productvideo/productvideo')->getCollection();
				$videoType = '';
				if($_FILES['video-file']['type']==='video/x-flv'){
					$videoType = 'flv';
				}elseif($_FILES['video-file']['type']==='video/mp4'){
					$videoType = 'mp4';
				}
				if($videoCol->getSize() > 0){
					$videoId = 'video-local-'.$videoCol->getLastItem()->getProductvideoId().'.'.$videoType;
				}else{
					$videoId = 'video-local.'.$videoType;
				}
				if($postData['video-name']!==''){
					$videoName = $postData['video-name'];
				}
				
				if(isset($_FILES['video-file']['name']) && $_FILES['video-file']['name']!=''){
					try{
						if(!is_dir($product_video_path_dir.DS.$postData['product-id'].DS)) mkdir($product_video_path_dir.DS.$postData['product-id'].DS,0755);
						$uploader = new Varien_File_Uploader('video-file');
						$uploader->setAllowedExtensions(array('mp4','flv'));
						$uploader->setAllowRenameFiles(false);
						$uploader->setFilesDispersion(false);
						$uploader->save($product_video_path_dir.DS.$postData['product-id'].DS, $videoId);
						
					}catch(Exception $e) {	
						$resultData['error'] = $e->getMessage();
					}
				}else{
					$resultData['error'] = $this->__('Video path invalid');
				}
			}
			
			if($videoId!=''){
			
				/* CREATE THUMBNAIL IMAGE */
				if(!is_dir($product_thumbnail_path_dir.DS.$postData['product-id'].DS)) mkdir($product_thumbnail_path_dir.DS.$postData['product-id'].DS,0755);
				
				if(isset($_FILES['video-thumbnail']['name']) && $_FILES['video-thumbnail']['name']!=''){
					$thumbnailType = '';
					if($_FILES['video-thumbnail']['type']==='image/png'){
						$thumbnailType = '.png';
					}elseif($_FILES['video-thumbnail']['type']==='image/jpg' || $_FILES['video-thumbnail']['type']==='image/jpeg'){
						$thumbnailType = '.jpg';
					}elseif($_FILES['video-thumbnail']['type']==='image/gif'){
						$thumbnailType = '.gif';
					}
					$videoThumbnail = time().$thumbnailType;
					try{
						$uploader = new Varien_File_Uploader('video-thumbnail');
						$uploader->setAllowedExtensions(array('jpg','jpeg','gif','png'));
						$uploader->setAllowRenameFiles(false);
						$uploader->setFilesDispersion(false);
						$uploader->save($product_thumbnail_path_dir.DS.$postData['product-id'].DS, $videoThumbnail);
						
					}catch(Exception $e) {	
						$resultData['error'] = $e->getMessage();
					}
				}elseif($thumbnailUrl!==''){
					try{
						$thumbnail_image = file_get_contents($thumbnailUrl);
						$thumbnail_loc = $product_thumbnail_path_dir.DS.$postData['product-id'].DS.$videoId.'.jpg';
						$thumbnail_handler = fopen($thumbnail_loc,'w');	
						fwrite($thumbnail_handler,$thumbnail_image);
						fclose($thumbnail_handler);
						
						$videoThumbnail = $videoId.'.jpg';
						
					}catch(Exception $e){
						$resultData['error'] = $e->getMessage();
					}
				}
			
				/* ADD DATA TO cmsmart_productvideo TABLE */
				try{
					$videoData['product_id'] = $postData['product-id'];
					$videoData['video_name'] = $videoName;
					$videoData['video_id'] = $videoId;
					$videoData['thumbnail'] = $videoThumbnail;
					$videoData['position'] = $postData['video-order'];
					$videoData['status'] = $postData['video-exclude']==='true' ?  0 : 1;
					$videoData['count_play'] = 0;
					
					$productVideoModel = Mage::getModel('productvideo/productvideo');
					$productVideoModel->addData($videoData);
					$productVideoModel->save();
					
					$resultData['vid'] = $productVideoModel->getProductvideoId();

				}catch(Exception $e){
					$resultData['error'] = $e->getMessage();
				}
			}
			
			if(!isset($resultData['error']) && isset($resultData['vid'])){
			
				/* MAKE HTML RESULT DATA */
				/* ACTION URL */
				$deleteVideoUrl = Mage::getUrl('productvideo/index/deleteVideo', array('_secure'=>(!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']==='on')));
				$updateThumbnailUrl = Mage::getUrl('productvideo/index/updateThumbnail', array('_secure'=>(!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']==='on')));
				$updateVideoDataUrl = Mage::getUrl('productvideo/index/updateVideoData', array('_secure'=>(!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']==='on')));
				
				$htmlResult = '';
				
				if($videoThumbnail===''){
					$config = Mage::helper('productvideo')->getThumbnailDefault();
					$videoThumbnail = $config['thumbnail_image'];
				}else{
					$videoThumbnail = $postData['product-id'].'/'.$videoThumbnail;
				}
				$fileUploadSize = Mage::helper('productvideo')->getFileUploadSize();
				$htmlResult .= '<tr id="gridlist-video-row-'.$resultData['vid'].'"><td class="a-center"><img src="'.$product_thumbnail_path_url.$videoThumbnail.'" title="" class="gridlist-thumbnail-image" id="gridlist-thumbnail-image-'.$resultData['vid'].'" alt="" width="100" height="100" /><div class="gridlist-thumbnail-file-content"><input type="file" name="gridlist-thumbnail-file-upload-'.$resultData['vid'].'" id="gridlist-thumbnail-file-upload-'.$resultData['vid'].'" class="gridlist-thumbnail-file-upload" onchange="checkUpdateThumbnail(this,'.$fileUploadSize['thumbnail_size'].')" /><input disabled="disabled" class="gridlist-thumbnail-file-upload-clone" value="'.$this->__('Select file upload').'" ><span class="gridlist-thumbnail-file-upload-button" id="gridlist-thumbnail-file-upload-button-'.$resultData['vid'].'" title="'.$this->__('Update thumbnail').'" onclick="updateThumbnail('.$resultData['vid'].',\''.$updateThumbnailUrl.'\',this,\''.$this->__('Select file upload').'\')" ></span></div></td><td><input id="gridlist-video-name-'.$resultData['vid'].'" class="gridlist-video-text-input" name="gridlist-video-name-'.$resultData['vid'].'" value="'.$videoData['video_name'].'" onchange="updateVideoData('.$resultData['vid'].',\''.$updateVideoDataUrl.'\',this,\'video_name\')" type="text" size="60" /></td><td class="a-center"><span id="gridlist-video-provider-'.$resultData['vid'].'" class="gridlist-video-text-cell">'.$videoData['provider'].'</span></td><td><span id="gridlist-video-id-'.$resultData['vid'].'" class="gridlist-video-text-cell">'.$videoData['video_id'].'</span></td><td class="a-center"><input id="gridlist-video-position-'.$resultData['vid'].'" class="gridlist-video-text-input" name="gridlist-video-position-'.$resultData['vid'].'" value="'.$videoData['position'].'" onchange="updateVideoData('.$resultData['vid'].',\''.$updateVideoDataUrl.'\',this,\'position\')"  type="text" size="7" /></td><td class="a-center"><input type="checkbox" id="gridlist-video-status-'.$resultData['vid'].'" name="gridlist-video-status-'.$resultData['vid'].'" class="gridlist-video-checkbox" ';
				
				if(!$videoData['status']) $htmlResult .= 'checked';
				
				$htmlResult .= ' onclick="updateVideoData('.$resultData['vid'].',\''.$updateVideoDataUrl.'\',this,\'status\')" /></td><td><button id="gridlist-video-delete-button-'.$resultData['vid'].'" class="scalable delete" style="" onclick="deleteVideo('.$resultData['vid'].',\''.$deleteVideoUrl.'\')" type="button" title="'.$this->__('Delete video').'"><span>'.$this->__('Delete').'</span></button></td></tr>';
				
				$resultData['tbodytr'] = $htmlResult;
			}
			
			echo json_encode($resultData);
		}
		
		public function deleteVideoAction(){
			$product_thumbnail_path_dir = Mage::getBaseDir('media').DS.'cmsmart'.DS.'productvideo'.DS.'thumbnail'.DS.'product';
			$product_video_path_dir = Mage::getBaseDir('media').DS.'cmsmart'.DS.'productvideo'.DS.'video'.DS.'product';
			$postData = $this->getRequest()->getPost();
			$resultData = array();
			
			try{
				$productVideoModel = Mage::getModel('productvideo/productvideo');
				$videoData = $productVideoModel->load($postData['vid']);
				
				/* DELETE VIDEO THUMBNAIL IMAGE */
				if($videoData->getThumbnail()!=''){
					$multiThumbnail = Mage::getModel('productvideo/productvideo')->getCollection()->addFieldToFilter('thumbnail',array('eq'=>$videoData->getThumbnail()))->getSize();
					if($multiThumbnail<=1){
						try{
							unlink($product_thumbnail_path_dir.DS.$videoData->getProductId().DS.$videoData->getThumbnail());
						}catch(Exception $e){
							$resultData['error'] = $e->getMessage();
						}
					}
				}
				
				/* DELETE VIDEO FILE */
				if($videoData->getProvider()==='local'){
					$multiVideo = Mage::getModel('productvideo/productvideo')->getCollection()->addFieldToFilter('video_id',array('eq'=>$videoData->getVideoId()))->getSize();
					if($multiVideo<=1){
						try{
							unlink($product_video_path_dir.DS.$videoData->getProductId().DS.$videoData->getVideoId());
						}catch(Exception $e){
							$resultData['error'] = $e->getMessage();
						}
					}
				}
				
				/* DELETE DATA IN TABLE cmsmart_productvideo */
				Mage::getModel('productvideo/productvideo')->setProductvideoId($postData['vid'])->delete();
				
			}catch(Exception $e){
				$resultData['error'] = $e->getMessage();
			}
			
			echo json_encode($resultData);
		}
		
		public function updateVideoDataAction(){
			$postData = $this->getRequest()->getPost();
			$resultData = array();
			$dataUpdate = array();
			
			try{
				if($postData['column']==='status'){
					$dataUpdate[$postData['column']] = $postData['value']==='true' ?  0 : 1;
				}else{
					$dataUpdate[$postData['column']] = $postData['value'];
				}
				
				$videoId = $postData['vid'];
				$productVideoModel = Mage::getModel('productvideo/productvideo')->load($videoId);
				$productVideoModel->addData($dataUpdate);
				$productVideoModel->save();
				
			}catch(Exception $e){
				$resultData['error'] = $e->getMessage();
			}
			
			if(!isset($resultData['error'])){
				$resultData['newdata'] = $postData['value'];
			}
			
			echo json_encode($resultData);
		}
		
		public function updateThumbnailAction(){
			$product_thumbnail_path_dir = Mage::getBaseDir('media').DS.'cmsmart'.DS.'productvideo'.DS.'thumbnail'.DS.'product';
			$product_thumbnail_url_dir = Mage::getBaseUrl('media').'cmsmart/productvideo/thumbnail/product/';
			$postData = $this->getRequest()->getPost();
			$resultData = array();
			
			if(isset($postData['vid']) && isset($postData['vid'])!='' && isset($_FILES['video-thumbnail']['name']) && $_FILES['video-thumbnail']['name']!=''){
				$videoData = Mage::getModel('productvideo/productvideo')->load($postData['vid']);
				/* DELETE PAST IMAGE */
				if($videoData->getThumbnail()){
					$multiThumbnail = Mage::getModel('productvideo/productvideo')->getCollection()->addFieldToFilter('thumbnail',array('eq'=>$videoData->getThumbnail()))->getSize();
					if($multiThumbnail<=1){
						try{
							unlink($product_thumbnail_path_dir.DS.$videoData->getProductId().DS.$videoData->getThumbnail());
						}catch(Exception $e){
							$resultData['error'] = $e->getMessage();
						}
					}
				}
				
				$thumbnailType = '';
				if($_FILES['video-thumbnail']['type']==='image/png'){
					$thumbnailType = '.png';
				}elseif($_FILES['video-thumbnail']['type']==='image/jpg' || $_FILES['video-thumbnail']['type']==='image/jpeg'){
					$thumbnailType = '.jpg';
				}elseif($_FILES['video-thumbnail']['type']==='image/gif'){
					$thumbnailType = '.gif';
				}
				$updateThumbnail = time().$thumbnailType;
				
				/* UPLOAD NEW IMAGE THUMBNAIL FOR THIS VIDEO */
				try{
					if(!is_dir($product_thumbnail_path_dir.DS.$videoData->getProductId().DS)) mkdir($product_thumbnail_path_dir.DS.$videoData->getProductId().DS,0755);
					$uploader = new Varien_File_Uploader('video-thumbnail');
					$uploader->setAllowedExtensions(array('jpg','jpeg','gif','png'));
					$uploader->setAllowRenameFiles(false);
					$uploader->setFilesDispersion(false);
					$uploader->save($product_thumbnail_path_dir.DS.$videoData->getProductId().DS, $updateThumbnail);
				}catch(Exception $e) {	
					$resultData['error'] = $e->getMessage();
				}
				/* SAVE NEW DATA TO cmsmart_productvideo TABLE */
				try{
					$videoData->setThumbnail($updateThumbnail);
					$videoData->save();
				}catch(Exception $e){
					$resultData['error'] = $e->getMessage();
				}
				
				if(!isset($resultData['error'])){
					$resultData['newthumbnail'] = $product_thumbnail_url_dir.$videoData->getProductId().'/'.$updateThumbnail;
				}
				echo json_encode($resultData);
			}
		}
	}
?>