<?php
/**
 * Copyright © 2016 Magentix. All rights reserved.
 *
 * NOTICE OF LICENSE
 * This source file is subject to commercial licence, do not copy or distribute without authorization
 */

class LaPoste_Colissimo_Block_Adminhtml_System_Price
    extends Mage_Adminhtml_Block_System_Config_Form_Field_Array_Abstract
{

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->addColumn('price', array(
            'label' => Mage::helper('laposte_colissimo')->__('Price'),
            'style' => 'width:120px',
        ));

        $country = new laPoste_Colissimo_Block_Adminhtml_Source_Country();
        $country->setModel($this->getCountryModel());

        $this->addColumn('country', array(
            'renderer' => $country,
            'label'    => Mage::helper('laposte_colissimo')->__('Country'),
            'style'    => 'width:120px',
        ));

        $this->addColumn('weight_from', array(
            'label'    => Mage::helper('laposte_colissimo')->__('Weight (From)'),
            'style'    => 'width:120px',
        ));

        $this->addColumn('weight_to', array(
            'label'    => Mage::helper('laposte_colissimo')->__('Weight (To)'),
            'style'    => 'width:120px',
        ));

        $this->_addAfter = false;

        $this->_addButtonLabel = Mage::helper('laposte_colissimo')->__('Add');

        parent::__construct();
    }

    /**
     * Obtain existing data from form element
     *
     * Each row will be instance of Varien_Object
     *
     * @return array
     */
    public function getArrayRows()
    {
        $result = array();
        /** @var Varien_Data_Form_Element_Abstract */
        $element = $this->getElement();
        if ($element->getValue() && is_array($element->getValue())) {
            foreach ($element->getValue() as $rowId => $row) {
                foreach ($row as $key => $value) {
                    $row[$key] = $this->escapeHtml($value);
                    if ($key == 'country' && $row['country']) {
                        $row['country_label'] = Mage::app()->getLocale()->getCountryTranslation($row['country']);
                    }
                }
                $row['_id'] = $rowId;
                $result[$rowId] = new Varien_Object($row);
                $this->_prepareArrayRow($result[$rowId]);
            }
        }

        return $result;
    }

    /**
     * Retrieve country model
     *
     * @return string
     */
    public function getCountryModel()
    {
        return 'laposte_colissimo/system_country';
    }

}