<?php

class Potato_AddressAutocomplete_Block_Init extends Mage_Core_Block_Template
{
    public function canShow()
    {
        $isEnabled = Mage::helper('po_addressautocomplete')->isEnabled();
        $apiKey = $this->getConfig()->getGooglePlacesApiKey();
        return $isEnabled && $apiKey;
    }

    public function getLocaleCode()
    {
        return Mage::app()->getLocale()->getLocaleCode();
    }

    public function getRegionConfig()
    {
        return Mage::helper('directory')->getRegionJson();
    }

    /**
     * @return Potato_AddressAutocomplete_Helper_Config
     */
    public function getConfig()
    {
        return Mage::helper('po_addressautocomplete/config');
    }
}