<?php

class Potato_AddressAutocomplete_Helper_Config extends Mage_Core_Helper_Abstract
{
    const GENERAL_IS_ENABLED                    = 'po_addressautocomplete/general/is_enabled';

    const GOOGLE_PLACES_API_KEY                 = 'po_addressautocomplete/google_places/api_key';
    const GOOGLE_PLACES_HIDE_LOGO               = 'po_addressautocomplete/google_places/hide_logo';
    const GOOGLE_PLACES_USE_BROWSER_GEOLOCATION = 'po_addressautocomplete/google_places/use_browser_geolocation';
    const GOOGLE_PLACES_USE_COUNTRY_RESTRICTION = 'po_addressautocomplete/google_places/use_country_restriction';

    const ADDRESS_COMPONENT_IS_STREET_COMBINED  = 'po_addressautocomplete/address_component/is_street_combined';
    const ADDRESS_COMPONENT_STREET1             = 'po_addressautocomplete/address_component/street1';
    const ADDRESS_COMPONENT_STREET2             = 'po_addressautocomplete/address_component/street2';
    const ADDRESS_COMPONENT_REGION              = 'po_addressautocomplete/address_component/region';
    const ADDRESS_COMPONENT_POSTCODE            = 'po_addressautocomplete/address_component/postcode';
    const ADDRESS_COMPONENT_CITY                = 'po_addressautocomplete/address_component/city';

    /**
     * @param null $store
     *
     * @return bool
     */
    public function isEnabled($store = null)
    {
        return Mage::getStoreConfigFlag(self::GENERAL_IS_ENABLED, $store);
    }

    public function getGooglePlacesApiKey($store = null)
    {
        return (string)Mage::getStoreConfig(self::GOOGLE_PLACES_API_KEY, $store);
    }

    public function isHideGoogleLogo($store = null)
    {
        return Mage::getStoreConfigFlag(self::GOOGLE_PLACES_HIDE_LOGO, $store);
    }

    public function canUseBrowserGeolocation($store = null)
    {
        return Mage::getStoreConfigFlag(self::GOOGLE_PLACES_USE_BROWSER_GEOLOCATION, $store);
    }

    public function canUseCountryRestriction($store = null)
    {
        return Mage::getStoreConfigFlag(self::GOOGLE_PLACES_USE_COUNTRY_RESTRICTION, $store);
    }

    public function isStreetCombined($store = null)
    {
        return Mage::getStoreConfigFlag(self::ADDRESS_COMPONENT_IS_STREET_COMBINED, $store);
    }

    public function getStreet1NameType($store = null)
    {
        $nameType = (string)Mage::getStoreConfig(self::ADDRESS_COMPONENT_STREET1, $store);
        return $nameType ? $nameType : $this->_getDefaultNameType();
    }

    public function getStreet2NameType($store = null)
    {
        $nameType = (string)Mage::getStoreConfig(self::ADDRESS_COMPONENT_STREET2, $store);
        return $nameType ? $nameType : $this->_getDefaultNameType();
    }

    public function getRegionNameType($store = null)
    {
        $nameType = (string)Mage::getStoreConfig(self::ADDRESS_COMPONENT_REGION, $store);
        return $nameType ? $nameType : $this->_getDefaultNameType();
    }

    public function getPostcodeNameType($store = null)
    {
        $nameType = (string)Mage::getStoreConfig(self::ADDRESS_COMPONENT_POSTCODE, $store);
        return $nameType ? $nameType : $this->_getDefaultNameType();
    }

    public function getCityNameType($store = null)
    {
        $nameType = (string)Mage::getStoreConfig(self::ADDRESS_COMPONENT_CITY, $store);
        return $nameType ? $nameType : $this->_getDefaultNameType();
    }

    protected function _getDefaultNameType()
    {
        return Potato_AddressAutocomplete_Model_Source_Name_Type::LONG_NAME_CODE;
    }
}