<?php

class Raveinfosys_Exporter_Model_Exportorders extends Raveinfosys_Exporter_Model_Exporter
{
    const ENCLOSURE = '"';
    const DELIMITER = ';';

    
    public function exportOrders($orders)
    {
        $fileName = 'fichier_export_SAP_MAGENTO_'.date("Ymd_His").'.csv';
        $fp = fopen(Mage::getBaseDir('export').'/'.$fileName, 'w');

        $this->writeHeadRow($fp);
        foreach ($orders as $order) {
        	$order = Mage::getModel('sales/order')->load($order);
            $this->writeOrder($order, $fp);
        }

        fclose($fp);

        return $fileName;
    }

   
    protected function writeHeadRow($fp)
    {
        fputcsv($fp, $this->getHeadRowValues(), self::DELIMITER, self::ENCLOSURE);
    }

    
    protected function writeOrder($order, $fp)
    {
        $common = $this->getCommonOrderValues($order);
        $blank = $this->getBlankOrderValues($order);
		$orderItems = $order->getItemsCollection();
        $itemInc = 0;
		$data = array();
		$count = 0;
        foreach ($orderItems as $item)
        {
            if($count==0)
				{
                 $record = array_merge($common, $this->getOrderItemValues($item, $order, ++$itemInc));
                 fputcsv($fp, $record, self::DELIMITER, self::ENCLOSURE);
				}
				else
				{
				 $record = array_merge($blank, $this->getOrderItemValues($item, $order, ++$itemInc));
                 fputcsv($fp, $record, self::DELIMITER, self::ENCLOSURE);
				}
				$count++;
        }
		
    }

    protected function getHeadRowValues()
    {
        return array(
            "Numero de commande", 
			"Email", 
			"Prenom",
			"Nom",
			
			
			
			"Prenom facturation",
			"Nom facturation",
			"Adresse facturation",
			"Ville facturation",
			"Region facturation",
			"Pays facturation",
			"Code postal facturation",
			"Telephone facturation",
			"ID customer",
			"Prenom adresse expedition",
			"Nom adresse expedition",
			"Adresse adresse expedition",
			"Ville adresse expedition",
			"Region adresse expedition",
			"Pays adresse expedition",
			"Code postal adresse expedition",
			"Telephone adresse expedition",
			"Plateforme de paiement",
			"Date de creation",
			"Date de modification",
			
			"Montant TVA tout inclus",
			
			"Total TTC sans livraison, sans remise",
			"Total TTC avec livraison, sans remise",
			"Total TTC avec livraison, avec remise",
			
			
			
			"Total HT sans livraison, sans remise",
			"Total HT avec livraison, sans remise",
			"Total HT avec livraison, avec remise",
			
			"Methode de livraison",
			"Prix livraison HT",
			"Prix livraison TTC",
			
			"Total article achete",
			
			"Reference produit",
			"Nom produit",
			"Quantite",
            "Prix unitaire HT (du produit)",

            "Prix HT total (pour ce produit)",

            "Poids total (pour ce produit)",
            "Prix unitaire TTC",

			"TVA TOTAL",

            "TVA %",
			
			
    	);
    }

    //Common orders value
	
    protected function getCommonOrderValues($order)
    {
        $shippingAddress = !$order->getIsVirtual() ? $order->getShippingAddress() : null;
		$billingAddress = $order->getBillingAddress();
		if(!$shippingAddress)
		$shippingAddress = $billingAddress;
		/* Calcul */
		
		/* REMISE */
		$remise = $order->getData('discount_amount'); 
		/* REMISE */
		
		/* CALCUL TTC */
		$livraisonttc = $order->getData('shipping_incl_tax'); 
		$totalttc_sanslivraison = $order->getData('subtotal_incl_tax');
		$totalttc_aveclivraison = $totalttc_sanslivraison + $livraisonttc;
		/* FIN CALCUL TTC */
		
		/* CALCUL HT */
		$livraisonht = $order->getData('shipping_amount');
		$totalht_sanslivraison = $order->getData('subtotal');
		$totalht_aveclivraison = $totalht_sanslivraison + $livraisonht;
		$totalht_aveclivraison_avecremise = $totalht_aveclivraison + $remise;
		/* FIN CALCUL HT */
		
		$credit_detail = $this->getCreditMemoDetail($order); 
		/* FIN CALCUL */
		return array(
            $order->getIncrementId(), 
            $order->getData('customer_email'), 
            $this->formatText($order->getData('customer_firstname')),
            $this->formatText($order->getData('customer_lastname')),
            
            
		

            $this->formatText($order->getBillingAddress()->getData('firstname')),

            $this->formatText($order->getBillingAddress()->getData('lastname')),

            $this->formatText($order->getBillingAddress()->getData('street')),
            $this->formatText($order->getBillingAddress()->getData('city')),
            $this->formatText($order->getBillingAddress()->getData('region')),
            $this->formatText($order->getBillingAddress()->getData('country_id')),
            $order->getBillingAddress()->getData('postcode'),
            $order->getBillingAddress()->getData('telephone'),


			$order->getData('customer_id'),
            $this->formatText($shippingAddress->getData('firstname')),

            $this->formatText($shippingAddress->getData('lastname')),

            $this->formatText($shippingAddress->getData('street')),
            $this->formatText($shippingAddress->getData('city')),
            $this->formatText($shippingAddress->getData('region')),
            $shippingAddress->getData('country_id'),
            $shippingAddress->getData('postcode'),
            $shippingAddress->getData('telephone'),
            
            
            $this->getPaymentMethod($order),
            $order->getData('created_at'),
            $order->getData('updated_at'),
            
            $order->getData('tax_amount'), 
            
            $order->getData('subtotal_incl_tax'),
            $totalttc_aveclivraison,
            $order->getData('grand_total'),
            
			
			
			
			$order->getData('subtotal'),
			$totalht_aveclivraison,
			$totalht_aveclivraison_avecremise,

			
			$this->getShippingMethod($order),
			$order->getData('shipping_amount'), 
			$livraisonttc,
			
			
			
			$order->getData('total_qty_ordered'),
			);
    }
	
	protected function getBlankOrderValues($order)
    {
       return array( 
            '','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
    }

    //To return the array of ordered items
    protected function getOrderItemValues($item, $order, $itemInc=1)
    {
		return array(
             $this->getItemSku($item),
             $this->formatText($item->getName()),
			 (int)$item->getQtyOrdered(),
             $item->getOriginalPrice(),

             $item->getRowTotal(),

			 $item->getRowWeight(),
             $item->getPriceInclTax(),

             $item->getTaxAmount(),

             $item->getTaxPercent(),
             
			 
		);
    } 
	
}