<?php

class Raveinfosys_Exporter_Model_Exportorders extends Raveinfosys_Exporter_Model_Exporter
{
    const ENCLOSURE = '"';
    const DELIMITER = ';';

    
    public function exportOrders($orders)
    {
        $fileName = 'order_export_'.date("Ymd_His").'.csv';
        $fp = fopen(Mage::getBaseDir('export').'/'.$fileName, 'w');

        $this->writeHeadRow($fp);
        foreach ($orders as $order) {
        	$order = Mage::getModel('sales/order')->load($order);
            $this->writeOrder($order, $fp);
        }

        fclose($fp);

        return $fileName;
    }

   
    protected function writeHeadRow($fp)
    {
        fputcsv($fp, $this->getHeadRowValues(), self::DELIMITER, self::ENCLOSURE);
    }

    
    protected function writeOrder($order, $fp)
    {
        $common = $this->getCommonOrderValues($order);
        $blank = $this->getBlankOrderValues($order);
		$orderItems = $order->getItemsCollection();
        $itemInc = 0;
		$data = array();
		$count = 0;
        foreach ($orderItems as $item)
        {
            if($count==0)
				{
                 $record = array_merge($common, $this->getOrderItemValues($item, $order, ++$itemInc));
                 fputcsv($fp, $record, self::DELIMITER, self::ENCLOSURE);
				}
				else
				{
				 $record = array_merge($blank, $this->getOrderItemValues($item, $order, ++$itemInc));
                 fputcsv($fp, $record, self::DELIMITER, self::ENCLOSURE);
				}
				$count++;
        }
		
    }

    protected function getHeadRowValues()
    {
        return array(
            "Numero de commande", 
			"Email", 
			"Prenom",
			"Nom",
			"Date de creation",
			"Date de modification",
			
			
			
			"Total HT (sans remise sans livraison)", /* subtotal */			
			"Total HT final", /* calcul HT_final */
			
			"Total TTC (sans remise sans livraison)"	/* base_subtotal_incl_tax */ 
			"Total TTC tout compris", /* grand_total équivaut au TTC_final */
			"Total TTC (sans remise)", /* calcul TTC_global */
			
			"Montant TVA (Apres remise)",
			
			
			/* RAJOUT */ 
			"coupon_code",
			/* FIN RAJOUT */
			
			"Methode de livraison",
			"Prix livraison HT",
			"Prix livraison TTC",
			
			"Statut de la commande",
			"Etat de la commande",
			"Total article achete",
			"Adresse IP",
			"Prenom facturation",
			"Nom facturation",
			"Adresse facturation",
			"Ville facturation",
			"Region facturation",
			"Pays facturation",
			"Code postal facturation",
			"Telephone facturation",
			"ID customer",
			"Prenom adresse expedition",
			"Nom adresse expedition",
			"Adresse adresse expedition",
			"Ville adresse expedition",
			"Region adresse expedition",
			"Pays adresse expedition",
			"Code postal adresse expedition",
			"Telephone adresse expedition",
			"Remise en euro",
			"Plateforme de paiement",
			
			
			"Reference produit",
			"Nom produit",
			"Quantite",
            "Prix unitaire HT (du produit)",

            "Prix HT total (pour ce produit)",

            "Poids total (pour ce produit)",
            "Prix unitaire TTC",

			"TVA TOTAL",

            "TVA %",
			
			
    	);
    }

    //Common orders value
	
    protected function getCommonOrderValues($order)
    {
        $shippingAddress = !$order->getIsVirtual() ? $order->getShippingAddress() : null;
		$billingAddress = $order->getBillingAddress();
		if(!$shippingAddress)
		$shippingAddress = $billingAddress;
		
		$credit_detail = $this->getCreditMemoDetail($order);
		/* CALCUL */
		$totalHTsanslivraison = $order->getData('subtotal');
        $livraisonHT = $order->getData('shipping_amount');
        $totalHT = $totalHTsanslivraison + $livraisonHT; /* total HT avec livraison HT */
        $remiseTTC = $order->getData('discount_amount');
        $remiseTTC = substr($remiseTTC, 1); 
        $remiseHT = $remiseTTC / 1.2;
        $totalHT_moinsremise = $totalHTsanslivraison - 8.3; /* total HT - la remise HT */
        $totalHT_moinsremise_livraison = $totalHT - $remiseHT; /* total HT + livraison HT - la remise HT */ 
        
        /* FIN CALCUL */
		return array(
            $order->getIncrementId(), 
            $order->getData('customer_email'), 
            $this->formatText($order->getData('customer_firstname')),
            $this->formatText($order->getData('customer_lastname')),
            $order->getData('created_at'),
            $order->getData('updated_at'),
            
            $order->getData('subtotal'), /* Total HT */
            $totalHT, /* Total HT (inclus livraison HT) */
            
           	$totalHT_moinsremise, /* Total HT (avec remise) */
			$totalHT_moinsremise_livraison,		/* Total HT (avec remise, inclus livraison) */
			
			
			$remiseHT,
			
            $order->getData('subtotal_incl_tax'),
            $order->getData('tax_amount'),  
            
            
             
            /* RAJOUT */ 
            $order->getData('coupon_code'),
			/* FIN RAJOUT */
			
			
			$this->getShippingMethod($order),
			$order->getData('shipping_amount'),
			$order->getData('shipping_incl_tax'),
			
			
			
			$order->getData('grand_total'),

			
			
			$order->getStatus(),
			$order->getState(),
			
			
			$order->getData('total_qty_ordered'),
			$order->getData('remote_ip'),
		

            $this->formatText($order->getBillingAddress()->getData('firstname')),

            $this->formatText($order->getBillingAddress()->getData('lastname')),

            $this->formatText($order->getBillingAddress()->getData('street')),
            $this->formatText($order->getBillingAddress()->getData('city')),
            $this->formatText($order->getBillingAddress()->getData('region')),
            $this->formatText($order->getBillingAddress()->getData('country_id')),
            $order->getBillingAddress()->getData('postcode'),
            $order->getBillingAddress()->getData('telephone'),


			$order->getData('customer_id'),
            $this->formatText($shippingAddress->getData('firstname')),

            $this->formatText($shippingAddress->getData('lastname')),

            $this->formatText($shippingAddress->getData('street')),
            $this->formatText($shippingAddress->getData('city')),
            $this->formatText($shippingAddress->getData('region')),
            $shippingAddress->getData('country_id'),
            $shippingAddress->getData('postcode'),
            $shippingAddress->getData('telephone'),
            
            $order->getData('discount_amount'),
            $this->getPaymentMethod($order)
			);
    }
	
	protected function getBlankOrderValues($order)
    {
       return array( 
            '','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
    }

    //To return the array of ordered items
    protected function getOrderItemValues($item, $order, $itemInc=1)
    {
		return array(
             $this->getItemSku($item),
             $this->formatText($item->getName()),
			 (int)$item->getQtyOrdered(),
             $item->getOriginalPrice(),

             $item->getRowTotal(),

			 $item->getRowWeight(),
             $item->getPriceInclTax(),

             $item->getTaxAmount(),

             $item->getTaxPercent(),
             
			 
		);
    } 
	
}