<?php
/**
 * Created by PhpStorm.
 * User: Ravinder
 * Date: 25/7/15
 * Time: 4:36 PM
 */
class RedChamps_GuestOrders_Helper_Data extends Mage_Core_Helper_Abstract
{

    const XML_PATH_EMAIL_COPY_TO     = 'guestorders/email/copy_to';
    const XML_PATH_EMAIL_COPY_METHOD = 'guestorders/email/copy_method';
    const XML_PATH_EMAIL_TEMPLATE    = 'guestorders/email/template';
    const XML_PATH_EMAIL_IDENTITY    = 'guestorders/email/identity';
    const XML_PATH_EMAIL_ENABLED     = 'guestorders/email/enabled';

    public function sendEmail($order, $registerurl)
    {
        $store = $order->getStore();
        $storeId = $store->getId();
        if (!$this->canSendEmail($storeId)) {
            return $this;
        }
        // Get the destination email addresses to send copies to
        $copyTo = $this->_getEmails(self::XML_PATH_EMAIL_COPY_TO, $storeId);
        $copyMethod = Mage::getStoreConfig(self::XML_PATH_EMAIL_COPY_METHOD, $storeId);

        // Start store emulation process
        $appEmulation = Mage::getSingleton('core/app_emulation');
        $initialEnvironmentInfo = $appEmulation->startEnvironmentEmulation($storeId);

        try {
            // Retrieve specified view block from appropriate design package (depends on emulated store)
            $paymentBlock = Mage::helper('payment')->getInfoBlock($order->getPayment())
                ->setIsSecureMode(true);
            $paymentBlock->getMethod()->setStore($storeId);
            $paymentBlockHtml = $paymentBlock->toHtml();
        } catch (Exception $exception) {
            // Stop store emulation process
            $appEmulation->stopEnvironmentEmulation($initialEnvironmentInfo);
            throw $exception;
        }

        // Stop store emulation process
        $appEmulation->stopEnvironmentEmulation($initialEnvironmentInfo);

        // Retrieve corresponding email template id and customer name
        $templateId = Mage::getStoreConfig(self::XML_PATH_EMAIL_TEMPLATE, $storeId);
        $customerName = $order->getBillingAddress()->getName();

        $mailer = Mage::getModel('core/email_template_mailer');
        $emailInfo = Mage::getModel('core/email_info');
        $emailInfo->addTo($order->getCustomerEmail(), $customerName);
        if ($copyTo && $copyMethod == 'bcc') {
            // Add bcc to customer email
            foreach ($copyTo as $email) {
                $emailInfo->addBcc($email);
            }
        }
        $mailer->addEmailInfo($emailInfo);

        // Email copies are sent as separated emails if their copy method is 'copy' or a customer should not be notified
        if ($copyTo && $copyMethod == 'copy') {
            foreach ($copyTo as $email) {
                $emailInfo = Mage::getModel('core/email_info');
                $emailInfo->addTo($email);
                $mailer->addEmailInfo($emailInfo);
            }
        }

        // Set all required params and send emails
        $mailer->setSender(Mage::getStoreConfig(self::XML_PATH_EMAIL_IDENTITY, $storeId));
        $mailer->setStoreId($storeId);
        $mailer->setTemplateId($templateId);
        $mailer->setTemplateParams(array(
                'order'         => $order,
                'billing'       => $order->getBillingAddress(),
                'store'         => $store,
                'payment_html'  => $paymentBlockHtml,
                'register_link' => $registerurl
            )
        );
        $mailer->send();

        return $this;
    }

    /*
     * Check if email can be sent to customer
     * */
    public function canSendEmail($store = null)
    {
        return Mage::getStoreConfigFlag(self::XML_PATH_EMAIL_ENABLED, $store);
    }

    /*
     * Get emails from admin config and explode them by comma
     * */
    protected function _getEmails($configPath,$storeId)
    {
        $data = Mage::getStoreConfig($configPath, $storeId);
        if (!empty($data)) {
            return explode(',', $data);
        }
        return false;
    }

    /*
     * set customer_id in sales_flat_order and sales_flat_order_grid table
     * */
    public function assignOrdersToCustomer($email,$customerId,$customerGroup) {
        //get resource and write connection
        $resource = Mage::getSingleton('core/resource');
        $writeConnection = $resource->getConnection('core_write');
        $readConnection = $resource->getConnection('core_write');

        //get table names
        $orderTable = $resource->getTableName('sales/order');
        $orderGridTable = $resource->getTableName('sales/order_grid');

        //prepare queries
        $orderSelectQuery = "select entity_id from {$orderTable} WHERE customer_email = '{$email}'";
        $orderUpdateQuery = "UPDATE {$orderTable} SET customer_id = {$customerId},customer_is_guest=0,customer_group_id={$customerGroup} WHERE customer_email = '{$email}' and customer_id IS NULL";

        //Execute query
        $writeConnection->query($orderUpdateQuery);
        //logic to update order grid table
        $orderGridQuery = '';
        $orderIds = $readConnection->fetchCol($orderSelectQuery);

        if(count($orderIds) > 1) {
            $orderIds = implode(',',$orderIds);
            $orderGridQuery = "UPDATE {$orderGridTable} SET customer_id = {$customerId} WHERE entity_id in ($orderIds) and customer_id IS NULL";

        } elseif(count($orderIds) == 1) {
            $orderId = $orderIds[0];
            $orderGridQuery = "UPDATE {$orderGridTable} SET customer_id = {$customerId} WHERE entity_id = {$orderId} and customer_id IS NULL";
        }

        if($orderGridQuery != '') {
            $writeConnection->query($orderGridQuery);
        }
    }

}