<?php
/**
 * Created by RedChamps.
 * User: Rav
 * Date: 02/08/17
 * Time: 1:16 PM
 */
class RedChamps_GuestOrders_Model_Cron
{
    /*
     * Send email to customer if order is placed using Guest Checkout option
     * */
    public function sendEmailToGuest()
    {
        $time = time();
        $lastTime = $time - 3600; // 60*60
        $to = date('Y-m-d H:i:s', $lastTime);
        $orders = Mage::getModel('sales/order')
            ->getCollection()
            ->addFieldToFilter('created_at', array(
                'to'       => $to,
                'datetime' => true
            ))
            ->addFieldToFilter('guest_order_followed_up', 0)
            ->load();
        foreach ($orders as $order) {
            $registerUrl = Mage::helper("customer")->getRegisterUrl();
            $email = $order->getCustomerEmail();
            $orderId = $order->getId();
            $params = base64_encode('email='.$email.'&order_id='.$orderId);
            $registerUrl = $registerUrl.$params;
            if ($order->getCustomerIsGuest()) {
                Mage::helper('guestorders')->sendEmail($order, $registerUrl);
            }
            $order->setGuestOrderFollowedUp(1)->save();
        }
    }
}