<?php
/**
 * Created by PhpStorm.
 * User: Ravinder
 * Date: 25/7/15
 * Time: 4:42 PM
 */
class RedChamps_GuestOrders_Model_Observer
{
    /*
     * On customer registration success check order by email and assign
     * them to customer
     * */
    public function assignOrders(Varien_Event_Observer $observer)
    {
        $customer = $observer->getEvent()->getCustomer();
        $customerId = $customer->getId();
        if(!empty($customerId)) {
            Mage::helper('guestorders')->assignOrdersToCustomer($customer->getEmail(),$customerId, $customer->getGroupId());
        }
    }

    /*
     * On customer guest order success check order by email and assign
     * them to customer
     * */
    public function assignCustomer(Varien_Event_Observer $observer)
    {
        $order = $observer->getEvent()->getOrder();
        $email = $order->getCustomerEmail();
        $customerId = $order->getCustomerId();
        if(!$customerId){
            $customer = Mage::getModel("customer/customer");
            $customer->setWebsiteId(Mage::app()->getWebsite()->getId());
            $customer->loadByEmail($email);
            $customerId = $customer->getId();
        } else {
            $customer = Mage::getModel("customer/customer")->load($customerId);
        }
        if(!empty($customerId)) {
            Mage::helper('guestorders')->assignOrdersToCustomer($email,$customerId,$customer->getGroupId());
        }
    }
}