<?php

class Raveinfosys_Exporter_Model_Exportorders extends Raveinfosys_Exporter_Model_Exporter
{
    const ENCLOSURE = '"';
    const DELIMITER = ';';

    
    public function exportOrders($orders)
    {
        $fileName = 'fichier_export_SAP_MAGENTO_'.date("Ymd_His").'.csv';
        $fp = fopen(Mage::getBaseDir('export').'/'.$fileName, 'w');

        $this->writeHeadRow($fp);
        foreach ($orders as $order) {
        	$order = Mage::getModel('sales/order')->load($order);
            $this->writeOrder($order, $fp);
        }

        fclose($fp);

        return $fileName;
    }

   
    protected function writeHeadRow($fp)
    {
        fputcsv($fp, $this->getHeadRowValues(), self::DELIMITER, self::ENCLOSURE);
    }

    
    protected function writeOrder($order, $fp)
    {
        $common = $this->getCommonOrderValues($order);
        $blank = $this->getBlankOrderValues($order);
		$orderItems = $order->getItemsCollection();
        $itemInc = 0;
		$data = array();
		$count = 0;
        foreach ($orderItems as $item)
        {
            if($count==0)
				{
                 $record = array_merge($common, $this->getOrderItemValues($item, $order, ++$itemInc));
                 fputcsv($fp, $record, self::DELIMITER, self::ENCLOSURE);
				}
				else
				{
				 $record = array_merge($blank, $this->getOrderItemValues($item, $order, ++$itemInc));
                 fputcsv($fp, $record, self::DELIMITER, self::ENCLOSURE);
				}
				$count++;
        }
		
    }

    protected function getHeadRowValues()
    {
        return array(
        	"Facture N˚", 
            "Date de facturation", 
			"Commande N˚", 
			"Date de commande", 
			"Facture au nom",
			"Montant TTC",
			"Montant HT hors cout de transport",
			"Cout de transport HT",
			"Montant HT + cout transport HT",
			"TVA",	
			
			
			
			
    	);
    }

    //Common orders value
	
    protected function getCommonOrderValues($order)
    {
        $shippingAddress = !$order->getIsVirtual() ? $order->getShippingAddress() : null;
		$billingAddress = $order->getBillingAddress();
		if(!$shippingAddress)
		$shippingAddress = $billingAddress;
		/* Calcul */
		
		/* REMISE */
		$remise = $order->getData('discount_amount'); 
		/* REMISE */
		
		/* CALCUL TTC */
		$livraisonttc = $order->getData('shipping_incl_tax'); 
		$totalttc_sanslivraison = $order->getData('subtotal_incl_tax');
		$totalttc_aveclivraison = $totalttc_sanslivraison + $livraisonttc;
		/* FIN CALCUL TTC */
		
		/* CALCUL HT */
		$livraisonht = $order->getData('shipping_amount');
		$totalht_sanslivraison = $order->getData('subtotal');
		$totalht_aveclivraison = $totalht_sanslivraison + $livraisonht;
		$totalht_aveclivraison_avecremise = $totalht_aveclivraison + $remise;
		/* FIN CALCUL HT */		
		
		
		/* FIN CALCUL */
		return array(
            $order->getIncrementId(), /// FACTURE NUMERO /////
            $order->getData('updated_at'), //// FACTURE DATE //////
            $order->getIncrementId(), //// COMMANDE NUMERO //////
            $order->getData('created_at'), //// COMMANDE DATE //////
            $this->formatText($order->getData('customer_firstname')), //// PRENOM NOM //////
            $totalttc_aveclivraison, /////  Montant TTC ///////
            $totalht_sanslivraison, /////  Montant HT hors cout de transport ///////
            $livraisonht, /////  Cout de transport HT ///////
            $totalht_aveclivraison, /////  Montant HT + cout transport HT ///////
            $order->getData('tax_amount'), /////  TVA ///////
			);
    }
	
	protected function getBlankOrderValues($order)
    {
       return array( 
            '','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','');
    }

    //To return the array of ordered items
    protected function getOrderItemValues($item, $order, $itemInc=1)
    {
		return array(
             $this->getItemSku($item),
             $this->formatText($item->getName()),
			 (int)$item->getQtyOrdered(),
             $item->getOriginalPrice(),

             $item->getRowTotal(),

			 $item->getRowWeight(),
             $item->getPriceInclTax(),

             $item->getTaxAmount(),

             $item->getTaxPercent(),
             
			 
		);
    } 
	
}