<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Core
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Core_Helper_Data extends Mage_Core_Helper_Abstract {
	const LOG_FILE = 'envoidunet.log';

	public function isDebug() {
		return (bool) Mage::getStoreConfig('edn2_api/developer/debug');
	}

	public function log($message, $level = null, $force = false) {
		$this->_log($message, $level, $force);
	}

	public function debug($message, $level = null) {
		if($this->isDebug()) {
			$this->_log($message, $level, true);
		}
	}

	protected function _log($message, $level = null, $force = false) {
		Mage::log ( $message, $level, self::LOG_FILE, $force);
	}
	
	public function getProxyHost() {
		return Mage::getStoreConfig ( 'edn2_api/network/proxy_host' );
	}
	
	public function getProxyPort() {
		return Mage::getStoreConfig ( 'edn2_api/network/proxy_port' );
	}

	public function fileGetContents($filename) {
		$proxyHost = $this->getProxyHost();
		$proxyPort = $this->getProxyPort();
		if(!empty($proxyHost) && !empty($proxyPort)) {
			$aContext = array(
					'http' => array(
							'proxy' => 'tcp://'. $proxyHost .':' . $proxyPort, // This needs to be the server and the port of the NTLM Authentication Proxy Server.
							'request_fulluri' => True,
					),
			);
			
			$cxContext = stream_context_create($aContext);
			return file_get_contents($filename, false, $cxContext);
		}
		return file_get_contents($filename, false);
	}
}
