<?php

/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Core
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Core_Helper_Math extends Mage_Core_Helper_Abstract
{

    /**
     * Get a center latitude,longitude from an array of like geopoints
     *
     * @param
     *            array data 2 dimensional array of latitudes and longitudes
     *            For Example:
     *            $data = array
     *            (
     *            0 = > array(45.849382, 76.322333),
     *            1 = > array(45.843543, 75.324143),
     *            2 = > array(45.765744, 76.543223),
     *            3 = > array(45.784234, 74.542335)
     *            );
     */
    public function getCenterFromDegrees ($data)
    {
        if (! is_array($data))
            return false;
        
        $num_coords = count($data);
        
        $X = 0.0;
        $Y = 0.0;
        $Z = 0.0;
        
        foreach ($data as $coord) {
            $lat = $coord[0] * pi() / 180;
            $lon = $coord[1] * pi() / 180;
            
            $a = cos($lat) * cos($lon);
            $b = cos($lat) * sin($lon);
            $c = sin($lat);
            
            $X += $a;
            $Y += $b;
            $Z += $c;
        }
        
        $X /= $num_coords;
        $Y /= $num_coords;
        $Z /= $num_coords;
        
        $lon = atan2($Y, $X);
        $hyp = sqrt($X * $X + $Y * $Y);
        $lat = atan2($Z, $hyp);
        
        return array(
                $lat * 180 / pi(),
                $lon * 180 / pi()
        );
    }
}