<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Block_Adminhtml_Shipping_Label_Index extends Mage_Adminhtml_Block_Widget_Form_Container {
	public function __construct() {
		parent::__construct();
		$this->_blockGroup = 'edn2shipping';
		$this->_controller = 'adminhtml_shipping_label';
		$this->_mode = 'index';
		$this->_headerText = Mage::helper('edn2shipping')->__('Label Creator');

		$this->removeButton('add');
		$this->removeButton('save');
		$this->_addButton('calcul', array(
				'label'     => Mage::helper('edn2shipping')->__('Create Label'),
				'onclick'   => 'editForm.submit();',
				'class'     => 'save',
		), 1);
	}


}