<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Block_Adminhtml_Shipping_Label_Index_Form extends Mage_Adminhtml_Block_Widget_Form {
	/**
	 * (non-PHPdoc)
	 *
	 * @see Mage_Adminhtml_Block_Widget_Form::_prepareForm()
	 */
	protected function _prepareForm() {
		$form = new Varien_Data_Form ( array (
				'id' => 'edit_form',
				'action' => $this->getUrl ( '*/*/createLabel' ),
				'method' => 'post',
				'enctype' => 'multipart/form-data'
		) );

		$fieldset = $form->addFieldset ( 'main', array (
				'legend' => Mage::helper ( 'edn2shipping' )->__ ( 'Parameters' )
		) );

		$element = $fieldset->addField ( 'increment_id', 'text', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Order #' ),
				'name' => 'increment_id',
				'required' => 1,
				'after_element_html' => '<script type="text/javascript">document.observe("dom:loaded", function() { $(\'increment_id\').focus(); /*$(\'increment_id\').observe(\'keypress\', function(event) { if ( event.keyCode == Event.KEY_RETURN  || event.which == Event.KEY_RETURN ) { $(\'weight\').focus(); } }); */ });</script>'
		) );
		
		$element  = $fieldset->addField('total_parcel', 'select', array(
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Total Parcel' ),
				'name' => 'total_parcel',
				'options' => array(1 => "1", 2 => "2", 3 => "3", 4 => "4", 5 => "5"),
				'after_element_html' => '<p class="note"><span>' . Mage::helper ( 'edn2shipping' )->__ ( 'Total Parcel (Multi-Parcel)' ) . '</span></p><script type="text/javascript">$(\'total_parcel\').observe(\'change\', function(event) { var url = window.location.href; if(url.indexOf(\'total_parcel=\') != -1) { url = url.replace(new RegExp( \'\\\btotal_parcel=\\\d+\\\b\', \'i\'), \'total_parcel=\' + $F(\'total_parcel\') ); } else { url += \'?total_parcel=\' + $F(\'total_parcel\'); } window.location = url; });</script>',
				'required' => 1
		));
		
		$element = $fieldset->addField ( 'force', 'select', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Force Generation' ),
				'name' => 'force',
				'required' => 1,
				'after_element_html' => '<p class="note"><span>' . Mage::helper ( 'edn2shipping' )->__ ( 'Force Generation of label' ) . '</span>',
				'options' => array(0 => Mage::helper ( 'edn2shipping' )->__("No"), 1 => Mage::helper ( 'edn2shipping' )->__("Yes"))
		) );
		
		$element = $fieldset->addField ( 'force_carrier', 'select', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Force Carrier' ),
				'name' => 'force_carrier',
				'required' => 0,
				'after_element_html' => '<p class="note"><span>' . Mage::helper ( 'edn2shipping' )->__ ( 'Force a carrier on this Order' ) . '</span>',
				'options' => array_merge(array('' => ''), Mage::helper ( 'edn2shipping/carrier' )->getShippingMethodsOptions())
		) );
		
		$element = $fieldset->addField ( 'relayid', 'text', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Relay ID' ),
				'name' => 'relayid',
				'required' => 0,
				'after_element_html' => '<p class="note"><span>' . Mage::helper ( 'edn2shipping' )->__ ( 'Relay ID when using a relay carrier' ) . '</span>',
		) );
		
		
		$total_parcel = $this->getRequest()->getParam('total_parcel', 1);
		
		$values = array('increment_id' => $this->getRequest ()->getParam ( 'increment_id', '' ), 'force' => $this->getRequest()->getParam('force', 0) ,'parcel' => array());
		
		for($i = 1; $i <= $total_parcel; $i++) {
			$values['parcel'][$i] = array();
			$parcels =  $this->getRequest ()->getParam ('parcel', false);
			$values['parcel'][$i]['weight'] = ($parcels && isset($parcels[$i]) && isset($parcels[$i]['weight'])) ? $parcels[$i]['weight'] : 0.5;
			$values['parcel'][$i]['value'] = ($parcels && isset($parcels[$i]) && isset($parcels[$i]['value'])) ? $parcels[$i]['value'] : 0;
			
			$fieldset = $form->addFieldset ( 'parcel' . $i, array (
					'legend' => Mage::helper ( 'edn2shipping' )->__ ( 'Parcel %s', $i )
			) );
			$fieldset->addField ( $i . '::weight', 'text', array (
					'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Weight' ),
					'name' => 'parcel[' . $i . '][weight]',
					'after_element_html' => '<p class="note"><span>' . Mage::helper ( 'edn2shipping' )->__ ( 'in Kg' ) . '</span></p>',
					'required' => 1,
					'value' => $values['parcel'][$i]['weight']
			) );			
		}

		$form->setUseContainer ( true );
		
		$form->setValues ( $this->getRequest ()->getParams () );
		$form->addValues ( $values );
		
		if(!$this->getRequest()->isPost()) {
			$orderId = $this->getRequest()->getParam('order_id');
			if($orderId) {
				/* @var $order Mage_Sales_Model_Order */
				$order = Mage::getModel('sales/order')->load($orderId);
				if($order->getId()) {
					$orderValues = array(
						'increment_id' => $order->getIncrementId(),
						'1::weight' => $order->getWeight()
					);
					$form->addValues($orderValues);
				}
			}
		}
		
		$this->setForm ( $form );
		return parent::_prepareForm ();
	}
}
