<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Block_Adminhtml_Shipping_Quote_Index_Grid extends Mage_Adminhtml_Block_Widget_Grid {
	public function __construct() {
		parent::__construct ();
		$this->setUseAjax ( true );
		$this->setId ( 'edn2shippingShippingQuoteIndexGrid' );

		$this->setFilterVisibility ( false );
		$this->setPagerVisibility ( false );
		$this->setCountTotals ( false );
	}

	protected function _prepareCollection() {

		$collection = new Varien_Data_Collection();
		$filter   = $this->getParam($this->getVarNameFilter(), null);
		if (is_string($filter)) {
			$data = $this->helper('adminhtml')->prepareFilterString($filter);
			/* @var $apiHelper EDN2_Core_Helper_Api */
			try {
				$result = Mage::helper('edn2core/api')->getQuoteSimple($data['company'], $data['postcode'], $data['city'], $data['country'], $data['weight']);
				foreach($result as $carrier => $price) {
					try {
						if($carrierInstance = Mage::helper('edn2shipping/carrier')->getCarrierInstanceByEdnCarrierKey($carrier)) {
							$carrierName = $carrierInstance->getTitle();
						} else {
							$carrierName = $carrier;
						}
					} catch(Exception $e) { $carrierName = $carrier; }
					$priceTtc = round($price * 1.20, 2);
					$collection->addItem(new Varien_Object(array('carrier' => $carrier, 'carrier_name' => $carrierName,  'price' => $price, 'price_ttc' => $priceTtc, 'currency_code' => 'EUR')));
				}
			} catch(Exception $e) {
				Mage::getSingleton('core/session')->addError($e->getMessage());
			}
		}
		$this->setCollection ( $collection );
		//parent::_prepareCollection ();
		return $this;
	}

	protected function _prepareColumns() {
		$this->addColumn ( 'carrier_name', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Carrier' ),
				'width' => '80px',
				'type' => 'text',
				'sortable'  => false,
				'index' => 'carrier_name'
		) );
		$this->addColumn ( 'price', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Shipping Excl. Tax (%s)', '€' ),
				'width' => '80px',
				'type' => 'currency',
				'sortable'  => false,
				'index' => 'price',
				'currency' => 'currency_code'
		) );
		$this->addColumn ( 'price_ttc', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Shipping Incl. Tax (%s)', '€' ),
				'width' => '80px',
				'type' => 'currency',
				'sortable'  => false,
				'index' => 'price_ttc',
				'currency' => 'currency_code'
		) );
		return parent::_prepareColumns ();
	}

	public function getRowUrl($row) {
		return false;
	}

	public function getGridUrl() {
		return $this->getUrl ( '*/*/grid', array (
				'_current' => true
		) );
	}
}