<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Block_Adminhtml_Shipping_Relay_Index extends Mage_Adminhtml_Block_Widget_Grid_Container {
	public function __construct() {
		parent::__construct();
		$this->_blockGroup = 'edn2shipping';
		$this->_controller = 'adminhtml_shipping_relay_index';
		$this->_headerText = Mage::helper('edn2shipping')->__('Relay Finder');
		$this->removeButton('add');
		
		$this->_addButton('back', array(
				'label'     => Mage::helper('adminhtml')->__('Back'),
				'onclick'   => 'setLocation(\'' . $this->getBackUrl() . '\')',
				'class'     => 'back',
		), -1);
		
		$this->_addButton('reset', array(
				'label'     => Mage::helper('adminhtml')->__('Reset'),
				'onclick'   => 'setLocation(window.location.href)',
		), -1);
		
		$this->_addButton('save', array(
				'label'     => Mage::helper('edn2shipping')->__('Search'),
				'onclick'   => 'searchRelayPoint();',
				'class'     => 'save',
		), 1);
	}
	
	/**
	 * Get URL for back (reset) button
	 *
	 * @return string
	 */
	public function getBackUrl()
	{
		return $this->getUrl('*/*/');
	}
	
	
}