<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Block_Adminhtml_Shipping_Relay_Index_Form extends Mage_Adminhtml_Block_Widget_Form {
	/**
	 * (non-PHPdoc)
	 *
	 * @see Mage_Adminhtml_Block_Widget_Form::_prepareForm()
	 */
	protected function _prepareForm() {
		$form = new Varien_Data_Form ( array (
				'id' => 'edit_form',
				'action' => $this->getUrl ( '*/*/grid' ),
				'method' => 'post',
				'enctype' => 'multipart/form-data'
		) );

		$fieldset = $form->addFieldset ( 'main', array (
				'legend' => Mage::helper ( 'edn2shipping' )->__ ( 'Search Criteria' )
		) );
		
		
		$options = array_merge(array(''), Mage::helper('edn2shipping/carrier')->getShippingMethodsOptions('relay'));
		
		$fieldset->addField ( 'carrier', 'select', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Carrier' ),
				'name' => 'carrier',
				'options' => $options,
				'required' => 1,
		) );
		
		$fieldset->addField ( 'country', 'text', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Country' ),
				'name' => 'country',
				'required' => 1,
		) );
		
		/*$fieldset->addField ( 'weight', 'text', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Weight' ),
				'name' => 'weight',
				'after_element_html' => '<p class="note"><span>' . Mage::helper('edn2shipping')->__('in Kg') . '</span></p>',
				'required' => 1,
		) );*/
		
		$fieldset->addField ( 'relayid', 'text', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Relay Point ID' ),
				'name' => 'relayid',
				'after_element_html' => '<p class="note"><span>' . Mage::helper('edn2shipping')->__('Search By Relay ID') . '</span></p>',
				'required' => 0,
		) );
		
		$fieldset->addField ( 'postcode', 'text', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Postcode' ),
				'name' => 'postcode',
				'after_element_html' => '<p class="note"><span>' . Mage::helper('edn2shipping')->__('Search By Postcode') . '</span></p>',
				'required' => 0,
		) );

		$form->setUseContainer ( true );
		$form->setValues($this->getRequest()->getParams());
		$form->addValues(array('country' => $this->getRequest()->getParam('country', 'FR')/*, 'weight' => $this->getRequest()->getParam('weight', '1')*/));
		$this->setForm ( $form );
		return parent::_prepareForm ();
	}
}
