<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Block_Adminhtml_Shipping_Relay_Index_Grid extends Mage_Adminhtml_Block_Widget_Grid {
	public function __construct() {
		parent::__construct ();
		$this->setUseAjax ( true );
		$this->setId ( 'edn2shippingShippingRelayIndexGrid' );
	
		$this->setFilterVisibility ( false );
		$this->setPagerVisibility ( false );
		$this->setCountTotals ( false );
	}
	
	protected function _prepareCollection() {
		
		$collection = new Varien_Data_Collection();
		
		$filter   = $this->getParam($this->getVarNameFilter(), null);
		if (is_string($filter)) {
			$data = $this->helper('adminhtml')->prepareFilterString($filter);
			$this->getRequest()->setParam('carrier', $data['carrier']);
			$this->getRequest()->setParam('country', $data['country']);

			if(empty($data['relayid'])) {
				try {
					$relays = Mage::helper('edn2shipping/carrier')->findRelaysByShippingMethod($data['carrier'], $data['country'], $data['postcode'], null);

					foreach($relays['relays'] as $relay) {
						$collection->addItem(new Varien_Object($relay));
					}
				} catch(Exception $e) { }
			} else {
				try {
					$relay = Mage::helper('edn2core/api')->getRelay($data['carrier'], $data['relayid'], $data['country']);
					if(!empty($relay)) {
						$collection->addItem(new Varien_Object($relay));
					}
				} catch(Exception $e) { }
			}
		}
		$this->setCollection ( $collection );

		return $this;
	}
	
	protected function _prepareColumns() {
		$this->addColumn ( 'id', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Relay ID' ),
				'width' => '80px',
				'type' => 'text',
				'renderer' => 'edn2shipping/adminhtml_widget_grid_column_renderer_relay',
				'font_size' => '2.0em',
				'line_height' => '1.5em',
				'sortable'  => false,
				'index' => 'id'
		) );
		$this->addColumn ( 'street1', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Street 1' ),
				'width' => '80px',
				'type' => 'text',
				'sortable'  => false,
				'index' => 'street1'
		) );
		$this->addColumn ( 'street3', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Street 3' ),
				'width' => '80px',
				'type' => 'text',
				'sortable'  => false,
				'index' => 'street3'
		) );
		$this->addColumn ( 'postcode', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Postcode' ),
				'width' => '80px',
				'type' => 'text',
				'sortable'  => false,
				'index' => 'postcode'
		) );
		$this->addColumn ( 'city', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'City' ),
				'width' => '80px',
				'type' => 'text',
				'sortable'  => false,
				'index' => 'city'
		) );
		$this->addColumn ( 'monday', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Monday' ),
				'width' => '80px',
				'type' => 'text',
				'sortable'  => false,
				'index' => 'monday',
				'renderer' => 'edn2shipping/adminhtml_widget_grid_column_renderer_openinghour'
		) );
		$this->addColumn ( 'tuesday', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Tuesday' ),
				'width' => '80px',
				'type' => 'text',
				'sortable'  => false,
				'index' => 'tuesday',
				'renderer' => 'edn2shipping/adminhtml_widget_grid_column_renderer_openinghour'
		) );
		$this->addColumn ( 'wednesday', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Wednesday' ),
				'width' => '80px',
				'type' => 'text',
				'sortable'  => false,
				'index' => 'wednesday',
				'renderer' => 'edn2shipping/adminhtml_widget_grid_column_renderer_openinghour'
		) );
		$this->addColumn ( 'thursday', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Thursday' ),
				'width' => '80px',
				'type' => 'text',
				'sortable'  => false,
				'index' => 'thursday',
				'renderer' => 'edn2shipping/adminhtml_widget_grid_column_renderer_openinghour'
		) );
		$this->addColumn ( 'friday', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Friday' ),
				'width' => '80px',
				'type' => 'text',
				'sortable'  => false,
				'index' => 'friday',
				'renderer' => 'edn2shipping/adminhtml_widget_grid_column_renderer_openinghour'
		) );
		$this->addColumn ( 'saturday', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Saturday' ),
				'width' => '80px',
				'type' => 'text',
				'sortable'  => false,
				'index' => 'saturday',
				'renderer' => 'edn2shipping/adminhtml_widget_grid_column_renderer_openinghour'
		) );
		$this->addColumn ( 'sunday', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Sunday' ),
				'width' => '80px',
				'type' => 'text',
				'sortable'  => false,
				'index' => 'sunday',
				'renderer' => 'edn2shipping/adminhtml_widget_grid_column_renderer_openinghour'
		) );
		return parent::_prepareColumns ();
	}
	
	public function getRowUrl($row) {
		return false;
	}
	
	public function getGridUrl() {
		return $this->getUrl ( '*/*/grid', array (
				'_current' => true
		) );
	}
}