<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Block_Adminhtml_Shipping_Sales_Index_Grid extends Mage_Adminhtml_Block_Widget_Grid {
	public function __construct() {
		parent::__construct ();
		$this->setUseAjax ( true );
		$this->setId ( 'edn2shippingShippingSalesIndexGrid' );
		$this->setDefaultSort ( 'created_at' );
		$this->setDefaultDir ( 'DESC' );
		$this->setSaveParametersInSession ( true );
	}

	protected function _prepareCollection() {
		/* @var $collection Mage_Sales_Model_Resource_Order_Grid_Collection */
		$collection = Mage::getResourceModel ( 'sales/order_grid_collection' );
		$collection->addFieldToFilter('sales_order.shipping_method', array('in' => Mage::helper('edn2shipping/carrier')->getShippingMethods()));
		$select = $collection->getSelect();
		$select->joinLeft(
				array( 'payment' => $collection->getTable('sales/order_payment') ),
					   'payment.parent_id = main_table.entity_id',
				array( 'payment_method' => 'method' )
		);
		$select->joinLeft(
				array( 'sales_order' => $collection->getTable('sales/order') ),
				'sales_order.entity_id = main_table.entity_id',
				array( 'shipping_method', 'edn2_relayid' )
		);
		$select->joinLeft(
				array( 'edn2_tracking' => $collection->getTable('edn2shipping/tracking') ),
				'edn2_tracking.order_id = main_table.entity_id',
				array( 'tracking_number' => 'tracking_number', 'tracking_created_at' => 'created_at' )
		);
		$this->setCollection ( $collection );
		return parent::_prepareCollection ();
	}
	
	protected function _filterByCallback (Varien_Data_Collection_Db $collection, Mage_Adminhtml_Block_Widget_Grid_Column $column) {
		$select = $collection->getSelect();
		$field = $column->getIndex();
		$value = $column->getFilter()->getValue();
		
		if($value == "1") {
			$select->where("`edn2_tracking`.`tracking_number` IS NULL");
		} elseif($value == "2") {
			$select->where("`edn2_tracking`.`tracking_number` IS NOT NULL");
		} elseif($value == "3") {
			$select->where("`edn2_tracking`.`tracking_number` IS NOT NULL AND `sales_order`.`state` IN ('complete', 'closed')");
		}
	}

	protected function _prepareColumns() {
		$this->addColumn('filter_by', array(
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Filter By' ),
				'index' => 'filter_by',
				'type' => 'options',
				'width' => '70px',
				'filter' => 'adminhtml/widget_grid_column_filter_select',
				'renderer' => 'adminhtml/widget_grid_column_renderer_text',
				'filter_condition_callback' => array($this, '_filterByCallback'),
				'options' => array(
						1 => Mage::helper ( 'edn2shipping' )->__ ( 'Not Generated' ),
						2 => Mage::helper ( 'edn2shipping' )->__ ( 'Generated' ),
						3 => Mage::helper ( 'edn2shipping' )->__ ( 'Ship' ),
				)
		));
		
		$this->addColumn ( 'tracking_created_at', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Created At' ),
				'index' => 'tracking_created_at',
				'type' => 'datetime',
				'width' => '70px',
				'filter_index' => 'edn2_tracking.created_at'
		) );
		
		$this->addColumn ( 'tracking_number', array (
				'header' => Mage::helper ( 'shipping' )->__ ( 'Tracking Number' ),
				'width' => '80px',
				'type' => 'text',
				'index' => 'tracking_number',
				'filter_index' => 'edn2_tracking.tracking_number',
				'renderer' => 'edn2shipping/adminhtml_widget_grid_column_renderer_trackingnumber',
				'button_shortcut_generate' => true,
				'need_confirmation' => Mage::getStoreConfig('edn2shipping_others/widget_trackingnumber/confirmation'),
				'advanced_label_generation' => Mage::getStoreConfig('edn2shipping_others/widget_trackingnumber/advanced'),
		) );
		
		$this->addColumn ( 'edn2_relayid', array (
				'header' => Mage::helper ( 'edn2shipping' )->__ ( 'Relay ID' ),
				'width' => '80px',
				'type' => 'text',
				'renderer' => 'edn2shipping/adminhtml_widget_grid_column_renderer_relay',
				'font_size' => '2.0em',
				'line_height' => '1.5em',
				'index' => 'edn2_relayid'
		) );

		$this->addColumn ( 'real_order_id', array (
				'header' => Mage::helper ( 'sales' )->__ ( 'Order #' ),
				'width' => '80px',
				'type' => 'text',
				'index' => 'increment_id',
				'filter_index' => 'main_table.increment_id'
		) );

		if (! Mage::app ()->isSingleStoreMode ()) {
			$this->addColumn ( 'store_id', array (
					'header' => Mage::helper ( 'sales' )->__ ( 'Purchased From (Store)' ),
					'index' => 'store_id',
					'type' => 'store',
					'store_view' => true,
					'display_deleted' => true,
					'filter_index' => 'main_table.store_id',

			) );
		}

		$this->addColumn ( 'created_at', array (
				'header' => Mage::helper ( 'sales' )->__ ( 'Purchased On' ),
				'index' => 'created_at',
				'type' => 'datetime',
				'width' => '100px',
				'filter_index' => 'main_table.created_at'
		) );

		$this->addColumn ( 'billing_name', array (
				'header' => Mage::helper ( 'sales' )->__ ( 'Bill to Name' ),
				'index' => 'billing_name',
				'filter_index' => 'main_table.billing_name'
		) );

		$this->addColumn('shipping_name', array(
				'header' => Mage::helper('sales')->__('Ship to Name'),
				'index' => 'shipping_name',
				'filter_index' => 'main_table.shipping_name'
		));

		$this->addColumn ( 'base_grand_total', array (
				'header' => Mage::helper ( 'sales' )->__ ( 'G.T. (Base)' ),
				'index' => 'base_grand_total',
				'type' => 'currency',
				'currency' => 'base_currency_code',
				'filter_index' => 'main_table.base_grand_total'
		) );

		$this->addColumn ( 'grand_total', array (
				'header' => Mage::helper ( 'sales' )->__ ( 'G.T. (Purchased)' ),
				'index' => 'grand_total',
				'type' => 'currency',
				'currency' => 'order_currency_code',
				'filter_index' => 'main_table.grand_total'
		) );

		$this->addColumn('status', array(
				'header' => Mage::helper('sales')->__('Status'),
				'index' => 'status',
				'filter_index' => 'main_table.status',
				'type'  => 'options',
				'width' => '70px',
				'options' => Mage::getSingleton('sales/order_config')->getStatuses(),
		));

		$shippingmethods = Mage::getSingleton ( 'adminhtml/system_config_source_shipping_allmethods' )->toOptionArray ( false );
		
		foreach($shippingmethods as $key => $group) {
			if(!isset($group['value']) || !is_array($group['value']))
				continue;
			foreach($group['value'] as $shippingmethod => $label) {
				if(!isset($label['value']))
					continue;
		
				if(!stristr($label['value'], 'edn')) {
					unset($shippingmethods[$key]);
					break;
				}
			}
		}
		
		$this->addColumn ( 'shipping_method', array (
				'header' => Mage::helper ( 'sales' )->__ ( 'Shipping Method' ),
				'index' => 'shipping_method',
				'filter_index' => 'sales_order.shipping_method',
				'type' => 'options',
				'width' => '70px',
				'filter' => 'adminhtml/widget_grid_column_filter_select',
				'renderer' => 'adminhtml/widget_grid_column_renderer_text',
				'option_groups' => $shippingmethods
		) );

		$payment = Mage::getSingleton ( 'adminhtml/system_config_source_payment_allmethods' )->toOptionArray ( true );

		$this->addColumn ( 'payment_method', array (
				'header' => Mage::helper ( 'sales' )->__ ( 'Payment Method' ),
				'index' => 'payment_method',
				'filter_index' => 'payment.method',
				'type' => 'options',
				'width' => '70px',
				'filter' => 'adminhtml/widget_grid_column_filter_select',
				'renderer' => 'adminhtml/widget_grid_column_renderer_text',
				'option_groups' => $payment
		) );

		if (Mage::getSingleton ( 'admin/session' )->isAllowed ( 'sales/order/actions/view' )) {
			$this->addColumn ( 'action', array (
					'header' => Mage::helper ( 'sales' )->__ ( 'Action' ),
					'width' => '50px',
					'type' => 'action',
					'getter' => 'getId',
					'actions' => array (
							array (
									'caption' => Mage::helper ( 'sales' )->__ ( 'View' ),
									'url' => array (
											'base' => 'adminhtml/sales_order/view'
									),
									'field' => 'order_id'
							)
					),
					'filter' => false,
					'sortable' => false,
					'index' => 'stores',
					'is_system' => true
			) );
		}
		return parent::_prepareColumns ();
	}




	protected function _prepareMassaction() {
		$this->setMassactionIdField ( 'entity_id' );
		$this->getMassactionBlock ()->setFormFieldName ( 'order_ids' );

		$this->getMassactionBlock ()->addItem ( 'print', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Print Shipping Label' ),
				'url' => $this->getUrl ( '*/*/massPrint', array (
						'_current' => true
				) )
		) );

		$this->getMassactionBlock ()->addItem ( 'generate', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Generate Shipping Label' ),
				'url' => $this->getUrl ( '*/*/massGenerate', array (
						'_current' => true
				) ),
				'additional' => array (
						'visibility' => array (
								'name' => 'force',
								'type' => 'select',
								'class' => 'required-entry',
								'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Force Regeneration' ),
								'values' => array(0 => Mage::helper ( 'edn2shipping' )->__("No"), 1 => Mage::helper ( 'edn2shipping' )->__("Yes"))
						)
				)
		) );

		$this->getMassactionBlock ()->addItem ( 'deletelabel', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Delete Shipping Label' ),
				'url' => $this->getUrl ( '*/*/massDeleteLabel', array (
						'_current' => true
				) ),
				'confirm' => Mage::helper('edn2shipping')->__('Are you sure you want to delete this Trackingnumber ? The tracking number will still keep in our servers.'),
				'additional' => array (
						'visibility' => array (
								'name' => 'force',
								'type' => 'select',
								'class' => 'required-entry',
								'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Force Deletion' ),
								'values' => array(0 => Mage::helper ( 'edn2shipping' )->__("No"), 1 => Mage::helper ( 'edn2shipping' )->__("Yes"))
						)
				)
		) );

		$this->getMassactionBlock ()->addItem ( 'shiporder', array (
				'label' => Mage::helper ( 'edn2shipping' )->__ ( 'Ship' ),
				'url' => $this->getUrl ( '*/*/massShip', array (
						'_current' => true
				) )
		) );

		return $this;
	}

	public function getRowUrl($row) {
		/*return $this->getUrl ( 'adminhtml/sales_order/edit', array (
				'_current' => true,
				'address_id' => $row->getShippingAddressId ()
		) );*/
		return false;
	}

	public function getGridUrl() {
		return $this->getUrl ( '*/*/grid', array (
				'_current' => true
		) );
	}
}