<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Block_Adminhtml_Shipping_Shipment_Index_Grid extends Mage_Adminhtml_Block_Widget_Grid {
	public function __construct() {
		parent::__construct ();
		$this->setUseAjax ( true );
		$this->setId ( 'edn2shippingShippingShipmentIndexGrid' );
		$this->setDefaultSort ( 'created_at' );
		$this->setDefaultDir ( 'DESC' );
		$this->setSaveParametersInSession ( true );
	}

	/**
     * Retrieve collection class
     *
     * @return string
     */
    protected function _getCollectionClass()
    {
        return 'sales/order_shipment_grid_collection';
    }

    /**
     * Prepare and set collection of grid
     *
     * @return Mage_Adminhtml_Block_Widget_Grid
     */
    protected function _prepareCollection()
    {
    	/* @var $collection Mage_Sales_Model_Resource_Order_Shipment_Grid_Collection */
        $collection = Mage::getResourceModel($this->_getCollectionClass());
        $collection->join(array('track' => 'sales/shipment_track'), 'main_table.entity_id = track.parent_id', array('track_number' => 'GROUP_CONCAT(`track`.`track_number` SEPARATOR "|")', 'carrier_code'));
        $collection->join(array('sales_order' => 'sales/order' ), 'main_table.order_id = sales_order.entity_id', array('shipping_method'));
        $collection->getSelect()->where('sales_order.shipping_method IN (?)', Mage::helper('edn2shipping/carrier')->getShippingMethods());
        $collection->getSelect()->group('main_table.order_id');
        
        $this->setCollection($collection);
        return parent::_prepareCollection();
    }

    /**
     * Prepare and add columns to grid
     *
     * @return Mage_Adminhtml_Block_Widget_Grid
     */
    protected function _prepareColumns()
    {
        $this->addColumn('increment_id', array(
            'header'    => Mage::helper('sales')->__('Shipment #'),
            'index'     => 'increment_id',
        	'filter_index' => 'main_table.increment_id',
            'type'      => 'text',
        ));

        $shippingmethod = Mage::getSingleton('adminhtml/system_config_source_shipping_allmethods')->toOptionArray(true);

        $this->addColumn('carrier_code', array(
        		'header' => Mage::helper('sales')->__('Shipping Method'),
        		'index' => 'carrier_code',
        		'type'  => 'options',
        		'width' => '70px',
        		'filter' => 'adminhtml/widget_grid_column_filter_select',
        		'renderer' => 'adminhtml/widget_grid_column_renderer_text',
        		'option_groups' => $shippingmethod,
        ));

        $this->addColumn('track_number', array(
        		'header'    => Mage::helper('sales')->__('Tracking number'),
        		'index'     => 'track_number',
        		'filter_index' => 'track.track_number',
        		'type'      => 'text',
        		'renderer' => 'edn2shipping/adminhtml_widget_grid_column_renderer_trackingnumber'
        ));

        $this->addColumn('created_at', array(
            'header'    => Mage::helper('sales')->__('Date Shipped'),
            'index'     => 'created_at',
        	'filter_index' => 'main_table.created_at',
            'type'      => 'datetime',
        ));

        $this->addColumn('order_increment_id', array(
            'header'    => Mage::helper('sales')->__('Order #'),
            'index'     => 'order_increment_id',
            'type'      => 'text',
        ));

        $this->addColumn('order_created_at', array(
            'header'    => Mage::helper('sales')->__('Order Date'),
            'index'     => 'order_created_at',
            'type'      => 'datetime',
        ));

        $this->addColumn('shipping_name', array(
            'header' => Mage::helper('sales')->__('Ship to Name'),
            'index' => 'shipping_name',
        ));

        $this->addColumn('total_qty', array(
            'header' => Mage::helper('sales')->__('Total Qty'),
            'index' => 'total_qty',
            'type'  => 'number',
        ));

        $this->addColumn('action',
            array(
                'header'    => Mage::helper('sales')->__('Action'),
                'width'     => '50px',
                'type'      => 'action',
                'getter'     => 'getId',
                'actions'   => array(
                    array(
                        'caption' => Mage::helper('sales')->__('View'),
                        'url'     => array('base'=>'adminhtml/sales_shipment/view'),
                        'field'   => 'shipment_id'
                    )
                ),
                'filter'    => false,
                'sortable'  => false,
                'is_system' => true
        ));

        $this->addExportType('adminhtml/sales_shipment/exportCsv', Mage::helper('sales')->__('CSV'));
        $this->addExportType('adminhtml/sales_shipment/exportExcel', Mage::helper('sales')->__('Excel XML'));

        return parent::_prepareColumns();
    }

    /**
     * Get url for row
     *
     * @param string $row
     * @return string
     */
    public function getRowUrl($row)
    {
        if (!Mage::getSingleton('admin/session')->isAllowed('sales/order/shipment')) {
            return false;
        }

        return $this->getUrl('adminhtml/sales_shipment/view',
            array(
                'shipment_id'=> $row->getId(),
            )
        );
    }

    /**
     * Prepare and set options for massaction
     *
     * @return Mage_Adminhtml_Block_Sales_Shipment_Grid
     */
    protected function _prepareMassaction()
    {
        $this->setMassactionIdField('entity_id');
        $this->getMassactionBlock()->setFormFieldName('shipment_ids');
        $this->getMassactionBlock()->setUseSelectAll(false);

        $this->getMassactionBlock()->addItem('pdfshipments_order', array(
             'label'=> Mage::helper('sales')->__('PDF Packingslips'),
             'url'  => $this->getUrl('adminhtml/sales_shipment/pdfshipments'),
        ));

        $this->getMassactionBlock()->addItem('print_shipping_label', array(
             'label'=> Mage::helper('sales')->__('Print Shipping Labels'),
             'url'  => $this->getUrl('*/*/massPrintShippingLabel'),
        ));

        return $this;
    }

    /**
     * Get url of grid
     *
     * @return string
     */
    public function getGridUrl()
    {
        return $this->getUrl('*/*/grid', array('_current' => true));
    }
}