<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Block_Adminhtml_Widget_Grid_Column_Renderer_Relay extends Mage_Adminhtml_Block_Widget_Grid_Column_Renderer_Abstract {
	
	/**
	 * Render Relay grid column
	 *
	 * @param Varien_Object $row
	 * @return string
	 */
	public function render(Varien_Object $row)
	{
		$fontSize = "2.9em";
		if($this->getColumn()->getFontSize())
			$fontSize = $this->getColumn()->getFontSize();
		$lineHeight = "1.8em";
		if($this->getColumn()->getLineHeight())
			$lineHeight = $this->getColumn()->getLineHeight();

		if ($data = $row->getData($this->getColumn()->getIndex())) {
			$carrier = $this->getRequest()->getParam('carrier', false);
			if(!$carrier) {
				if($shippingMethod = $row->getData('shipping_method')) {
					if($carrierInstance = Mage::helper('edn2shipping/carrier')->getCarrierInstanceByShippingMethod($shippingMethod)) {
						$carrier = $carrierInstance->getShippingMethod();
					}
				}
			}

			$country = $this->getRequest()->getParam('country', false);
			if($country == false) {
				$country = $row->getShippingAddress()->getCountry();
			}

			if($carrier) {
				return sprintf(
					'<a href="#" onclick="javascript: window.open(\'%s\',\'EDN2 Relay Information\',\'toolbar=no, location=no, directories=no, status=no,scrollbars=yes, resizable=yes, copyhistory=no, width=950, height=800, left=200, top=100\'); return false;" style="text-decoration: none;text-align: center; font-size: %s;width: auto;display: block;color: #000;vertical-align: middle; line-height: %s;">%s</a>',
					$this->getRelayUrl($carrier, $data, $country),
					$fontSize,
					$lineHeight,
					$data);
			} else {
				return sprintf(
					'<span style="text-decoration: none;text-align: center; font-size: %s;width: auto;display: block;color: #000;vertical-align: middle; line-height: %s;">%s</span>',
					$fontSize,
					$lineHeight,
					$data);
			}

		}
		return null;
	}
	
	protected function getRelayUrl($carrier, $relayid, $country) {
		return Mage::getUrl('edn2shipping/relay/view', array( "carrier" => $carrier, "relayid" => $relayid, "country" => $country));
	}
}