<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Block_Adminhtml_Widget_Grid_Column_Renderer_Trackingnumber extends Mage_Adminhtml_Block_Widget_Grid_Column_Renderer_Abstract {
	/**
	 * Render Tracking Number grid column
	 *
	 * @param Varien_Object $row
	 * @return string
	 */
	public function render(Varien_Object $row) {
		$template = '<div style="text-align: center;width: auto;">%s</div><a href="#" onclick="javascript: window.open(\'%s\',\'Envoidunet - Tracking\',\'toolbar=no, location=no, directories=no, status=no,scrollbars=yes, resizable=yes, copyhistory=no, width=1050, height=800, left=200, top=100\'); return false;" style="text-align: center;width: auto;display: block;">Suivre</a>';
		
		if ($data = $row->getData ( $this->getColumn ()->getIndex () )) {
			$html = array();
			foreach(explode('|', $data) as $trackingNumber) {
				$html [] = sprintf (
				$template,
				$trackingNumber,
				($row->getTrackingUrl()) ? $row->getTrackingUrl() :  $this->getTrackUrl ( $trackingNumber )
				);
			}
			return implode('<br />', $html);
		} else {
			$html = '<div style="text-align:center;">' . Mage::helper('edn2shipping')->__("Not Generated");
			$html .= '<br />';
			if($this->getColumn()->getButtonShortcutGenerate()) {
				$needConfirmation = $this->getColumn()->getNeedConfirmation();
				$advancedLabelGeneration = $this->getColumn()->getAdvancedLabelGeneration();
				
				$html .= '<button onclick="';
				if($needConfirmation)
					$html .= 'if(confirm(\''.Mage::helper('edn2shipping')->__("Are you sure you want to generate a label ?").'\')) ';
	
				$url = $this->getUrl('adminhtml/edn2_shipping_sales/generateLabel', array('order_id' => $row->getId()));
					
				if($advancedLabelGeneration)
					$url = $this->getUrl('adminhtml/edn2_shipping_label/index', array('order_id' => $row->getId()));
					
				$html .= 'window.open(\''. $url .'\'); return false;"><span><span><span>'. Mage::helper('edn2shipping')->__("Create Label") .'</span></span></span></button>';	
			}
			$html .= '</div>';
			return $html;
		}
		return null;
	}
	
	protected function getTrackUrl($trackingNumber) {
		return sprintf ( "http://www.envoidunet.com/fr/suivi-colis/%s", $trackingNumber );
	}
}