<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Block_Relay_Search extends Mage_Core_Block_Abstract {
	
	protected $_carriers = array();
	protected $_rates;
	protected $_country;
	protected $_postcode;
	protected $_city;
	protected $_street;

	/**
	 * Cache group Tag
	 */
	const CACHE_GROUP = 'edn_block_html';
    
	
	/**
	 * (non-PHPdoc)
	 *
	 * @see Mage_Core_Block_Abstract::getCacheKey()
	 */
	public function getCacheKey() {
		$cache = array();
    	// BASIC DATA
    	$cache['block'] = __CLASS__;
    	$cache[] = Mage::app()->getStore()->getCode();
    	$cache[] = Mage::app()->getStore()->getCurrentCurrencyCode();
    	$cache[] = (int) Mage::app()->getStore()->isCurrentlySecure();
    	$cache[] = Mage::getDesign()->getPackageName();
    	$cache[] = Mage::getDesign()->getTheme('template');
    	
    	// DYNAMIC DATA
    	$cache[] = implode(',', $this->_carriers);
    	$cache[] = $this->_country;
    	$cache[] = $this->_postcode;
    	$cache[] = $this->_city;
		return 'EDN2_SHIPPING_BLOCK_RELAY_SEARCH_' . sha1 ( implode(',', $cache) );
	}
	
	protected function _construct() {
		/* @var $checkoutSession Mage_Checkout_Model_Session */
		$checkoutSession = Mage::getSingleton('checkout/session');
		if($checkoutSession) {
			$salesQuote = $checkoutSession->getQuote();
			if($salesQuote) {
				$salesQuoteShippingAddress = $salesQuote->getShippingAddress();
				if($salesQuoteShippingAddress) {
					$this->_country = $salesQuoteShippingAddress->getCountryId();
					$this->_postcode = $salesQuoteShippingAddress->getPostcode();
					$this->_city = $salesQuoteShippingAddress->getCity();
					$this->_street = $salesQuoteShippingAddress->getStreet1();
					if($this->getRequest()->getParam('carrier'))
					   $this->_carriers = explode(',', $this->getRequest()->getParam('carrier'));
					
					/* @var $shipping Mage_Shipping_Model_Shipping */
					$shipping = Mage::getSingleton('shipping/shipping');
					$this->_rates = $shipping->collectRatesByAddress($salesQuoteShippingAddress)->getResult();

					if(!count($this->_carriers)) {
					    /* @var $rate Mage_Shipping_Model_Rate_Result_Method */
					    foreach($this->_rates->getAllRates() as $rate) {
							if(Mage::helper('edn2shipping/carrier')->isRelayAndActive($rate->getCarrier())) {
					            $this->_carriers[] = $rate->getMethod();
					        }
					    }
					} else {
    					foreach($this->_carriers as $idx => $carrier) {
    					    if(!Mage::helper('edn2shipping/carrier')->isRelayAndActive($carrier)) {
    					        unset($this->_carriers[$idx]);
    					    }
    					}
					}

					if(!count($this->_carriers))
					   return;
					
					$this->addData(array(
							'cache_lifetime' => 21600, // 6 hours
							'cache_tags'     => array(Mage_Core_Block_Template::CACHE_GROUP, self::CACHE_GROUP),
							'cache_key'      => $this->getCacheKey(),
					));
				}
			}
		}
	}
	
	/**
	 * (non-PHPdoc)
	 *
	 * @see Mage_Core_Block_Template::_toHtml()
	 */
	protected function _toHtml() {
		Varien_Profiler::start(__METHOD__);
		$result = array ( 'center' => null, 'carriers' => null );
		if($this->_country && $this->_postcode && count($this->_carriers)) {
		    $coords = array();
		    foreach($this->_carriers as $carrier) {
				$result['carriers'][$carrier] = Mage::helper('edn2shipping/carrier')->findRelaysByCarrierCode( $carrier, $this->_country, $this->_postcode, $this->_city);
				if(isset($result['carriers'][$carrier]) && isset($result['carriers'][$carrier]['center'])) {
					$coords[] = $result['carriers'][$carrier]['center'];
				}
		    }
		    if(count($coords))
		        $result['center'] = Mage::helper('edn2core/math')->getCenterFromDegrees($coords);
		    
		    /* @var $block EDN2_Shipping_Block_Relay_Search_View */
		    if($block = $this->getChild('relay_search_view')) {
		      $block->setData('result', $result);
		      $block->setData('rates', $this->_rates);
		      $result['html'] = $block->toHtml();
		    }
		}
		/* @var $coreHelper Mage_Core_Helper_Data */
		$coreHelper = Mage::helper('core');
		$result = $coreHelper->jsonEncode($result);
		Varien_Profiler::stop(__METHOD__);
		return $result;
	}
}