<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Block_Relay_Search_View extends Mage_Core_Block_Template {
    
    /**
     * Cache group Tag
     */
    const CACHE_GROUP = 'edn_block_html';
    
    protected function _construct() {
        $this->setTemplate('edn2/shipping/relay/search/view.phtml');
    }
    
    public function getEDNRate($method) {
        foreach($this->getRates()->getAllRates() as $rate) {
            if($rate->getMethod() == $method)
                return $rate;
        }
        return false;
    }
    
    /**
     * Retrieve checkout session model
     *
     * @return Mage_Checkout_Model_Session
     */
    public function getCheckout()
    {
        if (empty($this->_checkout)) {
            $this->_checkout = Mage::getSingleton('checkout/session');
        }
        return $this->_checkout;
    }
    
    /**
     * Retrieve sales quote model
     *
     * @return Mage_Sales_Model_Quote
     */
    public function getQuote()
    {
        if (empty($this->_quote)) {
            $this->_quote = $this->getCheckout()->getQuote();
        }
        return $this->_quote;
    }
    
    public function getShippingPrice($price, $flag)
    {
        return $this->getQuote()->getStore()->convertPrice(Mage::helper('tax')->getShippingPrice($price, $flag, $this->getAddress()), true);
    }
    
    public function getShippingPriceHtml($rate) {
        $html = '';
        $_excl = $this->getShippingPrice($rate->getPrice(), $this->helper('tax')->displayShippingPriceIncludingTax());
        $_incl = $this->getShippingPrice($rate->getPrice(), true);
        $html .= "&nbsp;&nbsp;{$_excl}";
        if ($this->helper('tax')->displayShippingBothPrices() && $_incl != $_excl) {
            $html .= "({$this->__('Incl. Tax')} {$_incl})";
        }
        return $html;
    }
}