<?php
class EDN2_Shipping_Model_System_Config_Backend_Colisprive_Postcode extends Mage_Adminhtml_Model_System_Config_Backend_File {
	/**
	 * The tail part of directory path for uploading
	 *
	 */
	const UPLOAD_DIR = 'edn2';
	
	/**
	 * Token for the root part of directory path for uploading
	 *
	 */
	const UPLOAD_ROOT = 'media';
	
	/**
	 * Return path to directory for upload file
	 *
	 * @return string
	 * @throw Mage_Core_Exception
	 */
	protected function _getUploadDir()
	{
		$uploadDir = $this->_appendScopeInfo(self::UPLOAD_DIR);
		$uploadRoot = $this->_getUploadRoot(self::UPLOAD_ROOT);
		$uploadDir = $uploadRoot . '/' . $uploadDir;
		return $uploadDir;
	}
	
	/**
	 * Makes a decision about whether to add info about the scope.
	 *
	 * @return boolean
	 */
	protected function _addWhetherScopeInfo()
	{
		return false;
	}
	
	/**
	 * Getter for allowed extensions of uploaded files.
	 *
	 * @return array
	 */
	protected function _getAllowedExtensions()
	{
		return array('csv');
	}
	
	/**
	 * Get real media dir path
	 *
	 * @param  $token
	 * @return string
	 */
	protected function _getUploadRoot($token) {
		return Mage::getBaseDir($token);
	}
	
	
	 
    protected function _beforeSave()
    {
    	parent::_beforeSave();
    	
    	if($this->getValue()) {
	    	$csv = new Varien_File_Csv();
	    	$data = $csv->getData($this->_getUploadDir() . DS . $this->getValue());
	    	if($data && is_array($data)) {
	    		/* @var $colisprivePostcodeResource EDN2_Shipping_Model_Resource_Colisprive_Postcode */
	    		$colisprivePostcodeResource = Mage::getResourceModel('edn2shipping/colisprive_postcode');
	    		try {
	    			$colisprivePostcodeResource->beginTransaction();
		    		$colisprivePostcodeResource->truncate();
		    		foreach($data as $postcode) {
		    			if(!is_array($postcode))
		    				continue;
		    			$postcode = trim(current($postcode));
		    			if(!$postcode)
		    				continue;
		    			Mage::getModel('edn2shipping/colisprive_postcode')->setPostcode($postcode)->save();
		    		}
		    		$colisprivePostcodeResource->commit();
	    		} catch(Exception $e) {
	    			$colisprivePostcodeResource->rollBack();
	    			throw $e;
	    		}
	    		Mage::getSingleton('core/session')->addSuccess(Mage::helper('edn2shipping')->__('CSV Loaded. Authorized Postcode: %s', count($data)));
	    	} else {
	    		throw new Exception(Mage::helper('edn2shipping')->__('Cannot read CSV.'));
	    	}
	    	Varien_Io_File::rmdirRecursive($this->_getUploadDir());
    	}
    	return $this;
    }
    
}