<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Model_System_Config_Source_Percentround
{
	const PERCENT_ROUND_NORMAL = 1;
	const PERCENT_ROUND_NORMAL_PRE1 = 2;
	const PERCENT_ROUND_CEIL = 3;
	const PERCENT_ROUND_FLOOR = 4;
	
	public function toOptionArray()
	{
		return array(
				array('value'=> 0, 'label'=> Mage::helper('edn2shipping')->__('N/A')),
				array('value'=> self::PERCENT_ROUND_NORMAL, 'label'=> Mage::helper('edn2shipping')->__('Standard Round with precision of 0')),
				array('value'=> self::PERCENT_ROUND_NORMAL_PRE1, 'label'=> Mage::helper('edn2shipping')->__('Standard Round with precision of 1')),
				array('value'=> self::PERCENT_ROUND_CEIL, 'label'=> Mage::helper('edn2shipping')->__('Round fractions up')),
				array('value'=> self::PERCENT_ROUND_FLOOR, 'label'=> Mage::helper('edn2shipping')->__('Round fractions down')),
		);
	}
}
