<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Adminhtml_Edn2_Shipping_LabelController extends Mage_Adminhtml_Controller_Action {
    /**
     * Check admin permissions for this controller
     *
     * @return boolean
     */
    protected function _isAllowed()
    {
        return Mage::getSingleton('admin/session')->isAllowed('edn2/edn2_shipping/edn2_shipping_label');
        return true;
    }

    protected function _init() {
		$this->loadLayout();
		$this->_setActiveMenu('edn2/edn2_shipping/edn2_shipping_label');
		$this->_addBreadcrumb($this->__('EDN2 Shipping'), $this->__('EDN2 Shipping'));
		return $this;
	}
	
	public function indexAction() {
		$this->_title($this->__('EDN2'));
		$this->_title($this->__('Label Creator'));
		$this->_init();
		$this->renderLayout ();
	}
	
	public function createLabelAction() {
		$incrementId = $this->getRequest ()->getParam ( 'increment_id', false );
		$parcels = $this->getRequest()->getParam('parcel');
		$force = (bool) $this->getRequest ()->getParam ( 'force', false );
		$forceCarrier = $this->getRequest()->getParam('force_carrier', null);
		$relayid = $this->getRequest()->getParam('relayid', null);
		if ($incrementId && is_array($parcels)) {
			/* @var $salesOrder Mage_Sales_Model_Order */
			$salesOrder = Mage::getModel ( 'sales/order' )->loadByIncrementId ( $incrementId );
			if ($salesOrder->getId ()) {
				try {
					if(!$salesOrder->hasInvoices()) {
						throw new Exception(Mage::helper('edn2shipping')->__('Order %s is not invoiced. Please Invoice this Order first.', $salesOrder->getIncrementId()));
					}

					if(!$forceCarrier && !Mage::helper('edn2shipping/carrier')->getCarrierInstanceByShippingMethod($salesOrder->getShippingMethod())) {
						throw new Exception(Mage::helper('edn2shipping')->__('Order %s is not an EDN order.', $salesOrder->getIncrementId()));
					}

					if(!$force) {
						if($salesOrder->hasShipments()) {
							throw new Exception(Mage::helper('edn2shipping')->__('Order %s is already shipped.', $salesOrder->getIncrementId()));
						}
	
						if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_CLOSED) {
							throw new Exception(Mage::helper('edn2shipping')->__('Order label %s can\'t be generated. This Order is fully refunded.', $salesOrder->getIncrementId()));
						}
	
						if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_HOLDED) {
							throw new Exception(Mage::helper('edn2shipping')->__('Order %s is Holded. The label is still generated.', $salesOrder->getIncrementId()));
						}
	
						if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_COMPLETE) {
							throw new Exception(Mage::helper('edn2shipping')->__('Order label %s can\'t be generated. This Order is fully shipped.', $salesOrder->getIncrementId()));
						}
					}

					try {
						/* @var $tracking EDN2_Shipping_Model_Tracking */
						$tracking = Mage::getModel('edn2shipping/tracking')->load($salesOrder->getId(), 'order_id');
						$tracking->setOrder($salesOrder);
						if(!$tracking->getTrackingNumber() || !$tracking->getTrackingPdfUrl() || $force) {
							$weight = array();
							foreach($parcels as $parcel) {
								$weight[] = $parcel['weight'];
							}
							$tracking->generateLabel($forceCarrier, $relayid, $force, $weight);
							$tracking->save();
							$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order label %s generated. <a href="%s" target="_blank">Download label</a>.', $salesOrder->getIncrementId(), $tracking->getTrackingPdfUrl()));
						} else {
							$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order label %s already generated. <a href="%s" target="_blank">Download label</a>.', $salesOrder->getIncrementId(), $tracking->getTrackingPdfUrl()));
						}
					} catch(Exception $e) {
						$this->_getSession()->addError($e->getMessage());
					}
				} catch ( Exception $e ) {
					$this->_getSession ()->addError ( $e->getMessage() );
				}
			} else {
				$this->_getSession ()->addError ( $this->__('Order %s not found.', $incrementId) );
			}
		} else {
			$this->_getSession ()->addError ( $this->__ ( 'Invalid Request.' ) );
		}
		$this->_redirect ( '*/*/index', array('increment_id' => $incrementId, 'weight' => $weight) );
	}
}
