<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
#require_once "EDN2/Shipping/controllers/Adminhtml/Edn2/Shipping/SalesController.php";
require_once Mage::getModuleDir('controllers', 'EDN2_Shipping') . DS . 'Adminhtml' . DS . 'Edn2' . DS . 'Shipping' . DS . 'SalesController.php';
class EDN2_Shipping_Adminhtml_Edn2_Shipping_Sales_OtherController extends EDN2_Shipping_Adminhtml_Edn2_Shipping_SalesController {
    /**
     * Check admin permissions for this controller
     *
     * @return boolean
     */
    protected function _isAllowed()
    {
        return Mage::getSingleton('admin/session')->isAllowed('edn2/edn2_shipping/edn2_shipping_sales_other');
        return true;
    }

    protected function _init() {
		$this->loadLayout();
		$this->_setActiveMenu('edn2/edn2_shipping/edn2_shipping_sales_other');
		$this->_addBreadcrumb($this->__('EDN2 Shipping'), $this->__('EDN2 Shipping'));
		return $this;
	}
	
	public function indexAction() {
		$this->_title($this->__('EDN2'));
		$this->_title($this->__('Envoidunet Sales Other'));
		$this->_init();
		$this->renderLayout();
	}

	public function gridAction() {
		$this->loadLayout();
		$this->renderLayout();
	}
	
	public function massGenerateAction() {
		$orderIds = $this->getRequest()->getParam('order_ids', false);
		$carrier = $this->getRequest()->getParam('carrier', false);
		$force = (bool) $this->getRequest()->getParam('force', false);
	
		if($orderIds && is_array($orderIds)) {
			if($carrier) {
				$pdfArr = array();
					
				foreach($orderIds as $orderId) {
					/* @var $salesOrder Mage_Sales_Model_Order */
					$salesOrder = Mage::getModel('sales/order')->load($orderId);
					if(!$salesOrder->getId()) {
						$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order %s not found.', $orderId));
						continue;
					}
		
					if(!$salesOrder->hasInvoices()) {
						$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order %s is not invoiced. Please Invoice this Order first.', $salesOrder->getIncrementId()));
						continue;
					}
		
					if(!$force) {
						if($salesOrder->hasShipments()) {
							$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order %s is already shipped.', $salesOrder->getIncrementId()));
							continue;
						}
		
						if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_CLOSED) {
							$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order label %s can\'t be generated. This Order is fully refunded.', $salesOrder->getIncrementId()));
							continue;
						}
		
						if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_HOLDED) {
							$this->_getSession()->addWarning(Mage::helper('edn2shipping')->__('Order %s is Holded. The label is still generated.', $salesOrder->getIncrementId()));
							continue;
						}
		
						if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_COMPLETE) {
							$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order label %s can\'t be generated. This Order is fully shipped.', $salesOrder->getIncrementId()));
							continue;
						}
					}
		
		
		
					try {
						/* @var $tracking EDN2_Shipping_Model_Tracking */
						$tracking = Mage::getModel('edn2shipping/tracking')->load($orderId, 'order_id');
						$tracking->setOrder($salesOrder);
						if(!$tracking->getTrackingNumber() || !$tracking->getTrackingPdfUrl() || $force) {
							$tracking->generateLabel($carrier, null, $force);
							$tracking->save();
							$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order label %s generated. <a href="%s" target="_blank">Download label</a>.', $salesOrder->getIncrementId(), $tracking->getTrackingPdfUrl()));
							$pdfArr[] = $tracking->getTrackingPdfUrl();
						} else {
							$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order label %s already generated. <a href="%s" target="_blank">Download label</a>.', $salesOrder->getIncrementId(), $tracking->getTrackingPdfUrl()));
							$pdfArr[] = $tracking->getTrackingPdfUrl();
						}
					} catch(Exception $e) {
						$this->_getSession()->addError($e->getMessage());
					}
				}
					
				if(!empty($pdfArr)) {
					try {
						$pdfZend = new Zend_Pdf();
						$extractor = new Zend_Pdf_Resource_Extractor();
						foreach($pdfArr as $pdfUrl) {
							$content = Mage::helper('edn2core')->fileGetContents($pdfUrl);
							$file_info = new finfo(FILEINFO_MIME);
							$mime_type = $file_info->buffer($content);
							if(strstr($mime_type, "application/pdf")) {
								$pdf = Zend_Pdf::parse($content);
								foreach ($pdf->pages as $p) $pdfZend->pages[] = $extractor->clonePage($p);
							} else {
								$this->_getSession()->addError($this->__("Cannot Download Label. (%s)", $pdfUrl));
							}
						}
							
						$folder = Mage::getBaseDir('media') . DS . 'edn2';
						$file = "edn2_pdfs_" . md5(microtime(true)) . ".pdf";
						$ioAdapter = new Varien_Io_File();
						$ioAdapter->checkAndCreateFolder($folder);
						$ioAdapter->cd($folder);
						$ioAdapter->streamOpen($file);
						$ioAdapter->streamWrite($pdfZend->render());
						$ioAdapter->streamClose();
							
						$url = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . '/edn2/' . $file;
							
						$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order labels has been merged into one pdf file <a href="%s" target="_blank">Downlad merged labels</a>.', $url));
					} catch(Exception $e) {
						$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Problem when generating a merged pdf file. (Reason: %s)', $e->getMessage()));
					}
				}
			}
		}
		$this->_redirect('*/*/index');
	}
}