<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Adminhtml_Edn2_Shipping_SalesController extends Mage_Adminhtml_Controller_Action {
    /**
     * Check admin permissions for this controller
     *
     * @return boolean
     */
    protected function _isAllowed()
    {
        return Mage::getSingleton('admin/session')->isAllowed('edn2/edn2_shipping/edn2_shipping_sales');
        return true;
    }

    protected function _init() {
		$this->loadLayout();
		$this->_setActiveMenu('edn2/edn2_shipping/edn2_shipping_sales');
		$this->_addBreadcrumb($this->__('EDN2 Shipping'), $this->__('EDN2 Shipping'));
		return $this;
	}
	
	public function indexAction() {
		$this->_title($this->__('EDN2'));
		$this->_title($this->__('Envoidunet Sales'));
		$this->_init();
		$this->renderLayout();
	}

	public function gridAction() {
		$this->loadLayout();
		$this->renderLayout();
	}

	public function massShipAction() {
		$orderIds = $this->getRequest()->getParam('order_ids', false);
		if($orderIds && is_array($orderIds)) {
			foreach($orderIds as $orderId) {
				/* @var $salesOrder Mage_Sales_Model_Order */
				$salesOrder = Mage::getModel('sales/order')->load($orderId);
				if(!$salesOrder->getId()) {
					$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order %s not found.', $orderId));
					continue;
				}

				try {
					/* @var $tracking EDN2_Shipping_Model_Tracking */
					$tracking = Mage::getModel('edn2shipping/tracking')->load($orderId, 'order_id');
					if($tracking->getId()) {
						$tracking->shipOrder();
						$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order %s shipped. (Tracking Number: %s)', $salesOrder->getIncrementId(), implode(',', explode('|', $tracking->getTrackingNumber()))));
					} else {
						$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order label %s not found.', $salesOrder->getIncrementId()));
					}
				} catch(Exception $e) {
					$this->_getSession()->addError($e->getMessage());
				}
			}
		}
		$this->_redirect('*/*/index');
	}

	public function massDeleteLabelAction() {
		$orderIds = $this->getRequest()->getParam('order_ids', false);
		$force = (bool) $this->getRequest()->getParam('force', false);
		if($orderIds && is_array($orderIds)) {
			foreach($orderIds as $orderId) {
				/* @var $salesOrder Mage_Sales_Model_Order */
				$salesOrder = Mage::getModel('sales/order')->load($orderId);
				if(!$salesOrder->getId()) {
					$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order %s not found.', $orderId));
					continue;
				}

				try {
					/* @var $tracking EDN2_Shipping_Model_Tracking */
					$tracking = Mage::getModel('edn2shipping/tracking')->load($orderId, 'order_id');

					if($tracking->getId()) {
						if(!$force) {
							if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_COMPLETE) {
								$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order label %s can\'t be deleted. This Order is fully shipped.', $salesOrder->getIncrementId()));
								continue;
							}
						}
						$tracking->delete();
						$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order label %s deleted.', $salesOrder->getIncrementId()));
					} else {
						$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order label %s not found.', $salesOrder->getIncrementId()));
					}
				} catch(Exception $e) {
					$this->_getSession()->addError($e->getMessage());
				}
			}
		}

		$this->_redirect('*/*/index');
	}

	public function massPrintAction() {
		$orderIds = $this->getRequest()->getParam('order_ids', false);

		if($orderIds && is_array($orderIds)) {
			$pdfArr = array();
			
			foreach($orderIds as $orderId) {
				/* @var $salesOrder Mage_Sales_Model_Order */
				$salesOrder = Mage::getModel('sales/order')->load($orderId);
				if(!$salesOrder->getId()) {
					$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order %s not found.', $orderId));
					continue;
				}

				
				
				try {
					/* @var $tracking EDN2_Shipping_Model_Tracking */
					$tracking = Mage::getModel('edn2shipping/tracking')->load($orderId, 'order_id');
					$tracking->setOrder($salesOrder);
					if($tracking->getTrackingNumber() && $tracking->getTrackingPdfUrl()) {
						$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order label %s. <a href="%s" target="_blank">Download label</a>.', $salesOrder->getIncrementId(), $tracking->getTrackingPdfUrl()));
						$pdfArr[] = $tracking->getTrackingPdfUrl();
					} else {
						$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order label #%s not found.', $salesOrder->getIncrementId()));
					}
				} catch(Exception $e) {
					$this->_getSession()->addError($e->getMessage());
				}
			}
			
			if(!empty($pdfArr)) {
				try {
					$pdfZend = new Zend_Pdf();
					$extractor = new Zend_Pdf_Resource_Extractor();
					foreach($pdfArr as $pdfUrl) {
						$content = Mage::helper('edn2core')->fileGetContents($pdfUrl);
						$file_info = new finfo(FILEINFO_MIME);
						$mime_type = $file_info->buffer($content);
						if(strstr($mime_type, "application/pdf")) {
							$pdf = Zend_Pdf::parse($content);
							foreach ($pdf->pages as $p) $pdfZend->pages[] = $extractor->clonePage($p);
						} else {
							$this->_getSession()->addError($this->__("Cannot Download Label. (%s)", $pdfUrl));
						}
					}
			
					$folder = Mage::getBaseDir('media') . DS . 'edn2';
					$file = "edn2_pdfs_" . md5(microtime(true)) . ".pdf";
					$ioAdapter = new Varien_Io_File();
					$ioAdapter->checkAndCreateFolder($folder);
					$ioAdapter->cd($folder);
					$ioAdapter->streamOpen($file);
					$ioAdapter->streamWrite($pdfZend->render());
					$ioAdapter->streamClose();
			
					$url = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . '/edn2/' . $file;
			
					$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order labels has been merged into one pdf file <a href="%s" target="_blank">Downlad merged labels</a>.', $url));
				} catch(Exception $e) {
					$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Problem when generating a merged pdf file. (Reason: %s)', $e->getMessage()));
				}
			}
		}
		$this->_redirect('*/*/index');
	}

	public function massGenerateAction() {
		$orderIds = $this->getRequest()->getParam('order_ids', false);
		$force = (bool) $this->getRequest()->getParam('force', false);

		if($orderIds && is_array($orderIds)) {
			$pdfArr = array();
			
			foreach($orderIds as $orderId) {
				/* @var $salesOrder Mage_Sales_Model_Order */
				$salesOrder = Mage::getModel('sales/order')->load($orderId);
				if(!$salesOrder->getId()) {
					$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order %s not found.', $orderId));
					continue;
				}

				if(!$salesOrder->hasInvoices()) {
					$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order %s is not invoiced. Please Invoice this Order first.', $salesOrder->getIncrementId()));
					continue;
				}

				if(!$force) {
					if($salesOrder->hasShipments()) {
						$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order %s is already shipped.', $salesOrder->getIncrementId()));
						continue;
					}
	
					if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_CLOSED) {
						$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order label %s can\'t be generated. This Order is fully refunded.', $salesOrder->getIncrementId()));
						continue;
					}
	
					if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_HOLDED) {
						$this->_getSession()->addWarning(Mage::helper('edn2shipping')->__('Order %s is Holded. The label is still generated.', $salesOrder->getIncrementId()));
						continue;
					}
	
					if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_COMPLETE) {
						$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Order label %s can\'t be generated. This Order is fully shipped.', $salesOrder->getIncrementId()));
						continue;
					}
				}

				
				
				try {
					/* @var $tracking EDN2_Shipping_Model_Tracking */
					$tracking = Mage::getModel('edn2shipping/tracking')->load($orderId, 'order_id');
					$tracking->setOrder($salesOrder);
					if(!$tracking->getTrackingNumber() || !$tracking->getTrackingPdfUrl() || $force) {
						$tracking->generateLabel(null, null, $force);
						$tracking->save();
						$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order label %s generated. <a href="%s" target="_blank">Download label</a>.', $salesOrder->getIncrementId(), $tracking->getTrackingPdfUrl()));
						$pdfArr[] = $tracking->getTrackingPdfUrl();
					} else {
						$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order label %s already generated. <a href="%s" target="_blank">Download label</a>.', $salesOrder->getIncrementId(), $tracking->getTrackingPdfUrl()));
						$pdfArr[] = $tracking->getTrackingPdfUrl();
					}
				} catch(Exception $e) {
					$this->_getSession()->addError($e->getMessage());
				}
			}
			
			if(!empty($pdfArr)) {
				try {
					$pdfZend = new Zend_Pdf();
					$extractor = new Zend_Pdf_Resource_Extractor();
					foreach($pdfArr as $pdfUrl) {
						$content = Mage::helper('edn2core')->fileGetContents($pdfUrl);
						$file_info = new finfo(FILEINFO_MIME);
						$mime_type = $file_info->buffer($content);
						if(strstr($mime_type, "application/pdf")) {
							$pdf = Zend_Pdf::parse($content);
							foreach ($pdf->pages as $p) $pdfZend->pages[] = $extractor->clonePage($p);
						} else {
							$this->_getSession()->addError($this->__("Cannot Download Label. (%s)", $pdfUrl));
						}
					}
			
					$folder = Mage::getBaseDir('media') . DS . 'edn2';
					$file = "edn2_pdfs_" . md5(microtime(true)) . ".pdf";
					$ioAdapter = new Varien_Io_File();
					$ioAdapter->checkAndCreateFolder($folder);
					$ioAdapter->cd($folder);
					$ioAdapter->streamOpen($file);
					$ioAdapter->streamWrite($pdfZend->render());
					$ioAdapter->streamClose();
			
					$url = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . '/edn2/' . $file;
			
					$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order labels has been merged into one pdf file <a href="%s" target="_blank">Downlad merged labels</a>.', $url));
				} catch(Exception $e) {
					$this->_getSession()->addError(Mage::helper('edn2shipping')->__('Problem when generating a merged pdf file. (Reason: %s)', $e->getMessage()));
				}
			}
		}
		$this->_redirect('*/*/index');
	}
	
	public function generateLabelAction() {
		$orderId = $this->getRequest()->getParam('order_id', false);
		
		if($orderId) {
				/* @var $salesOrder Mage_Sales_Model_Order */
				$salesOrder = Mage::getModel('sales/order')->load($orderId);
				if(!$salesOrder->getId()) {
					echo htmlentities(Mage::helper('edn2shipping')->escapeHtml(Mage::helper('edn2shipping')->__('Order %s not found.', $orderId)));
					exit;
				}
		
				if(!$salesOrder->hasInvoices()) {
					echo htmlentities(Mage::helper('edn2shipping')->escapeHtml(Mage::helper('edn2shipping')->__('Order %s is not invoiced. Please Invoice this Order first.', $salesOrder->getIncrementId())));
					exit;
				}
		
				if($salesOrder->hasShipments()) {
					echo htmlentities(Mage::helper('edn2shipping')->escapeHtml(Mage::helper('edn2shipping')->__('Order %s is already shipped.', $salesOrder->getIncrementId())));
					exit;
				}
	
				if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_CLOSED) {
					echo htmlentities(Mage::helper('edn2shipping')->escapeHtml(Mage::helper('edn2shipping')->__('Order label %s can\'t be generated. This Order is fully refunded.', $salesOrder->getIncrementId())));
					exit;
				}
	
				if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_HOLDED) {
					echo htmlentities(Mage::helper('edn2shipping')->escapeHtml(Mage::helper('edn2shipping')->__('Order %s is Holded. The label is still generated.', $salesOrder->getIncrementId())));
					exit;
				}
	
				if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_COMPLETE) {
					echo htmlentities(Mage::helper('edn2shipping')->escapeHtml(Mage::helper('edn2shipping')->__('Order label %s can\'t be generated. This Order is fully shipped.', $salesOrder->getIncrementId())));
					exit;
				}
			
				try {
					/* @var $tracking EDN2_Shipping_Model_Tracking */
					$tracking = Mage::getModel('edn2shipping/tracking')->load($orderId, 'order_id');
					$tracking->setOrder($salesOrder);
					if(!$tracking->getTrackingNumber() || !$tracking->getTrackingPdfUrl()) {
						$tracking->generateLabel();
						$tracking->save();
						$this->_prepareDownloadResponse($salesOrder->getIncrementId() . ".pdf", Mage::helper('edn2core')->fileGetContents($tracking->getTrackingPdfUrl()));
					} else {
						$this->_prepareDownloadResponse($salesOrder->getIncrementId() . ".pdf", Mage::helper('edn2core')->fileGetContents($tracking->getTrackingPdfUrl()));
					}
				} catch(Exception $e) {
					echo Mage::helper('edn2shipping')->escapeHtml($e->getMessage());
					exit;
				}
			}
	}
}