<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_Adminhtml_Edn2_Shipping_ShipmentController extends Mage_Adminhtml_Controller_Action {
    /**
     * Check admin permissions for this controller
     *
     * @return boolean
     */
    protected function _isAllowed()
    {
        return Mage::getSingleton('admin/session')->isAllowed('edn2/edn2_shipping/edn2_shipping_shipment');
        return true;
    }

    protected function _init() {
		$this->loadLayout();
		$this->_setActiveMenu('edn2/edn2_shipping/edn2_shipping_shipment');
		$this->_addBreadcrumb($this->__('EDN2 Shipping'), $this->__('EDN2 Shipping'));
		return $this;
	}
	
	public function indexAction() {
		$this->_title($this->__('EDN2'));
		$this->_title($this->__('Envoidunet Shipment'));
		$this->_init();
		$this->renderLayout();
	}

	public function gridAction() {
		$this->loadLayout();
		$this->renderLayout();
	}

	public function massPrintShippingLabelAction() {
		$shipmentIds = $this->getRequest()->getParam('shipment_ids', false);
		if($shipmentIds && is_array($shipmentIds)) {
			$shipments = Mage::getResourceModel('sales/order_shipment_collection')
			->addFieldToFilter('entity_id', array('in' => $shipmentIds));
			/* @var $shipment Mage_Sales_Model_Order_Shipment */
			foreach($shipments as $shipment) {
				/* @var $tracking EDN2_Shipping_Model_Tracking */
				$tracking = Mage::getModel('edn2shipping/tracking')->load($shipment->getOrderId(), 'order_id');
				if($tracking->getId()) {
					$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('<a href="%s" target="_blank">Download label %s</a>.', $tracking->getTrackingPdfUrl(), $shipment->getIncrementId()));
				} else {
					$this->_getSession()->addSuccess(Mage::helper('edn2shipping')->__('Order label %s not found.', $shipment->getIncrementId()));
				}
			}
		}
		$this->_redirect('*/*/index');
	}
}