<?php
class EDN2_Shipping_ApiController extends Mage_Core_Controller_Front_Action {
	
	public function getLabelAction() {
		//return; // Remove this to download pdf in a "easy way". exemple: http://www.example.com/fr/edn2shipping/api/getLabel/order_id/100345478
		$orderId = $this->getRequest()->getParam('order_id', false);
		
		if($orderId) {
			/* @var $salesOrder Mage_Sales_Model_Order */
			$salesOrder = Mage::getModel('sales/order')->loadByIncrementId($orderId);
			if(!$salesOrder->getId()) {
				echo htmlentities(Mage::helper('edn2shipping')->escapeHtml(Mage::helper('edn2shipping')->__('Order %s not found.', $orderId)));
				exit;
			}
		
			if(!$salesOrder->hasInvoices()) {
				echo htmlentities(Mage::helper('edn2shipping')->escapeHtml(Mage::helper('edn2shipping')->__('Order %s is not invoiced. Please Invoice this Order first.', $salesOrder->getIncrementId())));
				exit;
			}
		
			if($salesOrder->hasShipments()) {
				echo htmlentities(Mage::helper('edn2shipping')->escapeHtml(Mage::helper('edn2shipping')->__('Order %s is already shipped.', $salesOrder->getIncrementId())));
				exit;
			}
		
			if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_CLOSED) {
				echo htmlentities(Mage::helper('edn2shipping')->escapeHtml(Mage::helper('edn2shipping')->__('Order label %s can\'t be generated. This Order is fully refunded.', $salesOrder->getIncrementId())));
				exit;
			}
		
			if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_HOLDED) {
				echo htmlentities(Mage::helper('edn2shipping')->escapeHtml(Mage::helper('edn2shipping')->__('Order %s is Holded. The label is still generated.', $salesOrder->getIncrementId())));
				exit;
			}
		
			if($salesOrder->getState() == Mage_Sales_Model_Order::STATE_COMPLETE) {
				echo htmlentities(Mage::helper('edn2shipping')->escapeHtml(Mage::helper('edn2shipping')->__('Order label %s can\'t be generated. This Order is fully shipped.', $salesOrder->getIncrementId())));
				exit;
			}
		
		
			try {
				/* @var $tracking EDN2_Shipping_Model_Tracking */
				$tracking = Mage::getModel('edn2shipping/tracking')->load($orderId, 'order_id');
				$tracking->setOrder($salesOrder);
				if(!$tracking->getTrackingNumber() || !$tracking->getTrackingPdfUrl()) {
					$tracking->generateLabel(null);
					$tracking->save();
				}
				$this->_prepareDownloadResponse($salesOrder->getIncrementId() . ".pdf", Mage::helper('edn2core')->fileGetContents($tracking->getTrackingPdfUrl()));
			} catch(Exception $e) {
				echo Mage::helper('edn2shipping')->escapeHtml($e->getMessage());
				exit;
			}
		}
	}
}