<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
#require_once "Mage/Checkout/controllers/OnepageController.php";
require_once Mage::getModuleDir('controllers', 'Mage_Checkout') . DS . 'OnepageController.php';

class EDN2_Shipping_Checkout_OnepageController extends Mage_Checkout_OnepageController
{

    /**
     * Shipping method save action
     */
    public function saveShippingMethodAction()
    {
        if ($this->_expireAjax()) {
            return;
        }

        if (!$this->getRequest()->isPost())
            return;

        $shippingMethod = $this->getRequest()->getPost('shipping_method', '');

        $carrierInstance = Mage::helper('edn2shipping/carrier')->getCarrierInstanceByShippingMethod($shippingMethod);

        if ($carrierInstance && $carrierInstance->isRelay()) {
            $relay = $this->getRequest()->getPost('envoidunetrelayid', '');
            if (empty($relay)) {
                $result = array('error' => -1, 'message' => Mage::helper('edn2shipping')->__('Please choose a Relay.'));
                $this->getOnepage()->getQuote()->collectTotals()->save();
                $this->getResponse()->setBody(Mage::helper('core')->jsonEncode($result));
                return;
            } else {
                $this->getOnepage()->getQuote()->setEdn2Relayid($relay);
            }
        }
        parent::saveShippingMethodAction();
    }
}