<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
class EDN2_Shipping_RelayController extends Mage_Core_Controller_Front_Action  {
	
	public function viewAction() {
		$shipmentMethod = $this->getRequest()->getParam('carrier');
		$relayid = $this->getRequest()->getParam('relayid');
		$country = $this->getRequest()->getParam('country');
		
		if(!$shipmentMethod || !$relayid || !$country) {
			$this->norouteAction();
			return;
		}

		$carrierInstance = Mage::helper('edn2shipping/carrier')->getCarrierInstanceByShippingMethod($shipmentMethod);

		if(!$carrierInstance) {
			throw new Exception('Could not get carrier instance');
		}

		Mage::register('edn2shipping_relay', new Varien_Object(Mage::helper('edn2core/api')->getRelay($carrierInstance->getEdnCarrier(), $relayid, $country)));
		$this->loadLayout();
		$this->renderLayout();
	}
	
	public function configAction() {
	    $this->getResponse()->setHeader('Content-type', 'application/json', true);
	    $result = array();
	    /* @var $sessionSingleton Mage_Checkout_Model_Session */
	    $sessionSingleton = Mage::getSingleton('checkout/session');
	    if($sessionSingleton) {
	        $quoteModel = $sessionSingleton->getQuote();
	        if($quoteModel) {
	            $shippingAddressModel = $quoteModel->getShippingAddress();
	            if($shippingAddressModel) {
	                $result['geo'] = array (
	                   'street1' => $shippingAddressModel->getStreet1(),
	                   'street2' => $shippingAddressModel->getStreet1(),
	                   'postcode' => $shippingAddressModel->getPostcode(),
	                   'city' => $shippingAddressModel->getCity(),
	                   'country' => $shippingAddressModel->getCountryId()
	                );
	            }
	        }
	    }          
	    $this->getResponse()->setBody(Mage::helper('core')->jsonEncode($result));
	}
	
	public function searchAction() {
		$this->loadLayout();
		$this->getResponse()->setHeader('Content-type', 'application/json', true);
		$this->renderLayout();
	}
	
}