<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category EDN2
 * @package EDN2_Shipping
 * @copyright Copyright (c) 2014 Benjamin Denizart www.envoidunet.com
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 *
 */
$installer = $this;
/* @var $installer Mage_Core_Model_Resource_Setup */

$installer->startSetup ();

if ($installer->tableExists ( 'edn2shipping/tracking' )) {
	if ($installer->getConnection ()->tableColumnExists ( $installer->getTable ( 'edn2shipping/tracking' ), 'created_at' ))
		$installer->getConnection ()->changeColumn ( $installer->getTable ( 'edn2shipping/tracking' ), 'created_at', 'created_at', 'TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP COMMENT \'Created At\'' );

	if (! $installer->getConnection ()->tableColumnExists ( $installer->getTable ( 'edn2shipping/tracking' ), 'tracking_number' ))
		$installer->getConnection ()->changeColumn ( $installer->getTable ( 'edn2shipping/tracking' ), 'tracking', 'tracking_number', 'VARCHAR(100)' );

	if (! $installer->getConnection ()->tableColumnExists ( $installer->getTable ( 'edn2shipping/tracking' ), 'tracking_url' ))
		$installer->getConnection ()->addColumn ( $installer->getTable ( 'edn2shipping/tracking' ), 'tracking_url', 'TEXT NULL AFTER `tracking_number`' );

	if (! $installer->getConnection ()->tableColumnExists ( $installer->getTable ( 'edn2shipping/tracking' ), 'tracking_pdf_url' ))
		$installer->getConnection ()->addColumn ( $installer->getTable ( 'edn2shipping/tracking' ), 'tracking_pdf_url', 'TEXT NULL AFTER `tracking_url`' );

	if (! $installer->getConnection ()->tableColumnExists ( $installer->getTable ( 'edn2shipping/tracking' ), 'price' ))
		$installer->getConnection ()->addColumn ( $installer->getTable ( 'edn2shipping/tracking' ), 'price', 'DECIMAL(12,4) UNSIGNED NULL AFTER `tracking_pdf_url`' );

	if (! $installer->getConnection ()->tableColumnExists ( $installer->getTable ( 'edn2shipping/tracking' ), 'shipping_method' ))
		$installer->getConnection ()->addColumn ( $installer->getTable ( 'edn2shipping/tracking' ), 'shipping_method', 'VARCHAR(255) NULL AFTER `price`' );
}

$installer->endSetup ();