<?php 
/*////////////////////////////////////////////////////////////////////////////////
 \\\\\\\\\\\\\\\\\\\\\\\\\  FME Customerattribute extension  \\\\\\\\\\\\\\\\\\\\\\\\\
 /////////////////////////////////////////////////////////////////////////////////
 \\\\\\\\\\\\\\\\\\\\\\\\\ NOTICE OF LICENSE\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
 ///////                                                                   ///////
 \\\\\\\ This source file is subject to the Open Software License (OSL 3.0)\\\\\\\
 ///////   that is bundled with this package in the file LICENSE.txt.      ///////
 \\\\\\\   It is also available through the world-wide-web at this URL:    \\\\\\\
 ///////          http://opensource.org/licenses/osl-3.0.php               ///////
 \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
 ///////                      * @category   FME                            ///////
 \\\\\\\                      * @package    FME_Customerattribute              \\\\\\\
 ///////    * @author     Malik Tahir Mehmood <malik.tahir786@gmail.com>   ///////
 \\\\\\\                                                                   \\\\\\\
 /////////////////////////////////////////////////////////////////////////////////
 \\* @copyright  Copyright 2010  free-magentoextensions.com All right reserved\\\
 /////////////////////////////////////////////////////////////////////////////////
 */

class FME_Customerattribute_Model_Customerattribute extends Mage_Eav_Model_Entity_Attribute
{

    protected $_FM_EntityCode = 'fme_customerattribute';
    protected $_Customers = false;
    protected $_step = false;
    protected $_locate = false;
    protected $_section = false;
    protected $_admin = true;
    public function getFieldsList($addTable)
    {
	$collection = $this->getFieldsCollecton($this->_Customers);
	if($addTable=='catalog'){
	    $collection->getSelect()->order('add_table_data.position ASC');   
	}
	return $collection->getData();  
    }
    public function getFieldLoaded($fieldids)
    {
	$collection = $this->getFieldsCollecton($this->_Customers);
	if(is_array($fieldids)){
	    $collection->setCodeFilter($fieldids); 
	}else{
	    $collection->addFieldToFilter('attribute_code',$fieldids);
	}
	
	$collection->getSelect()->order('add_table_data.position ASC');   
	return $collection->getData();  
    }
    
    public function SaveFieldsdata($key,$value){//Mage::registry('fm_checkoutdata')
        if(!Mage::getSingleton('core/session')->getRegistry()){
	    Mage::getSingleton('core/session')->setRegistry('');
	}
	$data=Mage::getSingleton('core/session')->getRegistry();
	$data[$key]=$value;
	Mage::getSingleton('core/session')->setRegistry($data);
	return;
    }
    public function GetFMDb($id , $table ,$_Write){
	$allentries = $_Write->select()
            ->from(Mage::helper('customerattribute')->getFMTable($table), '*')
            ->where('entity_id=?', $id)
	    ->order('attribute_id','ASC');
        return $_Write->fetchAll($allentries);
    }
    public function GetFMData($orderid , $table , $for = false){
	if(!Mage::helper('customerattribute')->getStoredDatafor('enable')){
	    return false;
	}
        if(!$orderid or $orderid<=0){
	   return false;
	}
	$_Write = Mage::getSingleton('core/resource')->getConnection('core_read');
        $AllData = $this->GetFMDb($orderid , $table ,$_Write);
	
	$arrayvalues = array();
	if(count($AllData)!=0){
	    $info=array();
		$i=0;
		foreach($AllData as $data){
		    $arrayvalues = array();
		    $attribute=Mage::getResourceModel('eav/entity_attribute_collection')->addFieldToFilter('attribute_id',$data['attribute_id'])->getFirstItem();
		     $value = Zend_Json::decode($data['value']);
		    if(is_array($value)){
			$values=array();
			if($for==2){
			    foreach($value as $key => $onebyone){
				$values[] = implode(',',$onebyone);
				if(is_array($onebyone)){
				    foreach($onebyone as $key2 =>$val2){
					$arrayvalues[]=$key2;
				    }
				}else{
				    $arrayvalues[]=$key;
				}
			    }
			    if(is_array($values)){$value = implode(',',$values);}
			}else{
			    foreach($value as $key=>$val){
				if(is_array($val)){
				    foreach($val as $key2 =>$val2){
					$values[]=$key2;
				    }
				}else{
				    $values[]=$key;
				}
			    }
			    $value=$values;
			}
		    }
		    if($for == 1){
			//$attribute=Mage::getResourceModel('eav/entity_attribute_collection')->addFieldToFilter('attribute_id',$data['attribute_id'])->getFirstItem();
			if($attribute['fme_email'] == true){
			     $info[$attribute['attribute_code']]=$value;
			}
		    }elseif($for == 2){
			//$attribute=Mage::getResourceModel('eav/entity_attribute_collection')->addFieldToFilter('attribute_id',$data['attribute_id'])->getFirstItem();
			if($attribute['frontend_input'] == 'file'){
			    if($value){
				$fileDetails = pathinfo($value);
				$value = '<a href="'.Mage::getBaseUrl('media') . 'customerattribute/' . $value .'">' .$fileDetails['filename'].'</a>';
			    }elseif($attribute['default_value']!=''){
				$value = '<a href="'.$attribute['default_value'].'">' .$fileDetails['filename'].'</a>';
				//$value = $attribute['default_value'];
			    }
			    
			}elseif($attribute['frontend_input'] == 'image'){
			    
			    if($value){
				
				$value = '<img src="'.Mage::getBaseUrl('media') . 'customerattribute/' . $value.'" width="50" height="50"  />';
			    }elseif($attribute['default_value']!=''){
				$value = '<img src="'.$attribute['default_value'].'" width="50" height="50"  />';
			    }
			    
			}
			//$value = $value!=''?$value:$attribute['default_value'];
			$info[$attribute['attribute_code']]=$value;
			
		    }
		    else{
			$info[$i]['code']=$attribute['attribute_code'];
			$info[$i]['label']=$this->getFieldStoreLabel($attribute);
			$info[$i]['value']=$value;
			if($arrayvalues){
			    $info[$i]['keys']= $arrayvalues;
			}else{
			    $info[$i]['keys']= '';
			}
			$i++;
		    }
		}
	    return $info;
	}
    }
    public function getCustomer(){
	$session = Mage::getSingleton('customer/session');
	if($session->isLoggedIn()) {
	   return $session->getCustomer();
	}
	if($backendcustomer = Mage::registry('current_customer')){
	    return $backendcustomer;
	}
	return 0;
    }
    public function SaveINDb($Entervalue,$id,$table,$attributeInfo,$_Write){
	$Exists = array();unset($Exists);
	$tables   = Mage::helper('customerattribute')->getFMTable($table);
	$allentries = $_Write->select()
	    ->from($tables, '*')
	    ->where('entity_id=?', $id)
	    ->where('attribute_id=?', $attributeInfo);
	    //->order('attribute_id','ASC');
	    $Exists = $_Write->fetchRow($allentries);
	if(!empty($Exists) && !empty($Exists['customerattribute_id']) && $Exists['value']!=$Entervalue){
	    $_Write->update( $tables,
		array("value" => $Entervalue),
		array("customerattribute_id =?" => $Exists['customerattribute_id'])
	    );
	}elseif(empty($Exists)) {
	    $_Write->insert( $tables ,
	    array(
		"entity_id"	=> $id,
		"attribute_id" 	=> $attributeInfo,
		"value" 	=> $Entervalue,
	    ));
	}
	return;
    }

    public function AdminCustomerBeforeSaveToFM($event){ 
	$customer = $event->getEvent();
	$post = Mage::app()->getRequest()->getPost();
	$translate = Mage::getSingleton('core/translate');
	
	$mode = isset($post["fme_register"])?'fme_register':'fme_account';
	if(isset($_FILES)) {
            $fieldIds =  array();
            foreach($_FILES as $field => $value){
                if(substr($field,0,3)=='fm_'){
                    $fieldIds[]=substr($field,3);
                }
                
            }
            $fieldsdata = $this->getFieldLoaded($fieldIds);
            foreach($fieldIds as $key => $fieldId){
                try {
                    $fielddata = $fieldsdata[$key];
                    $org_name = 'fm_'. $fieldId;
                    if($_FILES[$org_name]['name'] ==''){
                        continue;
                    }
		    
                    if($_FILES[$org_name]['name'] && $fielddata['fme_size']>0 && $fielddata['fme_size']!='' && ($_FILES[$org_name]['size'] / 1024 / 1024) > $fielddata['fme_size']){
                        Mage::getSingleton('core/session')->addError(Mage::helper('customerattribute')->__('Size of the uploaded file for  "' . $fielddata['frontend_label'] . '" is greater than allowed.'));
                        throw new Exception();
                    }
                    $ext = array();
                    $extensions = array();
                    $ext = explode(",",$fielddata['fme_ext']);
                    foreach($ext as $exten)
                    {
                        $exten=trim($exten);
                        $extensions[]=$exten;
                    }
                    /* Starting upload */        
                    $uploader = new Varien_File_Uploader($org_name);
                    
                    // Any extention would work
                    $uploader->setAllowedExtensions($extensions);
                    if(!$uploader->checkAllowedExtension($uploader->getFileExtension())){
                        Mage::getSingleton('core/session')->addError(Mage::helper('customerattribute')->__('The file type of the uploaded file for  "' . $fielddata['frontend_label'] . '" is not allowed.'));
                        throw new Exception();
                    }
                    $uploader->setAllowRenameFiles(true);
                    $uploader->setFilesDispersion(true);
                    $path = Mage::getBaseDir('media'). '/customerattribute/';
                    $uploader->save($path);
                    $post[$mode][$org_name] = $uploader->getUploadedFileName();
                }
                catch (Exception $e) {
                    $translate->setTranslateInline(true);
                    Mage::getSingleton('core/session')->addError(Mage::helper('customerattribute')->__('Unable to upload "' . $fielddata['frontend_label'] . '" Please try again later.'));
                    //throw new Exception();
                }
            }
        }
        
        if(isset($post[$mode]) && count($post[$mode])){
            $dataToSave= array();
            foreach($post[$mode] as $key=>$postdata){
                if(substr($key,0,3)=='fm_'){
                    $dataToSave[substr($key,3)]=$postdata;
                }
            }
            $this->SaveToFM('customer',0,'customers',$customer->getCustomer()->getEntityId(),$dataToSave);
        }
	return;
    }

    public function SaveToFM($mode,$id,$table,$customerId,$data =  array()){
	if(!Mage::helper('customerattribute')->getStoredDatafor('enable')){
	    return;
	}
	if(!count($data)){
	    if(!Mage::getSingleton($mode.'/session')->getRegistry()){
		return;
	    }
	    $data=Mage::getSingleton($mode.'/session')->getRegistry();
	}
	if($customerId == 0 && $this->getCustomer()){
	    $customerId = $this->getCustomer()->getId();
	}
	$_Write = Mage::getSingleton('core/resource')->getConnection('core_write');
	
	foreach($data as $key=>$value){
	    if(!$key){continue;}
	    $Entervalue=null;unset($Entervalue);
	    $attributeInfo = Mage::getResourceModel('eav/entity_attribute_collection')
                        ->setCodeFilter($key)
			->addFieldToFilter('entity_type_id',$this->getEntityTypeId())
                        ->getFirstItem();
	    $Entervalue= $this->getCurrentValue($key ,$attributeInfo,true,$data);
	    $Entervalue=Zend_Json::encode($Entervalue);
	    if($mode == 'customer' && $customerId > 0){
		$this->SaveINDb($Entervalue,$customerId,'customers',$attributeInfo->getAttributeId() ,$_Write);
	    }
	    else{
		if($attributeInfo->getFmeCustomerAccount()>0 && $customerId > 0){
		    $this->SaveINDb($Entervalue,$customerId,'customers',$attributeInfo->getAttributeId() ,$_Write);
		}
		if(!empty($Entervalue) && $mode = 'core'){
		    $this->SaveINDb($Entervalue,$id,$table,$attributeInfo->getAttributeId() ,$_Write);
		}
	    }
	}
	return;
    }
    public function getSelectedOptionsLabels($attribute,$values,$alldetails){
	$Entervalue=null;unset($Entervalue);
	foreach($attribute->getSource()->getAllOptions(false) as $option){
	    if(in_array($option['value'],$values)){
		if($alldetails){
		    $Entervalue[$attribute->getAttributeCode()][$option['value']]=$option['label'];
		}else{
		    $Entervalue[$option['value']]=$option['label'];
		}
	    }
	}
	return $Entervalue;
    }
    public function getSelectedOptionsLabelsOnly($options,$values){
	$Entervalue=null;unset($Entervalue);
	foreach($options as $option){
	    if(in_array($option['value'],$values)){
		$Entervalue[$option['value']]=$option['label'];
	    }
	}
	return $Entervalue;
    }
    
    public function getCurrentValue($key ,$attributeInfo = null, $alldetails = false,$data = array()){
	if(!count($data)){
	    $data = Mage::getSingleton('core/session')->getRegistry();
	}
	
	if(count($data) && isset($data[$key])){
	    $Entervalue=null;unset($Entervalue);
	    $value = $data[$key];
	    if($attributeInfo == null){
		$attributeInfo = Mage::getResourceModel('eav/entity_attribute_collection')
			->setCodeFilter($key)
			->addFieldToFilter('entity_type_id',$this->getEntityTypeId())
			->getFirstItem();
	    }
	    
	    
	    if(in_array($attributeInfo->getFrontendInput(), array('select', 'multiselect','checkbox','radio')))
	    {
		if($attributeInfo->getFrontendInput()=='multiselect'){
		    if(count($value)==1){
			$values=array();
			$values=explode(',',$value[0]);
			$value=$values;
		    }
		}
		elseif(!is_array($value)){
		    $values=array();
		    $values=explode(',',$value);
		    $value=$values;
		}
		$Entervalue = $this->getSelectedOptionsLabels($attributeInfo,$value,$alldetails);
	    }
	    elseif($attributeInfo->getFrontendInput()=='boolean')
	    {
		if($value==0){
		    $Entervalue = Mage::helper('catalog')->__('No');
		}else{
		    $Entervalue = Mage::helper('catalog')->__('Yes');
		}
	    }
	    else
	    {
		$Entervalue = strip_tags($value);
	    }
	    return $Entervalue;
	}
    }
    
    public function getFieldsCollecton($fromcustomers = false){
        if(!Mage::helper('customerattribute')->getStoredDatafor('enable')){
	    return false;
	}
        $collection = Mage::getResourceModel('eav/entity_attribute_collection')
            ->setEntityTypeFilter($this->getEntityTypeId());
	
        $collection->getSelect()->join(
            array('add_table_data' =>Mage::helper('customerattribute')->getTable('catalog')),
            'add_table_data.attribute_id=main_table.attribute_id'
        );
	$collection->getSelect()->where('add_table_data.is_global =1');
	$CurrentStoreId = Mage::app()->getStore()->getId();
	 $collection->getSelect()->join(
            array('store_table' =>Mage::helper('customerattribute')->getFMTable('store')),
            'store_table.attribute_id=main_table.attribute_id'
        );
	
	if(!Mage::getSingleton('adminhtml/session')->getIsAdmin() || Mage::getSingleton('adminhtml/session')->getIsAdmin()!=true){
	     $this->_admin = false;
	    $collection->getSelect()->where('store_table.store_id ="'. $CurrentStoreId . '" || store_table.store_id ="0"');
	}
	if($this->_section == 'fme_register'){
	    $collection->getSelect()->where('main_table.fme_customer_account =2 || main_table.fme_customer_account =3');
	    return $collection;
	}
	
	if($fromcustomers != false && $this->_admin == false){
		$collection->getSelect()->where('main_table.fme_customer_account ='. $fromcustomers . ' || main_table.fme_customer_account =3');
	}else if($fromcustomers != false && $this->_admin == true){
	     $collection->getSelect()->where('main_table.fme_customer_account =1 || main_table.fme_customer_account =2 ||main_table.fme_customer_account =3');
	    
	}
	$collection->getSelect()->join(
            array('customer_group' =>Mage::helper('customerattribute')->getFMTable('customer_group')),
            'customer_group.attribute_id=main_table.attribute_id'
        );
	
	$GroupId = 0;
	if($this->getCustomer()){
	   $GroupId = $this->getCustomer()->getGroupId();
	}
	if(Mage::getSingleton('adminhtml/session')->getIsNew() && Mage::getSingleton('adminhtml/session')->getIsNew() == true){
	    $GroupId = 0;
	}
	$collection->AddFieldToFilter('customer_group.group_id',$GroupId);
        return $collection;
    }
    
    public function getEntityTypeId(){
	return Mage::getModel('eav/entity')
            ->setType($this->_FM_EntityCode)->getTypeId();
    }
    public function getFieldLabel($NewFieldId)
    {
        if (!$NewFieldId){ return false;}
	$NewFieldData  = Mage::getModel('eav/entity_attribute')->load($NewFieldId);
	return $this->getFieldStoreLabel($NewFieldData);
    }
    public function getFieldStoreLabel($NewFieldData)
    {
	if (!$NewFieldData->getData()) return false;
	$CurrentStoreId = Mage::app()->getStore()->getId();
	$AllStoreLabels=array();
	$AllStoreLabels = $NewFieldData->getStoreLabels();
	if(!empty($AllStoreLabels) AND isset($AllStoreLabels[$CurrentStoreId]) AND $AllStoreLabels[$CurrentStoreId])
	{
	    return $AllStoreLabels[$CurrentStoreId];
	}
	return $NewFieldData->getFrontend()->getLabel();
    }
    public function getAllFieldsHtml($section, $addTable , $CS ,$CE)
    {	if(!Mage::helper('customerattribute')->getStoredDatafor('enable')){
	    return false;
	}
	$this->_section = $section;
	
	$html="";
	$list = $this->getFieldsList($addTable);
	
	if(!empty($list) || count($list)>0){
	   $i=0;
	    foreach($list as $NewFieldData){
		$inputfield = $this->getFieldHtml($NewFieldData , $section);
		if($inputfield!=''){
		    if($i++%2==0){
		    $html .= $CS . ' id="fme_customer_' .$i. '">';}
		    $class = 'field';
		    $html .='<div class="'. $class .'"><label for="fm_'.$NewFieldData['attribute_code'] . '"';
		    if($NewFieldData['is_required']){ $html .=" class='required'>";}else{ $html .=">";}
		    $html .=$this->getFieldLabel($NewFieldData['attribute_id']) . '</label>';
		    if($NewFieldData['is_required']){ $html .="<span class='required'>*</span>";}
		    $html .='<div class="input-box">'.$inputfield  .'</div>';
		    $html .='</div>';
		    if($i%2==0 || $i== count($list)){ $html .= $CE;}
		}
	    }
	}
	return $html; 
    }
    public function getOptionslist($NewFieldId)
    {
	$Options = Mage::getResourceModel('eav/entity_attribute_option_collection')
	     ->setAttributeFilter($NewFieldId)
	     ->setStoreFilter(Mage::app()->getStore()->getId());
	$Options->getSelect()->order('sort_order ASC');
	$Options->getSelect()->assemble();
	$Options->getData();
	return($Options->toOptionArray());
    }
    public function getSavedFieldData($id,$Field,$from)
    {
	if(!Mage::helper('customerattribute')->getStoredDatafor('enable')){
	    return;
	}
	if($id){
	    $SavedData= $this->GetFMData($id , $from , false);
	    if($SavedData){
		foreach($SavedData as $saved){
		    if($saved['code']==$Field){
			return $saved['value'];
			break;
		    }
		}
	    }
	}
	return;
    }
    public function getFieldHtml($NewFieldData , $section)
    {
	if(!Mage::helper('customerattribute')->getStoredDatafor('enable')){
	    return false;
	}
	$html='';
	$BackEndValue = '';
        $StoreId = Mage::app()->getStore()->getId();
	$NewFieldId='fm_'.$NewFieldData['attribute_code'];
        $TextFields = new Zend_View();
	$Label = $this->getFieldLabel($NewFieldData['attribute_id']);
        $class=$NewFieldData['frontend_class'];
        $NewFieldName = $section . '[fm_' . $NewFieldData['attribute_code'] . ']';
	$SimpleFieldName = 'fm_' . $NewFieldData['attribute_code'];
	
	$customerId = 0;
	if($this->getCustomer()){
	    $customerId=$this->getCustomer()->getId();
	}
	$BackEndValue = $this->getSavedFieldData($customerId,$NewFieldData['attribute_code'],'customers');
	$iscustomerdata = $BackEndValue!='';
	$iseditable = 0;
	if($this->_admin || $NewFieldData["is_user_defined"] == 4 ||($NewFieldData["is_user_defined"] == 2 && $BackEndValue=='' && $NewFieldData['default_value']=='') || ($NewFieldData["is_user_defined"] == 1 && $NewFieldData['default_value'] !='') || ($NewFieldData["is_user_defined"] == 3 && $BackEndValue=='')){
	    $iseditable = 1;
	}
	$ishidden = $BackEndValue!='' && $NewFieldData["is_searchable"]==1 && !$this->_admin;
	if(!$ishidden){
	    $BackEndValue = $BackEndValue!=''? $BackEndValue:$NewFieldData['default_value'];
	    if ($NewFieldData['is_required'])
	    {
		if(in_array($NewFieldData['frontend_input'], array('text', 'textarea', 'date', 'file', 'image')))
		    { $class .= ' required-entry';}
		elseif(in_array($NewFieldData['frontend_input'], array('select', 'multiselect','boolean')))
		    { $class .= ' validate-select'; }
		else{$class .= ' validate-one-required-by-name';}
	    }
	    $TextInputExtra = array
	    (
		'id' => $NewFieldId,
		'class' => $class,
		'title' => $Label,
	    );
	    $OptionsList=array();
	    
	    $filespath = $iscustomerdata==1?Mage::getBaseUrl('media') . 'customerattribute/':'';
	    switch ($NewFieldData['frontend_input'])
	    {
		case 'text':
		    $TextInputExtra['class'] .= ' input-text';
		    if($iseditable){
			$html .= $TextFields->formText($NewFieldName, $BackEndValue, $TextInputExtra);
		    }else{
			$html .= $BackEndValue;
		    }
		    
		break;    
		case 'textarea':
		    $TextInputExtra['class'] .= ' input-text';
		    $TextInputExtra['style'] = 'height:50px;';
		    if($iseditable){
			$html .= $TextFields->formTextarea($NewFieldName, $BackEndValue, $TextInputExtra);
		    }else{
			$html .= $BackEndValue;
		    }
		    
		break;    
		case 'select':
		    $OptionsList = $this->getOptionslist($NewFieldData['attribute_id']);
		    $OptionsList1=array();
		    if($NewFieldData['is_used_for_price_rules']==1){
			$OptionsList1[-1]=array('value'=>'','label'=>' ');
			$OptionsList = array_merge($OptionsList1, $OptionsList);
		    }
			
			
		    if($iseditable){ 
			
			$select = Mage::getModel('core/layout')->createBlock('adminhtml/html_select')
			->setData(array(
			    'id'    => $NewFieldId,
			    'class' => $class,
			    'value' => $BackEndValue
			))
			->setName($NewFieldName)
			->setOptions($OptionsList);
			$html .= $select->getHtml();
		    }else{ //$OptionsList = $this->getOptionslist($NewFieldData['attribute_id']);
			$selectedvalues = $this->getSelectedOptionsLabelsOnly($OptionsList,$BackEndValue);
			$html .= implode("<br>",$selectedvalues);
		    }
		break;    
		case 'multiselect':
		    if(!is_array($BackEndValue)){$BackEndValue = explode(',',$BackEndValue);}
		  
			$OptionsList = $this->getOptionslist($NewFieldData['attribute_id']);
		    if($iseditable){
			
			$select = Mage::getModel('core/layout')->createBlock('adminhtml/html_select')
		       ->setData(array(
			   'id'    => $NewFieldId,
			   'class' => $class,
			   'value'=>$BackEndValue
		       ))
		       ->setExtraParams('multiple')
		       ->setName($NewFieldName . '[]')
		       ->setOptions($OptionsList);
			   $html .=  $select->getHtml();
		    }else{
			$selectedvalues = $this->getSelectedOptionsLabelsOnly($OptionsList,$BackEndValue);//print_r($OptionsList);print_r($BackEndValue);exit;
			$html .= implode("<br>",$selectedvalues);
		    }
		break;    
		case 'checkbox':
		    $OptionsList = $this->getOptionslist($NewFieldData['attribute_id']);
		    if(!is_array($BackEndValue))$BackEndValue = explode(',',$BackEndValue);
		    if ($OptionsList && $iseditable){
			$newOPtions =array();
			foreach ($OptionsList as $option) {
			    $newOPtions[$option['value']]=$option['label'];
			}
			$class .= ' checkbox';
			
			$attribs = array(
			    'id' => $NewFieldId,
			    'class' => $class,
			    'title' => $Label,
			);
			$html .= $TextFields->formMultiCheckbox($NewFieldName, $BackEndValue, $attribs, $newOPtions, "<br />\n");
		    }else{
			
			$selectedvalues = $this->getSelectedOptionsLabelsOnly($OptionsList,$BackEndValue);
			$html .= implode('<br>',$selectedvalues);
		    }
		break;    
		case 'radio':
		    $OptionsList = $this->getOptionslist($NewFieldData['attribute_id']);
		    if(!is_array($BackEndValue))$BackEndValue = explode(',',$BackEndValue);
		   
		    if ($OptionsList && $iseditable){
		    
			$OptionsList1=array();
			if(!$NewFieldData['is_required']) {
			    $OptionsList1[-1]=array('value'=>'','label'=>Mage::helper('catalog')->__('None'));
			}
			$OptionsList = array_merge($OptionsList1, $OptionsList);
			$newOPtions =array();
			foreach ($OptionsList as $option) {
			    $newOPtions[$option['value']]=$option['label'];
			}
			$class .= ' radio';
			
			$attribs = array(
			    'id' 	=> $NewFieldId,
			    'class' 	=> $class,
			    'title' 	=> $Label
			);
			$html .=$TextFields->formRadio($NewFieldName, $BackEndValue, $attribs, $newOPtions);
		    }else{
			
			$selectedvalues = $this->getSelectedOptionsLabelsOnly($OptionsList,$BackEndValue);
			$html .= implode('<br>',$selectedvalues);
		    }
		    break;    
		case 'boolean':
		    if($BackEndValue=='No'){$BackEndValue='0';}elseif($BackEndValue=='Yes'){$BackEndValue='1';}
		    if(!is_array($BackEndValue))$BackEndValue = explode(',',$BackEndValue);
		    $bool = array(
			    array(
				'value' => 0,
				'label' => Mage::helper('catalog')->__('No')
			    ),
			    array(
				'value' => 1,
				'label' => Mage::helper('catalog')->__('Yes')
			    )
		    );
		    if ($iseditable){
			$bool_html = Mage::getModel('core/layout')->createBlock('adminhtml/html_select')
			->setData(array(
			    'id'    => $NewFieldId,
			    'class' => $class,
			    'value'=>$BackEndValue
			))
			->setName($NewFieldName)
			->setOptions($bool);
			$html .= $bool_html->getHtml();
		    }else{
			
			$selectedvalues = $this->getSelectedOptionsLabelsOnly($bool,$BackEndValue);
			$html .= implode('<br>',$selectedvalues);
		    }
		break;    
		case 'date':
		    if ($iseditable){
			$dateFormat = Mage::app()->getLocale()->getDateFormat(Mage_Core_Model_Locale::FORMAT_TYPE_SHORT);
			 $date = Mage::getModel('core/layout')->createBlock('adminhtml/html_date')
			->setData(array(
			    'id'    => $NewFieldId,
			    'class' => $class,
			    'title'=>$NewFieldName,
			    'format'=>$dateFormat,
			    'image'=>Mage::getDesign()->getSkinUrl('images/grid-cal.gif')
			))
			->setValue($BackEndValue, $dateFormat)
			->setName($NewFieldName);
			$html .= $date->getHtml();
		    }else{
			$html .= $BackEndValue;
		    }
		break;
	    case 'message':
		    $html .= '<label>'.$BackEndValue.'</label>';
		break;
	    case 'file':
		
		if($iscustomerdata){
		    $class = '';
		}
		$html .= $BackEndValue != ''? '<a href="'. Mage::getUrl('customerattribute/customer/download',array('_secure'=>true,'filefor'=>$SimpleFieldName)).'"  id="file_'.$NewFieldId.'" title="'.$Label.'" >'.$Label.'</a>':'';
		if($iseditable){
		    $html .= '<input type="file" name="'.$SimpleFieldName.'" class="'.$class.'" id="'.$NewFieldId.'" title="'.$Label.'" >';
		}
		    
		break;
	    case 'image':
		if($iscustomerdata){
		    $class = '';
		}
		$html .= $BackEndValue != ''? '<img src="'.$filespath . $BackEndValue.'" width="'.$NewFieldData["is_configurable"].'" height="'.$NewFieldData["is_filterable_in_search"].'"  id="img_'.$NewFieldId.'" title="'.$Label.'" />':'';
		if($iseditable){
		    $html .= '<input type="file" name="'.$SimpleFieldName.'" class="'.$class.'" id="'.$NewFieldId.'" title="'.$Label.'" >';
		}
		break;
	    }
	}
        return $html;        
    }
    public function saveEAVData($model, $DefaultOptionsValue , $data){
	$CatalogProduct = Mage::getModel('eav/entity')->setType('catalog_product')->getTypeId();  
	$model->setEntityTypeId($CatalogProduct);
	$model->setEntityType($this->_FM_EntityCode);	
	$model->save();
	$EntityAttribute = Mage::getModel('catalog/entity_attribute');
	$EntityAttribute->load($model->getId());
	$EntityAttribute->setDefaultValue($DefaultOptionsValue);
	$EntityAttribute->setEntityTypeId($this->getEntityTypeId());
	$EntityAttribute->save();
	
	$this->updaterelatedtables($model->getId(), $data);
	return;
    }
    public function getAfterLoad($data,$id){
	$read = Mage::getSingleton('core/resource')->getConnection('core_read');
	$select =$read->select()
            ->from(Mage::helper('customerattribute')->getFMTable('store'))
            ->where('attribute_id = ?', $id);
        if ($datas = $read->fetchAll($select)) {
            $locationArray = array();
            foreach ($datas as $row) {
                $locationArray[] = $row['store_id'];
            }
          $data['store_ids']=$locationArray;
        }
	$select = $read->select()
            ->from(Mage::helper('customerattribute')->getFMTable('customer_group'))
            ->where('attribute_id = ?', $id);
        if ($datas = $read->fetchAll($select)) {
            $locationArray = array();
            foreach ($datas as $row) {
                $locationArray[] = $row['group_id'];
            }
          $data['custmoer_group']=$locationArray;
        }
	return $data;
    }
    
     public function updaterelatedtables($atr_Id,$data)
    {
	$write = Mage::getSingleton('core/resource')->getConnection('core_write');
	$read = Mage::getSingleton('core/resource')->getConnection('core_read');
	$condition = $write->quoteInto('attribute_id = ?', $atr_Id);
	if(isset($data['store_ids']) && count($data['store_ids'])!=0){
	    $write->delete(Mage::helper('customerattribute')->getFMTable('store'), $condition);
	    foreach ($data['store_ids'] as $store) {
		$storeArray = array();
		$storeArray['attribute_id'] = $atr_Id;
		$storeArray['store_id'] = $store;
		$write->insert(Mage::helper('customerattribute')->getFMTable('store'), $storeArray);
	    }
	}
	if(isset($data['custmoer_group']) && count($data['custmoer_group'])!=0){
	    $write->delete(Mage::helper('customerattribute')->getFMTable('customer_group'), $condition);
	    foreach ($data['custmoer_group'] as $store) {
		$storeArray = array();
		$storeArray['attribute_id'] = $atr_Id;
		$storeArray['group_id'] = $store;
		$write->insert(Mage::helper('customerattribute')->getFMTable('customer_group'), $storeArray);
	    }
	}
	
    }
    public function getGridFields()
    {
	$collection = $this->getFieldsCollecton($this->_Customers);
	$collection->addFieldToFilter('add_table_data.is_visible_in_advanced_search',1);
	$collection->getSelect()->order('add_table_data.position ASC');   
	return $collection->getData();  
    }
    public function appendCustomerattributeColumns(Varien_Event_Observer $observer)
    {
	if(!Mage::helper('customerattribute')->getStoredDatafor('enable')){
	    return;
	}
	
        $block = $observer->getBlock();
        if (!isset($block)) {
            return $this;
        }
	//$pos = strpos($block->getType(),'grid');
	if($block->getType() == 'adminhtml/widget_grid_massaction_item_additional_default'){
	    //echo $block->getType() . "   ";
	    
	     echo $block->getButtonHtml(Mage::helper('customerattribute')->__('Force Refresh'), 'setLocation(\'' . $block->getUrl('customerattributeadmin/fields/refresh',array('_use_rewrite'=>true)) .'\')', 'add', 'forceId');
	   // echo $block->toHtml();
	  // exit;
	}
	
	if($block instanceof Mage_Adminhtml_Block_Customer_Grid){
	    $collection = $this->getGridFields();
	  
	    if(is_array($collection) and count($collection)){
		$code='billing_region';
		foreach($collection as $fieldData){
		    
		    $block->addColumnAfter(
		    $fieldData['attribute_code'],
		    array(
			'header' => $fieldData['frontend_label'],
			'index' => $fieldData['attribute_code'],
			'align' => 'center',
			'filter' => false,
			'renderer'   => 'customerattribute/customer_edit_detail',
			'sortable' => false,
		    )
		    , $code);
		    $code = $fieldData['attribute_code'];
		}
		$block->addColumnAfter(
		    'refresh_this',
		    array(
			'header' => 'Refresh This',
			'index' => 'refresh_this',
			'align' => 'center',
			'filter' => false,
			'renderer'   => 'customerattribute/customer_edit_detail',
			'sortable' => false,
		    )
		    , 'action');
		
	    }
        }
    }
} 