<?php
/*////////////////////////////////////////////////////////////////////////////////
 \\\\\\\\\\\\\\\\\\\\\\\\\  FME Customerattribute extension  \\\\\\\\\\\\\\\\\\\\\\\\\
 /////////////////////////////////////////////////////////////////////////////////
 \\\\\\\\\\\\\\\\\\\\\\\\\ NOTICE OF LICENSE\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
 ///////                                                                   ///////
 \\\\\\\ This source file is subject to the Open Software License (OSL 3.0)\\\\\\\
 ///////   that is bundled with this package in the file LICENSE.txt.      ///////
 \\\\\\\   It is also available through the world-wide-web at this URL:    \\\\\\\
 ///////          http://opensource.org/licenses/osl-3.0.php               ///////
 \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
 ///////                      * @category   FME                            ///////
 \\\\\\\                      * @package    FME_Customerattribute              \\\\\\\
 ///////    * @author     Malik Tahir Mehmood <malik.tahir786@gmail.com>   ///////
 \\\\\\\                                                                   \\\\\\\
 /////////////////////////////////////////////////////////////////////////////////
 \\* @copyright  Copyright 2010  free-magentoextensions.com All right reserved\\\
 /////////////////////////////////////////////////////////////////////////////////
 */

 
class FME_Customerattribute_Model_Type
{
    public function toOptionArray()
    {
        return array(
            array('value' => 'text','label' => Mage::helper('customerattribute')->__('Text Field')),
            array('value' => 'textarea','label' => Mage::helper('customerattribute')->__('Text Area')),
            array('value' => 'date','label' => Mage::helper('customerattribute')->__('Date')),
            array('value' => 'boolean','label' => Mage::helper('customerattribute')->__('Yes/No')),
            array('value' => 'multiselect','label' => Mage::helper('customerattribute')->__('Multiple Select')),
            array('value' => 'select','label' => Mage::helper('customerattribute')->__('Dropdown')),
            array('value' => 'checkbox','label' => Mage::helper('customerattribute')->__('Checkbox')),
            array('value' => 'radio','label' => Mage::helper('customerattribute')->__('Radiobutton')),
            array('value' => 'file','label' => Mage::helper('customerattribute')->__('File')),
            array('value' => 'image','label' => Mage::helper('customerattribute')->__('Image')),
            array('value' => 'message','label' => Mage::helper('customerattribute')->__('Message Display Only'))
        );
    }
    public function toOptionsArray()
    {
        return array(
                    'text' => Mage::helper('customerattribute')->__('Text Field'),
                    'textarea' => Mage::helper('customerattribute')->__('Text Area'),
                    'date'=> Mage::helper('customerattribute')->__('Date'),
                    'boolean'=> Mage::helper('customerattribute')->__('Yes/No'),
                    'multiselect'=> Mage::helper('customerattribute')->__('Multiple Select'),
                    'select'=> Mage::helper('customerattribute')->__('Dropdown'),
                    'checkbox'=> Mage::helper('customerattribute')->__('Checkbox'),
                    'radio'=> Mage::helper('customerattribute')->__('Radiobutton'),
                    'file'=> Mage::helper('customerattribute')->__('File'),
                    'image'=> Mage::helper('customerattribute')->__('Image'),
                    'message'=> Mage::helper('customerattribute')->__('Message Display Only')
        );
    }
   
    public function toValidateArray()
    {
        return array(
                array('value' => '','label' => Mage::helper('customerattribute')->__('None')),
                array('value' => 'validate-number','label' => Mage::helper('customerattribute')->__('Decimal Number')),
                array('value' => 'validate-digits','label' => Mage::helper('customerattribute')->__('Integer Number')),
                array('value' => 'validate-email','label' => Mage::helper('customerattribute')->__('Email Address')),
                array('value' => 'validate-url','label' => Mage::helper('customerattribute')->__('Website Url Address')),
                array('value' => 'validate-alpha','label' => Mage::helper('customerattribute')->__('Letters Only')),
                array('value' => 'validate-alphanum','label' => Mage::helper('customerattribute')->__('Letters and/or Numbers')),
                array('value' => 'validate-date','label' => Mage::helper('customerattribute')->__('Date'))
            );
    }
    
    public function toPositionArray()
    {
        return array(
                array('value' => 1,'label' => Mage::helper('customerattribute')->__('At the Top Of the Step')),
                array('value' => 2,'label' => Mage::helper('customerattribute')->__('At the Middle of Step')),
                array('value' => 3,'label' => Mage::helper('customerattribute')->__('At the Bottom of Step'))
            );
    }
     
    public function toPositionOptionsArray()
    {
        return array(
               1 => Mage::helper('customerattribute')->__('At the Top Of the Step'),
               2 => Mage::helper('customerattribute')->__('At the Middle of Step'),
               3 => Mage::helper('customerattribute')->__('At the Bottom of Step')
            );
    }
    
     public function toPlacementArray()
    {
        return array
                (
                    array('value' => 2,'label' => Mage::helper('customerattribute')->__(' Billing')),
                    array('value' => 3,'label' => Mage::helper('customerattribute')->__(' Shipping')),
                    array('value' => 4,'label' => Mage::helper('customerattribute')->__(' Shipping Method')),
                    array('value' => 5,'label' => Mage::helper('customerattribute')->__(' Payment')),
                    array('value' => 6,'label' => Mage::helper('customerattribute')->__(' Order Review')),
                );
    }
    
    public function toPlacementOptionsArray()
    {
        return array
                (
                    2=> Mage::helper('customerattribute')->__(' Billing'),
                    3=> Mage::helper('customerattribute')->__(' Shipping'),
                    4=> Mage::helper('customerattribute')->__(' Shipping Method'),
                    5=> Mage::helper('customerattribute')->__(' Payment'),
                    6=> Mage::helper('customerattribute')->__(' Order Review'),
                );
    }
    public function toCustomerArray()
    {
        return array
                (
                    
                    array('value' => 1,'label' => Mage::helper('customerattribute')->__(' Account Page')),
                    array('value' => 2,'label' => Mage::helper('customerattribute')->__(' Registeration Page')),
                    array('value' => 3,'label' => Mage::helper('customerattribute')->__(' Registeration Page and Account Page'))
                );
    }
    
    public function toCustomerOptionsArray()
    {
        return array
                (
                    1=> Mage::helper('customerattribute')->__(' Account Page'),
                    2=> Mage::helper('customerattribute')->__(' Registeration Page'),
                    3=> Mage::helper('customerattribute')->__(' Registeration Page and Account Page')
                );
    }
    
    public function toPdfArray()
    {
        return array
                (
                    array('value' => 0,'label' => Mage::helper('customerattribute')->__(' No ')),
                    array('value' => 1,'label' => Mage::helper('customerattribute')->__(' Invoice Pdf')),
                    array('value' => 2,'label' => Mage::helper('customerattribute')->__(' Shipping Pdf')),
                    array('value' => 3,'label' => Mage::helper('customerattribute')->__(' Both Invoice and Shipping Pdf'))
                );
    }
    
    public function toPdfOptionsArray()
    {
        return array
                (
                    0=> Mage::helper('customerattribute')->__(' No '),
                    1=> Mage::helper('customerattribute')->__(' Invoice Pdf'),
                    2=> Mage::helper('customerattribute')->__(' Shipping Pdf'),
                    3=> Mage::helper('customerattribute')->__(' Both Invoice and Shipping Pdf')
                );
    }
    public function toEditableArray()
    {
        return array
                (
                    array('value' => 0,'label' => Mage::helper('customerattribute')->__('No')),
                    array('value' => 1,'label' => Mage::helper('customerattribute')->__('if Default values')),
                    array('value' => 2,'label' => Mage::helper('customerattribute')->__('if Empty values')),
                    array('value' => 3,'label' => Mage::helper('customerattribute')->__('if Default / Empty values')),
                    array('value' => 4,'label' => Mage::helper('customerattribute')->__('Yes'))
                );
    }
    
    public function toEditableOptionsArray()
    {
        return array
                (
                    0=> Mage::helper('customerattribute')->__('No'),
                    1=> Mage::helper('customerattribute')->__('if Default values'),
                    2=> Mage::helper('customerattribute')->__('if Empty values'),
                    3=> Mage::helper('customerattribute')->__('if Default / Empty values'),
                    4=> Mage::helper('customerattribute')->__('Yes')
                );
    }
}  