<?php 
/*////////////////////////////////////////////////////////////////////////////////
 \\\\\\\\\\\\\\\\\\\\\\\\\  FME Customerattribute extension  \\\\\\\\\\\\\\\\\\\\\\\\\
 /////////////////////////////////////////////////////////////////////////////////
 \\\\\\\\\\\\\\\\\\\\\\\\\ NOTICE OF LICENSE\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
 ///////                                                                   ///////
 \\\\\\\ This source file is subject to the Open Software License (OSL 3.0)\\\\\\\
 ///////   that is bundled with this package in the file LICENSE.txt.      ///////
 \\\\\\\   It is also available through the world-wide-web at this URL:    \\\\\\\
 ///////          http://opensource.org/licenses/osl-3.0.php               ///////
 \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
 ///////                      * @category   FME                            ///////
 \\\\\\\                      * @package    FME_Customerattribute              \\\\\\\
 ///////    * @author     Malik Tahir Mehmood <malik.tahir786@gmail.com>   ///////
 \\\\\\\                                                                   \\\\\\\
 /////////////////////////////////////////////////////////////////////////////////
 \\* @copyright  Copyright 2010  free-magentoextensions.com All right reserved\\\
 /////////////////////////////////////////////////////////////////////////////////
 */

class FME_Customerattribute_CustomerController extends Mage_Core_Controller_Front_Action
{
    protected function _getSession()
    {
        return Mage::getSingleton('customer/session');
    }
     public function preDispatch()
    {
        parent::preDispatch();
       if (!$this->_getSession()->authenticate($this)) {
            $this->setFlag('', self::FLAG_NO_DISPATCH, true);
            if ($this->getRequest()->getActionName() == 'index' || $this->getRequest()->getActionName() == 'savePost') {
                $this->_getSession()->setBeforeAuthUrl(Mage::getUrl('*/*/index', array(
                    '_current' => true
                )));
            }
        }
        return $this;
    }

    public function indexAction()
    {
        $this->loadLayout();
        $this->_initLayoutMessages('customer/session');
        $this->_initLayoutMessages('catalog/session');
        $this->getLayout()->getBlock('head')->setTitle($this->__(Mage::helper('customerattribute')->getheading()));
        $this->getLayout()->getBlock('messages')->setEscapeMessageFlag(true);
        $this->renderLayout();
    }
    public function getCorrectFileName($fileName)
    {
        //$fileName = preg_replace('/[^a-z0-9_\\-\\.]+/i', '_', $fileName);
        //$fileInfo = pathinfo($fileName);
        return pathinfo($fileName);
    }
    public function downloadAction()
    {
        
        $session = Mage::getSingleton('customer/session');
        if (!$session->isLoggedIn()) {
            $this->_redirect('*/*/');
            return;
        }
        $file = $this->getRequest()->getParam('filefor');
        if(substr($file,0,3)=='fm_'){
            $file=substr($file,3);
            $customer =  $session->getCustomer();
            $value = Mage::getModel('customerattribute/customerattribute')->getSavedFieldData($customer->getId(),$file,'customers');
           
            if($value !=''){
                $fileDetails = pathinfo($value);
                
                $fileName = $fileDetails['basename'];
                $fileType = $fileDetails['extension'];
                $filePath = Mage::getBaseDir('media'). '/customerattribute/' . $value;
                if(isset($_SERVER['HTTP_USER_AGENT']) && preg_match("/MSIE/", $_SERVER['HTTP_USER_AGENT'])) {
                    ini_set( 'zlib.output_compression','Off' );
                }
                header("Content-Type: $fileType");
                header("Pragma: public");
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                header("Content-Disposition: attachment; filename=$fileName");
                header("Content-Transfer-Encoding: binary");
                header("Content-length: " . filesize($filePath));
                // read file
                readfile($filePath);
                //Mage::getSingleton('core/session')->addSuccess(Mage::helper('customerattribute')->__('Requested file was Successfully provided.'));
             exit;
            }
            Mage::getSingleton('core/session')->addError(Mage::helper('customerattribute')->__('The file doesn\'t exists or is unauthorize access.'));
        }else{
            Mage::getSingleton('core/session')->addError(Mage::helper('customerattribute')->__('The file doesn\'t exists or is unauthorize access.'));
        }
        $this->_redirect('*/*/');
        return;
    }
    public function savePostAction()
    {
        $session = Mage::getSingleton('customer/session');
        if (!$session->isLoggedIn()) {
            $this->_redirect('*/*/');
            return;
        }
        $customer =  $session->getCustomer();
        
        $post = $this->getRequest()->getPost();
        $translate = Mage::getSingleton('core/translate');
        if(isset($_FILES)) {
            $fieldIds =  array();
            foreach($_FILES as $field => $value){
                if(substr($field,0,3)=='fm_'){
                    $fieldIds[]=substr($field,3);
                }
            }
            $fieldsdata = Mage::getModel('customerattribute/customerattribute')->getFieldLoaded($fieldIds);
            foreach($fieldIds as $key => $fieldId){
                try {
                    $fielddata = $fieldsdata[$key];
                    $org_name = 'fm_'. $fieldId;
                    if($_FILES[$org_name]['name'] ==''){
                        continue;
                    }
                    if($_FILES[$org_name]['name'] && $fielddata['fme_size']>0 && $fielddata['fme_size']!='' && ($_FILES[$org_name]['size'] / 1024 / 1024) > $fielddata['fme_size']){
                        Mage::getSingleton('core/session')->addError(Mage::helper('customerattribute')->__('Size of the uploaded file for  "' . $fielddata['frontend_label'] . '" is greater than allowed.'));
                        throw new Exception();
                    }
                    $ext = array();
                    $extensions = array();
                    $ext = explode(",",$fielddata['fme_ext']);
                    foreach($ext as $exten)
                    {
                        $exten=trim($exten);
                        $extensions[]=$exten;
                    }
                    /* Starting upload */        
                    $uploader = new Varien_File_Uploader($org_name);
                    
                    // Any extention would work
                    $uploader->setAllowedExtensions($extensions);
                    if(!$uploader->checkAllowedExtension($uploader->getFileExtension())){
                        Mage::getSingleton('core/session')->addError(Mage::helper('customerattribute')->__('The file type of the uploaded file for  "' . $fielddata['frontend_label'] . '" is not allowed.'));
                        throw new Exception();
                    }
                    $uploader->setAllowRenameFiles(true);
                    $uploader->setFilesDispersion(true);
                    $path = Mage::getBaseDir('media'). '/customerattribute/';
                    $uploader->save($path);
                    $post['fme_account'][$org_name] = $uploader->getUploadedFileName();
                }
                catch (Exception $e) {
                    $translate->setTranslateInline(true);
                    Mage::getSingleton('core/session')->addError(Mage::helper('customerattribute')->__('Unable to upload "' . $fielddata['frontend_label'] . '" Please try again later.'));
                    //throw new Exception();
                }
            }
        }
        
        if(isset($post['fme_account']) && count($post['fme_account'])){
            $dataToSave= array();
            foreach($post['fme_account'] as $key=>$postdata){
                if(substr($key,0,3)=='fm_'){
                    $dataToSave[substr($key,3)]=$postdata;
                }
            }
            
            Mage::getModel('customerattribute/customerattribute')->SaveToFM('customer',0,'customers',$customer->getId(),$dataToSave);
             Mage::getSingleton('core/session')->addSuccess(Mage::helper('customerattribute')->__('Your %1s was successfully updated.', Mage::helper('customerattribute')->getheading()));
                
        }
        $this->_redirect('*/*/');
	return;
    }
}
