<?php 
/*////////////////////////////////////////////////////////////////////////////////
 \\\\\\\\\\\\\\\\\\\\\\\\\  FME Customerattribute extension  \\\\\\\\\\\\\\\\\\\\\\\\\
 /////////////////////////////////////////////////////////////////////////////////
 \\\\\\\\\\\\\\\\\\\\\\\\\ NOTICE OF LICENSE\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
 ///////                                                                   ///////
 \\\\\\\ This source file is subject to the Open Software License (OSL 3.0)\\\\\\\
 ///////   that is bundled with this package in the file LICENSE.txt.      ///////
 \\\\\\\   It is also available through the world-wide-web at this URL:    \\\\\\\
 ///////          http://opensource.org/licenses/osl-3.0.php               ///////
 \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
 ///////                      * @category   FME                            ///////
 \\\\\\\                      * @package    FME_Customerattribute              \\\\\\\
 ///////    * @author     Malik Tahir Mehmood <malik.tahir786@gmail.com>   ///////
 \\\\\\\                                                                   \\\\\\\
 /////////////////////////////////////////////////////////////////////////////////
 \\* @copyright  Copyright 2010  free-magentoextensions.com All right reserved\\\
 /////////////////////////////////////////////////////////////////////////////////
 */

class FME_Customerattribute_FieldsController extends Mage_Adminhtml_Controller_Action
{

    protected $_entityTypeId;
    protected $_entityType='fme_customerattribute';
       
    public function preDispatch()
    {
        parent::preDispatch();
        $this->_entityTypeId = Mage::getModel('eav/entity')->setType($this->_entityType)->getTypeId();
    }
    
    protected function _initCustomerattributeProducts() {
	    
	$customerattribute = Mage::getModel('customerattribute/customerattribute');
	$customerattributeId  = (int) $this->getRequest()->getParam('attribute_id');
//		if ($customerattributeId) {
//        	$customerattribute->load($customerattributeId);
//		}
	Mage::register('current_customerattribute_products', $customerattribute);
	return $customerattribute;
	    
    }

    protected function _initAction() {
	$this->_title($this->__('FME Extensions'))
	 ->_title($this->__('Customer Attribute Manager'));
       //  ->_title($this->__('Attribute '));
	    
	//if($this->getRequest()->getParam('popup')) {
	//    $this->loadLayout('popup');
	//} else {
	    $this->loadLayout()
		->_setActiveMenu('fme_extensions/customerattribute')
		->_addBreadcrumb(Mage::helper('catalog')->__('FME Extensions'), Mage::helper('catalog')->__('Customer Attribute Manager'))
		->_addBreadcrumb(
		    Mage::helper('catalog')->__('Manage Customer Attributes'),
		    Mage::helper('catalog')->__('Manage Customer Attributes'))
	    ;
	//}
	return $this;
    }
	
    public function indexAction()
    {
	$this->_initAction()
	    ->_addContent($this->getLayout()->createBlock('customerattribute/adminhtml_customerattribute_grid'));
	$this->renderLayout();
    }

    public function editAction() {
        
	$id = (int)$this->getRequest()->getParam('attribute_id');
		
        $model = Mage::getModel('catalog/resource_eav_attribute');
        $collection = Mage::getResourceModel('eav/entity_attribute_collection');
        $data= $collection=Mage::helper('customerattribute')->getEavAttribute($collection, false ,$id);
	if($id && $id != 0){
	    $data = Mage::getModel('customerattribute/customerattribute')->getAfterLoad($data,$id);
	}
       
        if ($data and !empty($data))
        {
       	    $model->load($id);
            $model->addData($data);
        }
            
        if ($model->getId() || $id == 0) {
                $data = Mage::getSingleton('adminhtml/session')->getFormData(true);
                if (!empty($data)) {
                        $model->setData($data);
                }
                Mage::register('customerattribute_data', $model);
                $this->_title($this->__('FME Extensions'))
                    ->_title($this->__('Field Manager'))
                    ->_title($this->__('Manage Fields'));
                $this->_title($id ? $model->getFrontendLabel() : $this->__('New Field')); 
                
                $this->loadLayout();
                $this->_setActiveMenu('fme_extensions/customerattribute');
                $this->getLayout()->getBlock('head')->setCanLoadExtJs(true);
                $this->_addContent($this->getLayout()->createBlock('customerattribute/adminhtml_customerattribute_edit'))
                     ->_addLeft($this->getLayout()->createBlock('customerattribute/adminhtml_customerattribute_edit_tabs'));

                $this->renderLayout();
        } else {
                Mage::getSingleton('adminhtml/session')->addError(Mage::helper('customerattribute')->__('Field does not exist'));
                $this->_redirect('*/*/');
        }
    }
 
    public function newAction() {
	    $this->_forward('edit');
    }
	
    public function validateAction()
    {
        $response = new Varien_Object();
        $response->setError(false);

        $attributeCode  = $this->getRequest()->getParam('attribute_code');
        $attributeId    = $this->getRequest()->getParam('attribute_id');
        $attribute = Mage::getModel('catalog/resource_eav_attribute')
            ->loadByCode($this->_entityTypeId, $attributeCode);

        if ($attribute->getId() && !$attributeId) {
            Mage::getSingleton('adminhtml/session')->addError(
                Mage::helper('catalog')->__('Attribute with the same code already exists'));
            $this->_initLayoutMessages('adminhtml/session');
            $response->setError(true);
            $response->setMessage($this->getLayout()->getMessagesBlock()->getGroupedHtml());
        }

        $this->getResponse()->setBody($response->toJson());
        
    }
    protected function _filterPostData($data)
    {
        if ($data) {
            /** @var $helperCatalog Mage_Catalog_Helper_Data */
            $helperCatalog = Mage::helper('catalog');
            //labels
            foreach ($data['frontend_label'] as & $value) {
                if ($value) {
                    $value = $helperCatalog->escapeHtml($value);
                }
            }
            //options
            if (!empty($data['option']['value'])) {
                foreach ($data['option']['value'] as &$options) {
                    foreach ($options as &$label) {
                        $label = $helperCatalog->escapeHtml($label);
                    }
                }
            }
            if (!empty($data['default_value_message'])) {
                $data['default_value_message'] = $helperCatalog->escapeHtml($data['default_value_message']);
            }
            if (!empty($data['default_value'])) {
                $data['default_value'] = $helperCatalog->escapeHtml($data['default_value']);
            }
            if (!empty($data['default_value_text'])) {
                $data['default_value_text'] = $helperCatalog->escapeHtml($data['default_value_text']);
            }
            if (!empty($data['default_value_textarea'])) {
                $data['default_value_textarea'] = $helperCatalog->escapeHtml($data['default_value_textarea']);
            }
	    if (!empty($data['default_value_file'])) {
                $data['default_value_file'] = $helperCatalog->escapeHtml($data['default_value_file']);
            }
        }
        return $data;
    }
 
    public function saveAction() {
            if ($data = $this->getRequest()->getPost()) {
              Mage::getSingleton('adminhtml/session')->setIsForFME(true);
	    
             /** @var $session Mage_Admin_Model_Session */
            $session = Mage::getSingleton('adminhtml/session');

            $redirectBack   = $this->getRequest()->getParam('back', false);
            /* @var $model Mage_Catalog_Model_Entity_Attribute */
            $model = Mage::getModel('catalog/resource_eav_attribute');
            /* @var $helper Mage_Catalog_Helper_Product */
            $helper = Mage::helper('catalog/product');

            $id = $this->getRequest()->getParam('attribute_id');
	    //Mage::getModel('customerattribute/customerattribute')->updaterelatedtables($id,$data);

            //validate attribute_code
           $version = Mage::getVersion();
            //validate attribute_code
            if (isset($data['attribute_code'])) {
		
		if(version_compare($version,'1.4.2.0','<')){
		   $validatorAttrCode = new Zend_Validate_Regex('/^[a-z][a-z_0-9]{1,254}$/');
		}else{
		   $validatorAttrCode = new Zend_Validate_Regex(array('pattern' => '/^[a-z][a-z_0-9]{1,254}$/'));
		}
                
                if (!$validatorAttrCode->isValid($data['attribute_code'])) {
                    $session->addError(
                        $helper->__('Attribute code is invalid. Please use only letters (a-z), numbers (0-9) or underscore(_) in this field, first character should be a letter.'));
                    $this->_redirect('*/*/edit', array('attribute_id' => $id, '_current' => true));
                    return;
                }
            }

	     if ($id) {
                $model->load($id);

                if (!$model->getId()) {
                    $session->addError(
                        Mage::helper('catalog')->__('This Attribute no longer exists'));
                    $this->_redirect('*/*/');
                    return;
                }

                // entity type check
                if ($model->getEntityTypeId() != $this->_entityTypeId) {
                    $session->addError(
                        Mage::helper('catalog')->__('This attribute cannot be updated.'));
                    $session->setAttributeData($data);
                    $this->_redirect('*/*/');
                    return;
                }

                $data['attribute_code'] = $model->getAttributeCode();
               // $data['is_user_defined'] = $model->getIsUserDefined();
                $data['frontend_input'] = $model->getFrontendInput();
            } else {
                /**
                * @todo add to helper and specify all relations for properties
                */
                if(version_compare($version,'1.4.2.0','<')){
		    if (isset($data['frontend_input']) && $data['frontend_input'] == 'multiselect') {
			$data['backend_model'] = 'eav/entity_attribute_backend_array';
		    }
		}else{
		    $data['source_model'] = $helper->getAttributeSourceModelByInputType($data['frontend_input']);
		    $data['backend_model'] = $helper->getAttributeBackendModelByInputType($data['frontend_input']);
		}
            }
	    
			
            $model->setEntityType('fme_customerattribute');
            if($data['frontend_input']=='message'){
                $defaultValueField = 'default_value_message';
            }
	    elseif ($data['frontend_input'] == 'textarea') {
               $defaultValueField = 'default_value_textarea';
            }
	    elseif ($data['frontend_input'] == 'image') {
               $defaultValueField = 'default_value_file';
            }
	    elseif ($data['frontend_input'] == 'file') {
               $defaultValueField = 'default_value_file';
            }
	    elseif($data['frontend_input'] == 'checkbox'){
                $defaultValueField = null;
            }
            elseif($data['frontend_input'] == 'radio'){
                $defaultValueField ='';
            }else{
		 $defaultValueField = $model->getDefaultValueByInput($data['frontend_input']);
	    }
            //if (is_null($model->getIsUserDefined()) || $model->getIsUserDefined() != 0) {
                $data['backend_type'] = $model->getBackendTypeByInput($data['frontend_input']);
           // }

            
            if ($defaultValueField) {
                $data['default_value'] = $this->getRequest()->getParam($defaultValueField);
            }
	    
	    
            if(!isset($data['apply_to'])) {
                $data['apply_to'] = array();
            }

            //filter
            $data = $this->_filterPostData($data);
            $model->addData($data);
	    $data = Mage::helper('customerattribute')->getSource($data);
            
            $model->addData($data);
            
	    $DefaultOptionsValue = Mage::helper('customerattribute')->setDefault($data, $model);
               
	    try {
		
		Mage::getModel('customerattribute/customerattribute')->saveEAVData($model, $DefaultOptionsValue , $data);
		Mage::getSingleton('adminhtml/session')->setIsForFME(false);
		
                Mage::getSingleton('adminhtml/session')->setAttributeData(false);
		Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('customerattribute')->__('Attribute was successfully saved'));
		Mage::getSingleton('adminhtml/session')->setFormData(false);

		if ($this->getRequest()->getParam('back')) {
			$this->_redirect('*/*/edit', array('attribute_id' => $model->getId()));
			return;
		}
		
		$this->_redirect('*/*/index/filter//');
		return;
            } catch (Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
                Mage::getSingleton('adminhtml/session')->setFormData($data);
                $this->_redirect('*/*/edit', array('attribute_id' => $this->getRequest()->getParam('attribute_id')));
                return;
            }
        }
        Mage::getSingleton('adminhtml/session')->addError(Mage::helper('customerattribute')->__('Unable to find Attribute to save'));
        $this->_redirect('*/*/index/filter//');
    }
 
    public function deleteAction() {
		if( $this->getRequest()->getParam('attribute_id') > 0 ) {
			try {
				$model = Mage::getModel('eav/entity_attribute');
				 
				$model->setId($this->getRequest()->getParam('attribute_id'))
					->delete();
					 
				Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('adminhtml')->__('Attribute was successfully deleted'));
				$this->_redirect('*/*/index/filter//');
			} catch (Exception $e) {
				Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
				$this->_redirect('*/*/edit', array('attribute_id' => $this->getRequest()->getParam('attribute_id')));
			}
		}
		$this->_redirect('*/*/index/filter//');
    }

//    public function massDeleteAction() {
//        $categoriesattributesIds = $this->getRequest()->getParam('customerattribute');
//        if(!is_array($categoriesattributesIds)) {
//			Mage::getSingleton('adminhtml/session')->addError(Mage::helper('adminhtml')->__('Please select item(s)'));
//        } else {
//            try {
//                foreach ($categoriesattributesIds as $categoriesattributesId) {
//                    $categoriesattributes = Mage::getModel('eav/entity_attribute')->load($categoriesattributesId);
//                    $categoriesattributes->delete();
//                }
//                Mage::getSingleton('adminhtml/session')->addSuccess(
//                    Mage::helper('adminhtml')->__(
//                        'Total of %d record(s) were successfully deleted', count($categoriesattributesIds)
//                    )
//                );
//            } catch (Exception $e) {
//                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
//            }
//        }
//        $this->_redirect('*/*/index/filter//');
//    }
    
    /**
     * Check the permission to run it
     *
     * @return boolean
     */
    protected function _isAllowed()
    {
        return Mage::getSingleton('admin/session')->isAllowed('fme_extensions/customerattribute/customerattribute');
    }
    public function refreshAction() {
	
	Mage::getSingleton('adminhtml/session')->unsCustomersAttributeData();
	$this->_redirect('adminhtml/customer/index');return;
    }
    public function refreshIndividualAction() {
	$id = $this->getRequest()->getParam('id');
	$data = Mage::getSingleton('adminhtml/session')->getCustomersAttributeData();
	if(isset($data[$id])){
	    unset($data[$id]);
	    Mage::getSingleton('adminhtml/session')->setCustomersAttributeData($data);
	}
	$this->_redirect('adminhtml/customer/index');return;
    }
}
