<?php
/*////////////////////////////////////////////////////////////////////////////////
 \\\\\\\\\\\\\\\\\\\\\\\\\  FME Customerattribute extension  \\\\\\\\\\\\\\\\\\\\\
 /////////////////////////////////////////////////////////////////////////////////
 \\\\\\\\\\\\\\\\\\\\\\\\\ NOTICE OF LICENSE\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
 ///////                                                                   ///////
 \\\\\\\ This source file is subject to the Open Software License (OSL 3.0)\\\\\\\
 ///////   that is bundled with this package in the file LICENSE.txt.      ///////
 \\\\\\\   It is also available through the world-wide-web at this URL:    \\\\\\\
 ///////          http://opensource.org/licenses/osl-3.0.php               ///////
 \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
 ///////                      * @category   FME                            ///////
 \\\\\\\                      * @package    FME_Customerattribute          \\\\\\\
 ///////    * @author     Malik Tahir Mehmood <malik.tahir786@gmail.com>   ///////
 \\\\\\\                                                                   \\\\\\\
 /////////////////////////////////////////////////////////////////////////////////
 \\* @copyright  Copyright 2010  free-magentoextensions.com All right reserved\\\
 /////////////////////////////////////////////////////////////////////////////////
 */


$installer = $this;

$installer->startSetup();

$installer->run("

DROP TABLE IF EXISTS {$this->getTable('customerattribute/customers')};
CREATE TABLE {$this->getTable('customerattribute/customers')} (
    `customerattribute_id` int(11) NOT NULL AUTO_INCREMENT,
    `entity_id` int(10) unsigned NOT NULL DEFAULT '0',
    `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0',
    `value` text NULL,
  PRIMARY KEY (`customerattribute_id`),
  UNIQUE KEY `FIELDSMANAGER_CUSTOMER_ENTITY_ATTRIBUTE` (`entity_id`,`attribute_id`),
  KEY `customerattribute_customer_atfk_1` (`attribute_id`),
  KEY `customerattribute_customer_enfk_2` (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE {$this->getTable('customerattribute/customers')}
    ADD CONSTRAINT `customerattribute_customer_atfk_1` FOREIGN KEY (`attribute_id`) REFERENCES `".$installer->getTable('eav/attribute')."` (`attribute_id`) ON DELETE CASCADE ON UPDATE CASCADE,
    ADD CONSTRAINT `customerattribute_customer_enfk_2` FOREIGN KEY (`entity_id`) REFERENCES `".$installer->getTable('customer/entity')."` (`entity_id`) ON DELETE CASCADE ON UPDATE CASCADE;
");
    $eavTypeTable = $installer->getTable('eav_entity_type');
    $typeExists = $installer->getConnection()->fetchOne("SELECT count(*) FROM `{$eavTypeTable}` WHERE `entity_type_code`='fme_customerattribute'");
    if(!$typeExists)
    {
        $data = $installer->getConnection()->insert($eavTypeTable, array('entity_type_code'=>'fme_customerattribute'));
    }

    try{
            $installer->run("
                        ALTER TABLE {$this->getTable('eav/attribute')}
                        ADD `fme_customer_account` SMALLINT( 5 ) NOT NULL DEFAULT '0'
                       
                            
                    ");
    }catch(Exception $e){
            if(strpos($e, 'Column already exists') === false){
                    throw $e;
            }
    }
    try{
            $installer->run("
                        ALTER TABLE {$this->getTable('eav/attribute')}
                        ADD `fme_size` decimal(12,4) DEFAULT NULL
                       
                            
                    ");
    }catch(Exception $e){
            if(strpos($e, 'Column already exists') === false){
                    throw $e;
            }
    }
    try{
            $installer->run("
                            ALTER TABLE {$this->getTable('eav/attribute')}
                            ADD `fme_ext` text NULL
                            
                    ");
    }catch(Exception $e){
            if(strpos($e, 'Column already exists') === false){
                    throw $e;
            }
    }
$installer->run("

    DROP TABLE IF EXISTS {$this->getTable('customerattribute/store')};
    CREATE TABLE IF NOT EXISTS {$this->getTable('customerattribute/store')} (
        `attribute_id` int(10) unsigned NOT NULL,                   
        `store_id` smallint(5) unsigned NOT NULL,                  
        PRIMARY KEY  (`attribute_id`,`store_id`),                   
        KEY `fm_attribute_store_id` (`store_id`)  
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8; 

    DROP TABLE IF EXISTS {$this->getTable('customerattribute/customer_group')};
    CREATE TABLE IF NOT EXISTS {$this->getTable('customerattribute/customer_group')} (
        `attribute_id` int(10) unsigned NOT NULL,                   
        `group_id` smallint(5) unsigned NOT NULL,                  
        PRIMARY KEY  (`attribute_id`,`group_id`),                   
        KEY `fm_attribute_group_id` (`group_id`)  
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    
");

$installer->endSetup(); 