<?php

class MGS_Mpanel_Helper_Customer_Account_Navigation extends MGS_Mgscore_Helper_Data {
	
	const XML_PATH_DISPLAY_ACCOUNT_DASHBOARD = 'customer_navigation/display/account';
	const XML_PATH_RENAME_ACCOUNT_DASHBOARD = 'customer_navigation/rename/account';
	
	const XML_PATH_DISPLAY_ACCOUNT_EDIT = 'customer_navigation/display/account_edit';
	const XML_PATH_RENAME_ACCOUNT_EDIT = 'customer_navigation/rename/account_edit';
	
	const XML_PATH_DISPLAY_ADDRESS_BOOK = 'customer_navigation/display/address_book';
	const XML_PATH_RENAME_ADDRESS_BOOK = 'customer_navigation/rename/address_book';
	
	const XML_PATH_DISPLAY_ORDERS = 'customer_navigation/display/orders';
	const XML_PATH_RENAME_ORDERS = 'customer_navigation/rename/orders';
	
	const XML_PATH_DISPLAY_BILLING_AGREEMENTS = 'customer_navigation/display/billing_agreements';
	const XML_PATH_RENAME_BILLING_AGREEMENTS = 'customer_navigation/rename/billing_agreements';
	
	const XML_PATH_DISPLAY_RECURRING_PROFILES = 'customer_navigation/display/recurring_profiles';
	const XML_PATH_RENAME_RECURRING_PROFILES = 'customer_navigation/rename/recurring_profiles';
	
	const XML_PATH_DISPLAY_REVIEWS = 'customer_navigation/display/reviews';
	const XML_PATH_RENAME_REVIEWS = 'customer_navigation/rename/reviews';
	
	const XML_PATH_DISPLAY_TAGS = 'customer_navigation/display/tags';
	const XML_PATH_RENAME_TAGS = 'customer_navigation/rename/tags';
	
	const XML_PATH_DISPLAY_WISHLIST = 'customer_navigation/display/wishlist';
	const XML_PATH_RENAME_WISHLIST = 'customer_navigation/rename/wishlist';
	
	const XML_PATH_DISPLAY_OAUTH = 'customer_navigation/display/oauth_customer_tokens';
	const XML_PATH_RENAME_OAUTH = 'customer_navigation/rename/oauth_customer_tokens';
	
	const XML_PATH_DISPLAY_NEWSLETTER = 'customer_navigation/display/newsletter';
	const XML_PATH_RENAME_NEWSLETTER = 'customer_navigation/rename/newsletter';
	
	const XML_PATH_DISPLAY_DOWNLOADS = 'customer_navigation/display/downloadable_products';
	const XML_PATH_RENAME_DOWNLOADS = 'customer_navigation/rename/downloadable_products';
	 
	protected $_links = array();

    public function getLinks() {
        if (Mage::getStoreConfig(self::XML_PATH_DISPLAY_ACCOUNT_DASHBOARD)) :
			$label = Mage::getStoreConfig(self::XML_PATH_RENAME_ACCOUNT_DASHBOARD) != '' ? Mage::getStoreConfig(self::XML_PATH_RENAME_ACCOUNT_DASHBOARD) : 'Account Dashboard';
			$this->addLink('customer/account/', $label);
		endif;
        if (Mage::getStoreConfig(self::XML_PATH_DISPLAY_ACCOUNT_EDIT)) :
			$label = Mage::getStoreConfig(self::XML_PATH_RENAME_ACCOUNT_EDIT) != '' ? Mage::getStoreConfig(self::XML_PATH_RENAME_ACCOUNT_EDIT) : 'Account Information';
			$this->addLink('customer/account/edit/', $label);
		endif;
        if (Mage::getStoreConfig(self::XML_PATH_DISPLAY_ADDRESS_BOOK)) :
			$label = Mage::getStoreConfig(self::XML_PATH_RENAME_ADDRESS_BOOK) != '' ? Mage::getStoreConfig(self::XML_PATH_RENAME_ADDRESS_BOOK) : 'Address Book';
			$this->addLink('customer/address/', $label);
		endif;
        if (Mage::getStoreConfig(self::XML_PATH_DISPLAY_ORDERS)) :
			$label = Mage::getStoreConfig(self::XML_PATH_RENAME_ORDERS) != '' ? Mage::getStoreConfig(self::XML_PATH_RENAME_ORDERS) : 'My Orders';
			$this->addLink('sales/order/history/', $label);
		endif;
        if (Mage::getStoreConfig(self::XML_PATH_DISPLAY_BILLING_AGREEMENTS)) :
			$label = Mage::getStoreConfig(self::XML_PATH_RENAME_BILLING_AGREEMENTS) != '' ? Mage::getStoreConfig(self::XML_PATH_RENAME_BILLING_AGREEMENTS) : 'Billing Agreements';
			$this->addLink('sales/billing_agreement/', $label);
		endif;
        if (Mage::getStoreConfig(self::XML_PATH_DISPLAY_RECURRING_PROFILES)) :
			$label = Mage::getStoreConfig(self::XML_PATH_RENAME_RECURRING_PROFILES) != '' ? Mage::getStoreConfig(self::XML_PATH_RENAME_RECURRING_PROFILES) : 'Recurring Profiles';
			$this->addLink('sales/recurring_profile/', $label);
		endif;
        if (Mage::getStoreConfig(self::XML_PATH_DISPLAY_REVIEWS)) :
			$label = Mage::getStoreConfig(self::XML_PATH_RENAME_REVIEWS) != '' ? Mage::getStoreConfig(self::XML_PATH_RENAME_REVIEWS) : 'My Product Reviews';
			$this->addLink('review/customer/', $label);
		endif;
        if (Mage::getStoreConfig(self::XML_PATH_DISPLAY_TAGS)) :
			$label = Mage::getStoreConfig(self::XML_PATH_RENAME_TAGS) != '' ? Mage::getStoreConfig(self::XML_PATH_RENAME_TAGS) : 'My Tags';
			$this->addLink('tag/customer/', $label);
		endif;
        if (Mage::getStoreConfig(self::XML_PATH_DISPLAY_WISHLIST)) :
			$label = Mage::getStoreConfig(self::XML_PATH_RENAME_WISHLIST) != '' ? Mage::getStoreConfig(self::XML_PATH_RENAME_WISHLIST) : 'My Wishlist';
			$this->addLink('wishlist/', $label);
		endif;
        if (Mage::getStoreConfig(self::XML_PATH_DISPLAY_OAUTH)) :
			$label = Mage::getStoreConfig(self::XML_PATH_RENAME_OAUTH) != '' ? Mage::getStoreConfig(self::XML_PATH_RENAME_OAUTH) : 'My Applications';
			$this->addLink('oauth/customer_token/', $label);
		endif;
        if (Mage::getStoreConfig(self::XML_PATH_DISPLAY_NEWSLETTER)) :
			$label = Mage::getStoreConfig(self::XML_PATH_RENAME_NEWSLETTER) != '' ? Mage::getStoreConfig(self::XML_PATH_RENAME_NEWSLETTER) : 'Newsletter Subscriptions';
			$this->addLink('newsletter/manage/', $label);
		endif;
        if (Mage::getStoreConfig(self::XML_PATH_DISPLAY_DOWNLOADS)) :
			$label = Mage::getStoreConfig(self::XML_PATH_RENAME_DOWNLOADS) != '' ? Mage::getStoreConfig(self::XML_PATH_RENAME_DOWNLOADS) : 'My Downloadable Products';
			$this->addLink('downloadable/customer/products/', $label);
		endif;
		//	$label = 'Sponsorship management';
		//	$this->addLink('sponsorship/points/sponsorship/', $label);
        return $this->_links;
    }
	
	public function addLink($path, $label) {
		array_push(
			$this->_links,
			array(
				'path' => $path,
				'label' => $this->__($label)
			)
		);
	}

}