<?php

class MagicToolbox_MagicZoomPlus_MagiczoomplusController extends Mage_Adminhtml_Controller_Action {

    public function indexAction() {

        $this->_title($this->__('Magic Zoom Plus&#8482; Settings'));
        $this->loadLayout()->_setActiveMenu('magictoolbox/magiczoomplus')->renderLayout();

    }

    public function addAction() {

        if($data = $this->getRequest()->getPost()) {

            if(empty($data['store_views']) && empty($data['design'])) {
                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('magiczoomplus')->__('You already have default settings!'));
                $this->_redirect('*/*/');
                return;
            }

            if(empty($data['store_views'])) $data['store_views'] = '';
            list($website_id, $group_id, $store_id) = explode('/', $data['store_views']);
            if(empty($data['design'])) $data['design'] = '';
            list($package, $theme) = explode('/', $data['design']);

            $model = Mage::getModel('magiczoomplus/settings');
            $collection = $model->getCollection();


            $collection->getSelect()->/*columns('custom_settings_title')->*/
                where(empty($website_id) ? 'website_id IS NULL' : 'website_id = ?', empty($website_id) ? null : (int)$website_id)->
                where(empty($group_id)   ? 'group_id IS NULL'   : 'group_id = ?',   empty($group_id)   ? null : (int)$group_id)->
                where(empty($store_id)   ? 'store_id IS NULL'   : 'store_id = ?',   empty($store_id)   ? null : (int)$store_id)->
                where('package = ?', empty($package) ? '' : $package)->
                where('theme = ?', empty($theme) ? '' : $theme);

            if($collection->getSize()) {
                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('magiczoomplus')->__('The settings already exists!'));
                $this->_redirect('*/*/');
                return;
            }

            $custom_settings_title = array();

            if(empty($data['store_views'])) {
                $custom_settings_title[] = 'All Store Views';
            } else {
                if(!empty($website_id)) {
                    $model->setWebsite_id($website_id);
                    $website = Mage::app()->getWebsite($website_id);
                    $custom_settings_title[] = $website->getName();
                }
                if(!empty($group_id)) {
                    $model->setGroup_id($group_id);
                    $group = $website->getGroups();
                    $group = $group[$group_id];
                    if(!$group instanceof Mage_Core_Model_Store_Group) {
                        $group = Mage::app()->getGroup($group);
                    }
                    $custom_settings_title[] = $group->getName();
                }
                if(!empty($store_id)) {
                    $model->setStore_id($store_id);
                    $store = $group->getStores();
                    $store = $store[$store_id];
                    $custom_settings_title[] = $store->getName();
                }
            }

            if(empty($data['design'])) {
                $custom_settings_title[] = 'All Designs';
            } else {
                if(empty($theme)) {
                    $model->setPackage($package);
                    $custom_settings_title[] = $package.' package';
                } else {
                    $model->setPackage($package);
                    $model->setTheme($theme);
                    $custom_settings_title[] = $package.'/'.$theme.' theme';
                }
            }

            $custom_settings_title = 'Settings for '.implode(' => ', $custom_settings_title);
            $model->setCustom_settings_title($custom_settings_title);

            $oldModulesInstalled = Mage::helper('magiczoomplus/params')->checkForOldModules();
            if(empty($oldModulesInstalled)) {
                $defaultValues = Mage::helper('magiczoomplus/params')->getDefaultValues();
            } else {
                $defaultValues = Mage::helper('magiczoomplus/params')->getFixedDefaultValues();
            }
            //NOTE: quotes need to be escaped
            $defaultValues = serialize($defaultValues);

            $model->setValue($defaultValues);

            try {
                $model->save();
                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('magiczoomplus')->__('Settings was successfully added'));
                Mage::getSingleton('adminhtml/session')->setFormData(false);
            } catch(Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
                Mage::getSingleton('adminhtml/session')->setFormData($data);
            }

        } else {
            Mage::getSingleton('adminhtml/session')->addError(Mage::helper('magiczoomplus')->__('Unable to add settings'));
        }
        $this->_redirect('*/*/');

    }

    public function deleteAction() {

        $id = $this->getRequest()->getParam('id');
        if($id > 0) {
            try {
                $model = Mage::getModel('magiczoomplus/settings')->load($id);
                $isDefaultSettings =
                    $model->getWebsite_id() == NULL &&
                    $model->getGroup_id() == NULL &&
                    $model->getStore_id() == NULL &&
                    $model->getPackage() == '' &&
                    $model->getTheme() == '';
                if($isDefaultSettings) {
                    Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('adminhtml')->__('You can not delete default settings!'));
                } else {
                    $model->delete();
                    Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('adminhtml')->__('Settings was successfully deleted'));
                }
            } catch(Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
            }
        }
        $this->_redirect('*/*/');

    }

    public function massDeleteAction() {

        $ids = $this->getRequest()->getParam('massactionId');
        $alert = 0;
        if(is_array($ids)) {
            try {
                foreach($ids as $id) {
                    $model = Mage::getModel('magiczoomplus/settings')->load($id);
                    $isDefaultSettings =
                        $model->getWebsite_id() == NULL &&
                        $model->getGroup_id() == NULL &&
                        $model->getStore_id() == NULL &&
                        $model->getPackage() == '' &&
                        $model->getTheme() == '';
                    if($isDefaultSettings) {
                        $alert = 1;
                    } else {
                        $model->delete();
                    }
                }
                Mage::getSingleton('adminhtml/session')->addSuccess(
                    Mage::helper('adminhtml')->__('Total of %d row(s) were successfully deleted', count($ids)-$alert)
                );
                if($alert) {
                    Mage::getSingleton('adminhtml/session')->addSuccess(
                        Mage::helper('adminhtml')->__('You can not delete default settings!')
                    );
                }
            } catch(Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
            }
        } else {
            Mage::getSingleton('adminhtml/session')->addError(Mage::helper('adminhtml')->__('Please select rows'));
        }
        $this->_redirect('*/*/');

    }

    public function editAction() {

        $id = $this->getRequest()->getParam('id');
        $model  = Mage::getModel('magiczoomplus/settings')->load($id);
        if($model->getId()) {
            Mage::register('magiczoomplus_model_data', $model);

            $oldModulesInstalled = Mage::helper('magiczoomplus/params')->checkForOldModules();
            if(!empty($oldModulesInstalled)) {
                $message = 'You have installed '.
                    $oldModulesInstalled[0]['name'].' v'.$oldModulesInstalled[0]['version'].'. '.
                    'Pease update it to the latest version to work correctly with this version of the Magic Zoom Plus module.';
                Mage::getSingleton('adminhtml/session')->addError(Mage::helper('magiczoomplus')->__($message));
            }

            $this->_title($this->__('Magic Zoom Plus&#8482; Settings'));
            $this->loadLayout();
            $this->_setActiveMenu('magictoolbox/magiczoomplus');
            $this->renderLayout();
        } else {
            Mage::getSingleton('adminhtml/session')->addError(Mage::helper('magiczoomplus')->__('Settings does not exist'));
            $this->_redirect('*/*/');
        }

    }

    public function saveAction() {

        if($post = $this->getRequest()->getPost()) {
            $id = $this->getRequest()->getParam('id');
            $model = Mage::getModel('magiczoomplus/settings');


            /*
            foreach($post['magiczoomplus'] as $block => $params) {
                if(is_array($params))
                foreach($params  as $paramId => $value) {
                    if(isset($post['magiczoomplus-defaults'][$block][$paramId])) {
                        unset($post['magiczoomplus'][$block][$paramId]);
                    }
                }
            }
            */

            $data = array();

            $postSettings = $post['magiczoomplus'];
            $oldModulesInstalled = Mage::helper('magiczoomplus/params')->checkForOldModules();
            if(!empty($oldModulesInstalled)) {
                foreach($postSettings as $platform => $platformData) {
                    foreach($platformData as $profile => $profileData) {
                        foreach($profileData as $param => $value) {
                            if($param == 'enable-effect' || $param == 'include-headers-on-all-pages') {
                                $postSettings[$platform][$profile][$param] = 'No';
                            }
                        }
                    }
                }
            }

            $data['value'] = serialize($postSettings);
            $data['last_edit_time'] = now();
            $model->setData($data)->setId($id);
            try {
                $model->save();
                Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('magiczoomplus')->__('Settings was successfully saved'));
                Mage::getSingleton('adminhtml/session')->setFormData(false);
                if($this->getRequest()->getParam('back')) {
                    $this->_redirect('*/*/edit', array(
                        'id'        => $id,
                        '_current'  => true,
                        'back'      => null
                    ));
                    return;
                }
                $this->_redirect('*/*/');
                return;
            } catch(Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
                Mage::getSingleton('adminhtml/session')->setFormData($post);
                $this->_redirect('*/*/edit', array('id' => $id));
                return;
            }
        }
        Mage::getSingleton('adminhtml/session')->addError(Mage::helper('magiczoomplus')->__('Unable to find settings to save'));
        $this->_redirect('*/*/');

    }

    public function validateAction() {

        $response = new Varien_Object();
        $response->setError(false);
        try {
            /**
             * @todo implement full validation process with errors returning which are ignoring now
             */
        }
        catch (Mage_Eav_Model_Entity_Attribute_Exception $e) {
            $response->setError(true);
            $response->setAttribute($e->getAttributeCode());
            $response->setMessage($e->getMessage());
        }
        catch (Mage_Core_Exception $e) {
            $response->setError(true);
            $response->setMessage($e->getMessage());
        }
        catch (Exception $e) {
            $this->_getSession()->addError($e->getMessage());
            $this->_initLayoutMessages('adminhtml/session');
            $response->setError(true);
            $response->setMessage($this->getLayout()->getMessagesBlock()->getGroupedHtml());
        }
        $this->getResponse()->setBody($response->toJson());

    }

    protected function _isAllowed() {
        return Mage::getSingleton('admin/session')->isAllowed('admin/magictoolbox/magiczoomplus');
    }

}
