<?php 
	class Cmsmart_Productvideo_MediaController extends Mage_Core_Controller_Front_Action
	{
		public function indexAction(){
			$this->loadLayout();
			$this->renderLayout();
		}
		
		public function changeVideoAction(){
			$postData = $this->getRequest()->getPost();;
			$resultData = array();
			$config = Mage::helper('productvideo')->getVideoDimensionConfig();
			
			$videoData = Mage::getModel('productvideo/productvideo')->load($postData['vid']);
			
			if($videoData->getProvider() && $videoData->getProvider()!=''){
				$resultData['html'] = $this->changeVideo($videoData,$config['video_width'],$config['video_height']);
			}else{
				$resultData['error'] = $this->__('Can not find this video');
			}
			echo json_encode($resultData);
		}
		
		public function changePopupVideoAction(){
			$postData = $this->getRequest()->getPost();;
			$resultData = array();
			$config = Mage::helper('productvideo')->getPopupDimensionConfig();
			
			$videoData = Mage::getModel('productvideo/productvideo')->load($postData['vid']);
			
			if($videoData->getProvider() && $videoData->getProvider()!=''){
				$resultData['html'] = $this->changeVideo($videoData,$config['popup_width'],$config['popup_height']);
			}else{
				$resultData['error'] = $this->__('Can not find this video');
			}
			echo json_encode($resultData);
		}
		
		public function openPopupAction(){
			$postData = $this->getRequest()->getPost();
			$resultData = array();
			$productData = Mage::getModel('catalog/product')->load($postData['pid']);
			$videos = Mage::getModel('productvideo/productvideo')->getCollection()
							->addFieldToFilter('product_id',$postData['pid'])
							->addFieldToFilter('status',1)
							->addOrder('position','ASC');

			$config = Mage::helper('productvideo')->getConfigData();
			$pathUrl = Mage::helper('productvideo')->getMediaPathUrl();
			
			if($postData['type']==='together_popup' || $postData['type']==='bar_popup' || $postData['type']==='bottom_popup'){
				
				
				/* POPUP DISPLAY CONTENT */
				$resultData['html'] = '<div id="productvideo-popup-display-item" class="" style="width:'.$config['popup_width'].'px;height:'.$config['popup_height'].'px;display:block" >';
				
				if(isset($postData['vid']) && $postData['vid']!=''){
					$videoData = Mage::getModel('productvideo/productvideo')->load($postData['vid']);
					if($videoData->getProvider() && $videoData->getProvider()!=''){
						$resultData['html'] .= $this->changeVideo($videoData,$config['popup_width'],$config['popup_height']);
					}else{
						$resultData['error'] = $this->__('Can not find this video');
					}
				}elseif(isset($postData['iid']) && $postData['iid']!=''){
					foreach($productData->getMediaGalleryImages() as $image){
						if($image->getValueId()==$postData['iid']){
							$_imghtml = '<img id="popup-image" width="'.$config['popup_width'].'" height="'.$config['popup_height'].'" src="'.$image->getUrl().'" alt="'.Mage::helper('core')->escapeHtml($image->getLabel()).'" title="'.Mage::helper('core')->escapeHtml($image->getLabel()).'"/>';
							$resultData['html'] .= Mage::helper('catalog/output')->productAttribute($productData, $_imghtml, 'image');
						}
					}
				}
				
				$resultData['html'] .= '</div>';
				/* END POPUP DISPLAY CONTENT */
				
				/* POPUP LIST ITEM CONTENT */
				if($config['thumbnail_slide_in_popup'] && $postData['type']==='together_popup'){
					$resultData['html'] .= '<div class="productvideo-popup-list-item-title">'.$this->__('More views').'</div>';
					$resultData['html'] .= '<div class="productvideo-image-slider-content-wrapper">';
					$resultData['html'] .= '<span onclick="imageSliderBackButton(this,'.$config['thumbnail_slide_speed'].');" title="'.$this->__('Back').'" class="productvideo-image-slider-back-button productvideo-image-slider-button disable" style="height:'.$config['thumbnail_height'].'px"></span>';
					$resultData['html'] .= '<div class="productvideo-image-slider-wrapper" style="height:'.($config['thumbnail_height']+2).'px;width:'.$config['popup_width'].'px;">';
					$resultData['html'] .= '<div class="productvideo-popup-list-item productvideo-image-slider">';
				}elseif(!$config['thumbnail_slide_in_popup'] && $postData['type']==='together_popup'){
					$resultData['html'] .= '<div class="productvideo-popup-list-item-title">'.$this->__('More views').'</div>';
					$resultData['html'] .= '<div class="productvideo-popup-list-item">';
				}
				if(count($productData->getMediaGalleryImages())>0 && ((isset($postData['iid']) && $postData['iid']!='') || $postData['type']==='together_popup' || $postData['type']==='bottom_popup')){
					if($config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '<div class="productvideo-popup-list-item-title image';
						if(isset($postData['iid']) && $postData['iid']!=''){
							$resultData['html'] .= ' selected">'.$this->__('Images').'</div>';
						}else{
							$resultData['html'] .= '">'.$this->__('Images').'</div>';
						}
						$resultData['html'] .= '<div class="productvideo-image-slider-content-wrapper">';
						$resultData['html'] .= '<span onclick="imageSliderBackButton(this,'.$config['thumbnail_slide_speed'].');" title="'.$this->__('Back').'" class="productvideo-image-slider-back-button productvideo-image-slider-button disable" style="height:'.$config['thumbnail_height'].'px"></span>';
						$resultData['html'] .= '<div class="productvideo-image-slider-wrapper" style="height:'.($config['thumbnail_height']+2).'px;width:'.$config['popup_width'].'px;">';
						$resultData['html'] .= '<div class="productvideo-popup-list-item productvideo-image-slider">';
					}elseif(!$config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '<div class="productvideo-popup-list-item-title image';
						if(isset($postData['iid']) && $postData['iid']!=''){
							$resultData['html'] .= ' selected">'.$this->__('Images').'</div>';
						}else{
							$resultData['html'] .= '">'.$this->__('Images').'</div>';
						}
						$resultData['html'] .= '<div class="productvideo-popup-list-item">';
					}
					
					foreach($productData->getMediaGalleryImages() as $image){
						$tmpClass = '';
						$tmpStyle = '';
						if($config['thumbnail_slide_in_popup']){
							$tmpStyle = 'width:'.$config['thumbnail_width'].'px';
						}
						if(isset($postData['iid']) && $postData['iid']!='' && $image->getValueId()==$postData['iid']){
							$tmpClass .= 'selected';
						}
						$resultData['html'] .= '<a style="'.$tmpStyle.'" href="#" class="productvideo-popup-item '.$tmpClass.'" onclick="return false;"><img class="image" width="'.$config['thumbnail_width'].'" height="'.$config['thumbnail_height'].'" src="'.$image->getUrl().'" alt="'.Mage::helper('core')->escapeHtml($image->getLabel()).'" title="'.Mage::helper('core')->escapeHtml($image->getLabel()).'"/></a>';
					}
					
					if($config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '</div>';
						$resultData['html'] .= '</div>';
						$resultData['html'] .= '<span onclick="imageSliderNextButton(this,'.$config['thumbnail_slide_speed'].');"  title="'.$this->__('Next').'" class="productvideo-image-slider-next-button productvideo-image-slider-button" style="height:'.$config['thumbnail_height'].'px"></span>';
						$resultData['html'] .= '</div>';
					}elseif(!$config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '</div>';
					}
				}
				if($videos->getSize()>0 && ((isset($postData['vid']) && $postData['vid']!='') || $postData['type']==='together_popup'|| $postData['type']==='bottom_popup')){
					if($config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '<div class="productvideo-popup-list-item-title video';
						if(isset($postData['vid']) && $postData['vid']!=''){
							$resultData['html'] .= ' selected">'.$this->__('Videos').'</div>';
						}else{
							$resultData['html'] .= '">'.$this->__('Videos').'</div>';
						}
						$resultData['html'] .= '<div class="productvideo-image-slider-content-wrapper">';
						$resultData['html'] .= '<span onclick="imageSliderBackButton(this,'.$config['thumbnail_slide_speed'].');" title="'.$this->__('Back').'" class="productvideo-image-slider-back-button productvideo-image-slider-button disable" style="height:'.$config['thumbnail_height'].'px"></span>';
						$resultData['html'] .= '<div class="productvideo-image-slider-wrapper" style="height:'.($config['thumbnail_height']+2).'px;width:'.$config['popup_width'].'px;">';
						$resultData['html'] .= '<div class="productvideo-popup-list-item productvideo-image-slider">';
					}elseif(!$config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '<div class="productvideo-popup-list-item-title video';
						if(isset($postData['vid']) && $postData['vid']!=''){
							$resultData['html'] .= ' selected">'.$this->__('Videos').'</div>';
						}else{
							$resultData['html'] .= '">'.$this->__('Videos').'</div>';
						}
						$resultData['html'] .= '<div class="productvideo-popup-list-item">';
					}
					
					foreach ($videos as $video){
						$tmpClass = '';
						$tmpStyle = '';
						if($config['thumbnail_slide_in_popup']){
							$tmpStyle = 'width:'.$config['thumbnail_width'].'px';
						}
						if(isset($postData['vid']) && $postData['vid']!='' && $video->getProductvideoId()==$postData['vid']){
							$tmpClass .= 'selected';
						}
						if($video->getThumbnail()!==''){
							$video_thumbnail_path_url = $pathUrl['thumbnail_product'].$postData['pid'].'/'.$video->getThumbnail();
						}else{
							$video_thumbnail_path_url = $pathUrl['thumbnail_product'].$config['thumbnail_image'];
						}
						$resultData['html'] .= '<a style="'.$tmpStyle.'" href="#" class="productvideo-popup-item '.$tmpClass.'" onclick="return false;"><img id="productvideo-id-'.$video->getProductvideoId().'" class="video" src="'.$video_thumbnail_path_url.'" title="'.$video->getVideoName().'" width="'.$config['thumbnail_width'].'" height="'.$config['thumbnail_height'].'" alt="'.$video->getVideoId().'" />';
						if($config['show_play_icon']){
							$resultData['html'] .= '<span class="productvideo-play-icon"></span>';
						}
						$resultData['html'] .= '</a>';
					}
					
					if($config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '</div>';
						$resultData['html'] .= '</div>';
						$resultData['html'] .= '<span onclick="imageSliderNextButton(this,'.$config['thumbnail_slide_speed'].');"  title="'.$this->__('Next').'" class="productvideo-image-slider-next-button productvideo-image-slider-button" style="height:'.$config['thumbnail_height'].'px"></span>';
						$resultData['html'] .= '</div>';
					}elseif(!$config['thumbnail_slide_in_popup'] && $postData['type']!=='together_popup'){
						$resultData['html'] .= '</div>';
					}
				}
				/* END POPUP LIST ITEM CONTENT */
				
				if($config['thumbnail_slide_in_popup'] && $postData['type']==='together_popup'){
					$resultData['html'] .= '</div>';
					$resultData['html'] .= '</div>';
					$resultData['html'] .= '<span onclick="imageSliderNextButton(this,'.$config['thumbnail_slide_speed'].');"  title="'.$this->__('Next').'" class="productvideo-image-slider-next-button productvideo-image-slider-button" style="height:'.$config['thumbnail_height'].'px"></span>';
					$resultData['html'] .= '</div>';
				}elseif(!$config['thumbnail_slide_in_popup'] && $postData['type']==='together_popup'){
					$resultData['html'] .= '</div>';
					$resultData['html'] .= '</div>';
				}
				/* POPUP Javascript */
				$changePopupVideo = Mage::getUrl('productvideo/media/changePopupVideo', array('_secure'=>(!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']==='on')));
				$resultData['html'] .='<script type="text/javascript">jQuery(document).ready(function(){jQuery(".productvideo-popup-item").click(function(){popupAthumbnail=jQuery(this);popupThumbnail=jQuery(this).children("img");if(!popupAthumbnail.hasClass("selected")){if(popupThumbnail.hasClass("video")){vid=popupThumbnail.attr("id").replace("productvideo-id-","");jQuery.ajax({type:"POST",url:"'.$changePopupVideo.'",data:{"vid":vid},beforeSend:function(){jQuery("#productvideo-popup-content-ajax").css("-moz-opacity:","0.2");jQuery("#productvideo-popup-content-ajax").css("-webkit-opacity","0.2");jQuery("#productvideo-popup-content-ajax").css("-ms-filter","progid:DXImageTransform.Microsoft.Alpha(Opacity=20)");jQuery("#productvideo-popup-content-ajax").css("opacity","0.2");jQuery("#productvideo-popup-display-item").html("");jQuery("#productvideo-popup-ajaxloading").css("display","block");},success:function(data){},complete:function(data){var responseData=jQuery.parseJSON(data.responseText);if(responseData.error){alert(responseData.error);}else{jQuery("#productvideo-popup-content-ajax").css("-moz-opacity:","1");jQuery("#productvideo-popup-content-ajax").css("-webkit-opacity","1");jQuery("#productvideo-popup-content-ajax").css("-ms-filter","progid:DXImageTransform.Microsoft.Alpha(Opacity=100)");jQuery("#productvideo-popup-content-ajax").css("opacity","1");jQuery(".productvideo-popup-item").removeClass("selected");popupAthumbnail.addClass("selected");jQuery("#productvideo-popup-ajaxloading").css("display","none");jQuery("#productvideo-popup-display-item").html(responseData.html);}},error:function(response){alert(response.responseText);}});}if(popupThumbnail.hasClass("image")){isrc = popupThumbnail.attr("src");ilabel = popupThumbnail.attr("label");ititle = popupThumbnail.attr("title");jQuery(".productvideo-popup-item").removeClass("selected");popupAthumbnail.addClass("selected");jQuery("#productvideo-popup-display-item").html(\'<img width="'.$config['popup_width'].'" height="'.$config['popup_height'].'" id="popup-image" src="\'+isrc+\'" alt="\'+ilabel+\'" title="\'+ititle+\'" />\');}}});jQuery(".productvideo-play-icon").hover(function(){jQuery(this).animate({opacity: 1},500);},function(){jQuery(this).animate({opacity: 0.3},500);});jQuery("#productvideo-popup-content-ajax.bottom_popup .productvideo-popup-item").click(function(){jQuery("#productvideo-popup-content-ajax .productvideo-popup-list-item-title").removeClass("selected");titleClass = jQuery(this).children("img").attr("class");jQuery("#productvideo-popup-content-ajax .productvideo-popup-list-item-title").each(function(){if(jQuery(this).hasClass(titleClass)){jQuery(this).addClass("selected");}});});});</script>';
				
				/*$resultData['html'] .='<script type="text/javascript" src="'.Mage::getDesign()->getSkinUrl('js/cmsmart/productvideo/cmsmart_productvideo_popup.js').'"></script>';*/
				
				if($config['thumbnail_slide_in_popup']){
					$resultData['html'] .='<script type="text/javascript" src="'.Mage::getDesign()->getSkinUrl('js/cmsmart/productvideo/cmsmart_productvideo_slide.js').'"></script>';
				}
				/* END POPUP Javascript */
				
			}else{
				$resultData['error'] = $this->__('Display type is not defined!!!');
			}
			echo json_encode($resultData);
		}
		
		protected function changeVideo($videoData,$width=0,$height=0){
			$resultData = '';
			
			$pathUrl = Mage::helper('productvideo')->getMediaPathUrl();
			$config = Mage::helper('productvideo')->getConfigData();
			
			if($videoData->getThumbnail()!=''){
				$video_thumbnail_path_url = $pathUrl['thumbnail_product'].$videoData->getProductId().'/'.$videoData->getThumbnail();
			}else{
				$video_thumbnail_path_url = $pathUrl['thumbnail_product'].$config['thumbnail_image'];
			}
			
			if($videoData->getProvider()=='youtube'){
			
				/* RESULT YOUTUBE VIDEO HTML DATA */
				$resultData = '<iframe src="//www.youtube.com/embed/'.$videoData->getVideoId().'?wmode=opaque" width="'.$width.'" height="'.$height.'" frameborder="0"  webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
				
			}elseif($videoData->getProvider()=='vimeo'){
				
				/* RESULT VIMEO VIDEO HTML DATA */
				$enableApi = 1;
				$playerId = 'vimeoplayer';
				$showTitle = 'false';
				$showPortrait = 'false';
				$autoPlay = 'false';
				$vimeoLoop = 'false';
				$autoPause = 'true';
				$controlColor = '';
				
				$resultData = '<iframe src="//player.vimeo.com/video/'.$videoData->getVideoId().'?api='.$enableApi.'&player_id='.$playerId.'&title='.$showTitle.'&width='.$width.'&height='.$height.'&portrait='.$showPortrait.'&autoplay='.$autoPlay.'&loop='.$vimeoLoop.'&autopause='.$autoPause.'" width="'.$width.'" height="'.$height.'" frameborder="0"  webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
				
				/*if($enableApi){
					$resultData .= '<script type="text/javascript">
						jQuery(document).ready(function(){
							jQuery(".productvideo-tab-item").click(function(){
									document.getElementById("'.$playerId.'").api_pause();
							});
						});
						</script>';
				}*/
				
			}elseif($videoData->getProvider()=='local'){
			
				/* RESULT LOCAL VIDEO HTML DATA */
				$videoLocalConfig = Mage::helper('productvideo')->getVideoLocalConfigData();
				
				$iframeSrc .= 'vdo='.$pathUrl['video_product'].$videoData->getProductId().'/'.$videoData->getVideoId();
				$iframeSrc .= '&splashscreen='.$video_thumbnail_path_url;
				$iframeSrc .= '&sound='.$videoLocalConfig['sound'];
				$iframeSrc .= '&buffer='.$videoLocalConfig['buffer'];
				if($videoLocalConfig['autoplay']==0): $iframeSrc .='&autoplay=false';
				else: $iframeSrc .='&autoplay=true'; endif;
				if($videoLocalConfig['click_tag']!=='') $iframeSrc .='&clickTAG='.$videoLocalConfig['click_tag'];
				if($videoLocalConfig['end_video_action']!=='') $iframeSrc .='&endclipaction='.$videoLocalConfig['end_video_action'];
				if($videoLocalConfig['use_adv']==1){
					$iframeSrc .= '&advert='.$videoLocalConfig['adv_url'];
					$iframeSrc .= '&advertdesc='.$videoLocalConfig['adv_description'];
				}
				if($videoLocalConfig['use_logo']==1){
					$iframeSrc .= '&mylogo='.$videoLocalConfig['logo'];
					$iframeSrc .= '&logoposition='.$videoLocalConfig['logo_position'];
				}
				if($videoLocalConfig['loop']==0): $iframeSrc .='&loop=false';
				else: $iframeSrc .='&loop=true'; endif;
				/*
				$iframeSrc .= '&tracker=$videoLocalConfig['tracker']';
				;*/
				
				$resultData = '<embed width="'.$width.'" height="'.$height.'" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" allowscriptaccess="always" wmode="transparent" quality="best" allowfullscreen="true" flashvars="&'. $iframeSrc.'" src="'.$pathUrl['flash_player'].'">';
				
			}
			return($resultData);
		}
	}