<?php
/*------------------------------------
* Product Video Extention
* Author  CMSMart Team
* Copyright Copyright (C) 2012 http://cmsmart.net. All Rights Reserved.
* @license - http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
* Websites: http://cmsmart.net
* Email: team@cmsmart.net
* Technical Support: http://cmsmart.net/support_ticket/
* Forum - http://cmsmart.net/forum
-----------------------------------------------------*/
class Cmsmart_Productvideo_Block_Adminhtml_Allvideo_Edit extends Mage_Adminhtml_Block_Widget_Form_Container
{
    public function __construct()
    {
        parent::__construct();
                 
        $this->_objectId = 'id';
        $this->_blockGroup = 'productvideo';
        $this->_controller = 'adminhtml_allvideo';
        
        $this->_updateButton('save', 'label', Mage::helper('productvideo')->__('Save Item'));
        $this->_updateButton('delete', 'label', Mage::helper('productvideo')->__('Delete Item'));
		
        $this->_addButton('saveandcontinue', array(
            'label'     => Mage::helper('adminhtml')->__('Save And Continue Edit'),
            'onclick'   => 'saveAndContinueEdit()',
            'class'     => 'save',
        ), -100);

        $this->_formScripts[] = "
            function toggleEditor() {
                if (tinyMCE.getInstanceById('productvideo_content') == null) {
                    tinyMCE.execCommand('mceAddControl', false, 'productvideo_content');
                } else {
                    tinyMCE.execCommand('mceRemoveControl', false, 'productvideo_content');
                }
            }

            function saveAndContinueEdit(){
                editForm.submit($('edit_form').action+'back/edit/');
            }
        ";
    }

    public function getHeaderText()
    {
        if( Mage::registry('allvideo_data') && Mage::registry('allvideo_data')->getId() ) {
            return Mage::helper('productvideo')->__("Edit Item '%s'", $this->htmlEscape(Mage::registry('allvideo_data')->getVideoName()));
        } else {
            return Mage::helper('productvideo')->__('Add Item');
        }
    }
}