<?php
/*------------------------------------
* Product Video Extention
* Author  CMSMart Team
* Copyright Copyright (C) 2012 http://cmsmart.net. All Rights Reserved.
* @license - http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
* Websites: http://cmsmart.net
* Email: team@cmsmart.net
* Technical Support: http://cmsmart.net/support_ticket/
* Forum - http://cmsmart.net/forum
-----------------------------------------------------*/
class Cmsmart_Productvideo_Block_Adminhtml_Pendingvideo_Grid extends Mage_Adminhtml_Block_Widget_Grid
{
  public function __construct()
  {
      parent::__construct();
      $this->setId('pendingvideoGrid');
      $this->setDefaultSort('productvideo_id');
      $this->setDefaultDir('DESC');
      $this->setSaveParametersInSession(true);
  }

  protected function _prepareCollection()
  {
      $collection = Mage::getModel('productvideo/productvideo')->getCollection()
				->addFieldToFilter('status', Cmsmart_Productvideo_Model_Status::STATUS_PENDING)
				;
      $this->setCollection($collection);
      return parent::_prepareCollection();
  }

  protected function _prepareColumns()
  {
      $this->addColumn('productvideo_id', array(
          'header'    => Mage::helper('productvideo')->__('ID'),
          'align'     =>'right',
          'width'     => '50px',
          'index'     => 'productvideo_id',
      ));

	  $this->addColumn('thumbnail', array(
          'header'    => Mage::helper('productvideo')->__('Thumbnail'),
          'align'     =>'left',
          'index'     => 'thumbnail',
		  'filter'	  => false,
		  'sortable'  => false,
		  'renderer'  => 'productvideo/adminhtml_renderer_image',
      ));
	  
	  $this->addColumn('product_id', array(
          'header'    => Mage::helper('productvideo')->__('Product'),
          'align'     =>'left',
          'index'     => 'product_id',
		  'renderer'  => 'productvideo/adminhtml_renderer_product',
		  'filter_condition_callback' => array($this, '_filterProductCondition'),
      ));
	  
      $this->addColumn('video_name', array(
          'header'    => Mage::helper('productvideo')->__('Video Name'),
          'align'     =>'left',
          'index'     => 'video_name',
      ));
	  
	  $this->addColumn('video_id', array(
          'header'    => Mage::helper('productvideo')->__('Video ID'),
          'align'     =>'center',
          'index'     => 'video_id',
      ));
	  
	  $this->addColumn('provider', array(
          'header'    => Mage::helper('productvideo')->__('Provider'),
          'align'     =>'center',
          'index'     => 'provider',
      ));
	  
	  $this->addColumn('rate_video', array(
          'header'    => Mage::helper('productvideo')->__('Rate'),
          'align'     =>'right',
		  'type'      => 'number',
          'index'     => 'rate_video',
      ));
	  
	  $this->addColumn('author_name', array(
          'header'    => Mage::helper('productvideo')->__('Author Name'),
          'align'     =>'left',
          'index'     => 'author_name',
      ));
	  
	  $this->addColumn('author_email', array(
          'header'    => Mage::helper('productvideo')->__('Author Email'),
          'align'     =>'left',
          'index'     => 'author_email',
      ));
	  
	  $this->addColumn('date_created', array(
          'header'    => Mage::helper('productvideo')->__('Date Created'),
          'align'     =>'right',
		  'type'      => 'date',
          'index'     => 'date_created',
      ));
	  
	  
	  /*
      $this->addColumn('content', array(
			'header'    => Mage::helper('productvideo')->__('Item Content'),
			'width'     => '150px',
			'index'     => 'content',
      ));
	  */
	  
	  $statuses = Mage::getSingleton('productvideo/status')->getOptionArray();

      $this->addColumn('status', array(
          'header'    => Mage::helper('productvideo')->__('Status'),
          'align'     => 'left',
          'width'     => '80px',
          'index'     => 'status',
          'type'      => 'options',
          'options'   => array(
              Cmsmart_Productvideo_Model_Status::STATUS_PENDING => Mage::helper('productvideo')->__('Pending'),
          ),
      ));
	  
        $this->addColumn('action',
            array(
                'header'    =>  Mage::helper('productvideo')->__('Action'),
                'width'     => '50',
                'type'      => 'action',
                'getter'    => 'getId',
                'actions'   => array(
                    array(
                        'caption'   => Mage::helper('productvideo')->__('View'),
                        'url'       => array('base'=> '*/*/edit'),
                        'field'     => 'id'
                    )
                ),
                'filter'    => false,
                'sortable'  => false,
                'index'     => 'stores',
                'is_system' => true,
        ));
		
		$this->addExportType('*/*/exportCsv', Mage::helper('productvideo')->__('CSV'));
		$this->addExportType('*/*/exportXml', Mage::helper('productvideo')->__('XML'));
	  
      return parent::_prepareColumns();
  }

    protected function _prepareMassaction()
    {
        $this->setMassactionIdField('productvideo_id');
        $this->getMassactionBlock()->setFormFieldName('pendingvideo');

        $this->getMassactionBlock()->addItem('delete', array(
             'label'    => Mage::helper('productvideo')->__('Delete'),
             'url'      => $this->getUrl('*/*/massDelete'),
             'confirm'  => Mage::helper('productvideo')->__('Are you sure?')
        ));

        $statuses = Mage::getSingleton('productvideo/status')->getOptionArray();

        array_unshift($statuses, array('label'=>'', 'value'=>''));
        $this->getMassactionBlock()->addItem('status', array(
             'label'=> Mage::helper('productvideo')->__('Change status'),
             'url'  => $this->getUrl('*/*/massStatus', array('_current'=>true)),
             'additional' => array(
                    'visibility' => array(
                         'name' => 'status',
                         'type' => 'select',
                         'class' => 'required-entry',
                         'label' => Mage::helper('productvideo')->__('Status'),
                         'values' => $statuses
                     )
             )
        ));
        return $this;
    }
	
	protected function _filterProductCondition($collection, $column)
    {
		if (!$value = $column->getFilter()->getValue()) {
            return;
		}
		$collection = Mage::getModel('catalog/product')->getCollection()
					->addFieldToFilter('status', Cmsmart_Productvideo_Model_Status::STATUS_PENDING)
					->addAttributeToFilter('name', array('like' => '%'.$value.'%'));
		$pro_ids_arr = array();
		foreach($collection as $c){
			$pro_ids_arr[] = $c->getId();
		}
		$mycollection = Mage::getModel('productvideo/productvideo')->getCollection()
					->addFieldToFilter('product_id', array('in' => $pro_ids_arr));
		$this->setCollection($mycollection);
	}

  public function getRowUrl($row)
  {
      return $this->getUrl('*/*/edit', array('id' => $row->getId()));
  }

}