<?php
/*------------------------------------
* Product Video Extention
* Author  CMSMart Team
* Copyright Copyright (C) 2012 http://cmsmart.net. All Rights Reserved.
* @license - http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
* Websites: http://cmsmart.net
* Email: team@cmsmart.net
* Technical Support: http://cmsmart.net/support_ticket/
* Forum - http://cmsmart.net/forum
-----------------------------------------------------*/
class Cmsmart_Productvideo_Model_Productvideo extends Mage_Core_Model_Abstract
{
    public function _construct()
    {
        parent::_construct();
        $this->_init('productvideo/productvideo');
    }
	
	public function getVideoCollectionOfProduct($product_id){
		$videos = $this->getCollection()
							->addFieldToFilter('product_id', $product_id)
							->addFieldToFilter('status', 1)
							->addOrder('position','ASC');
		return $videos;
	}
	
	public function getVideoRate($vid){
		$video_load = $this->load($vid);
		return $video_load->getRateVideo() ? (int)$video_load->getRateVideo()/100*84 : 0;
	}
	
	public function updateVideoRate($vid, $rate_value){
		$video_load = $this->load($vid);
		$this->setRateVideo($rate_value);
		$this->save();
	}
}