<?php

class Idbeauty_Axelis_ExportcommandesController extends Mage_Core_Controller_Front_Action
{


    public function historyAction()
    {

        Idbeauty_Axelis_Model_Axelis::checkKey();


        set_time_limit(0);

        $dbname = (string)Mage::getConfig()->getNode('global/resources/default_setup/connection/dbname');

        //    var_dump($dbname);

        // Récupération des commandes
        $orders = Mage::getResourceModel('sales/order_collection')
            ->addFieldToSelect('*')
            //->addFieldToFilter('customer_id', Mage::getSingleton('customer/session')->getCustomer()->getId())
            //->addFieldToFilter('state', array('in' => Mage::getSingleton('sales/order_config')->getVisibleOnFrontStates()))
            ->addAttributeToFilter('created_at', array('from' => date('Y-m-d ') . '00:00:00', 'to' => date('Y-m-d H:i:s')))
            ->setOrder('created_at', 'desc');

        //Nombre de commandes
        echo sizeof($orders) . " commande(s)<br><br>";

        //Boucle sur les commandes
        foreach ($orders as $order) {

            echo 'Commande ' . $order->getIncrementId() . " <br>";

        }

    }

    public function indexAction()
    {
        Idbeauty_Axelis_Model_Axelis::checkKey();

        set_time_limit(900);
        Mage::app()->getCacheInstance()->flush();

        Mage::log('*Export des commandes', null, 'axelis.log');
        //    var_dump($dbname);

        // Récupération des commandes
        $orders = Mage::getResourceModel('sales/order_collection')
            ->addFieldToSelect('*')
            ->addFieldToFilter('state', 'processing')
            ->addFieldToFilter('export_axelis', 'default')
            ->addAttributeToFilter('created_at', array('from' => date('Y-m-d H:i:s', strtotime("-2 days")), 'to' => date('Y-m-d H:i:s')))
            ->setOrder('created_at', 'desc');

        //Nombre de commandes
        echo sizeof($orders) . " commande(s)<br>";
        Mage::log(sizeof($orders) . " commande(s)", null, 'axelis.log');

        //Boucle sur les commandes
        foreach ($orders as $order) {
            echo $order->getIncrementId()." ";
            echo $order->getExportAxelis();
            //On passe le statut Export Exalis à Preparing
            echo $order->getStatusLabel();
            $order->setExportAxelis('preparing');
            $order->save();

            //Récupération des informations relatives à la commande
            $orderinfos = array();
            $shippingaddress = $order->getShippingAddress();
            $orderinfos['id'] = $order->getId();
            $orderinfos['date'] = date('Ymd', strtotime($order->getUpdatedAt()));
            $orderinfos['deliverydate'] = '        ';
            $orderinfos['dest_name'] = str_replace(';', '', substr(strtoupper($shippingaddress->getLastname()) . ' ' . ucfirst($shippingaddress->getFirstname()), 0, 30));
            if ($shippingaddress->getCompany() != NULL) {
                $orderinfos['dest_address'][] = str_replace(';', '', $shippingaddress->getCompany());
            }
            $orderinfos['dest_address'][] = str_replace(';', '', $shippingaddress->getStreet()[0]);
            $orderinfos['dest_address'][] = str_replace(';', '', $shippingaddress->getStreet()[1]);
            $orderinfos['dest_city'] = str_replace(';', '', $shippingaddress->getCity());
            
            ///////// CODE POSTAL SANS ESPACE /////////
            $code_postal = str_replace(' ', '', $shippingaddress->getPostcode());
            $orderinfos['dest_postalcode'] = str_replace(';', '', $code_postal);
            $orderinfos['order_customerreference'] = $order->getIncrementId();
            $orderinfos['dest_country'] = Mage::getModel('directory/country')->loadByCode($shippingaddress->getCountry())->getIso2Code();
			$orderinfos['lebonmail'] = $order->getCustomerEmail();
            //Code transporteur 
            $shippingmethod = $order->getShippingMethod();
            switch ($shippingmethod) {
                case 'expert_colissimo':

                    $orderinfos['shipping_method'] = 5111;
                    break;
				
				case 'international_colissimo':

                    $orderinfos['shipping_method'] = 5140;
                    break;
                    
                case 'domtom_colissimo':

                    $orderinfos['shipping_method'] = 5142; 
                    break;
                 
                default :
            		$orderinfos['shipping_method'] = 5111;
                	break;    

            }
            $orderinfos['codeclientidbeauty'] = '0031292IDB';
            //Récupération des produits de la commande
            $items = $order->getAllVisibleItems();
            $numligne = 0;

            //Stockage des infos sous formes de lignes csv dans le tableau $results
            foreach ($items as $i):
                $numligne++;
//                echo $order->getId()." ".$i->getName() . ' ' . $i->getPrice() . ' ' . $i->getSku() . ' ' . $i->getData('qty_ordered')."<br>";
                $line = $orderinfos;
                $line['product_price'] = (float)$i->getPrice();  //      var_dump($i);
                $line['product_qty'] = (float)$i->getData('qty_ordered');
                $line['order_line_price'] = $line['product_price'] * $line['product_qty'];
                $line['product_sku'] = $i->getSku();
                $line['order_line_number'] = $numligne; // var_dump($line);
                $results[] = $line;
            endforeach;
        }
 

        //S'il y a au minimum une ligne à exporter
        if ($numligne > 0) {
            $exportcontent = "NoOrdre;Date OL;Date Livr.;Instructions cde 1;Code Client;Code Transp.;Réf. Cde Client;Destinataire;Adresse1;Adresse2;Adresse3;Ville;CP;Pays;Montant;Code Produit;Qté;PU;Type Préparation;No ligne OL;No de lot;Instruction livr. 1;Instruction livr. 2";
            $exportcontent .="\r\n";
            foreach ($results as $result) {
                $exportcontent .= $this->csvline($result);
                $exportcontent .="\r\n";
            }   
            //on génère le fichier
            $filename = 'IDB' . date("YmdHisu") . '.csv';
            file_put_contents($filename, $exportcontent);


			//par défaut on part du principe que le fichier généré est correctement exporté 
            $exportfailed=false;

			
          //Si le FTP est activé on upload le fichier 
            if (Idbeauty_Axelis_Model_Axelis::$enableftp) {
                    //si l'export n'upload n'a pas fonctionné, on indique qu'il a échoué
                    if(!Idbeauty_Axelis_Model_Axelis::ftpuploadfile($filename, "Out/Commandes/" . $filename)){   $exportfailed=true; }
            }
            
            
             //si l'export n'a pas échoué
            if($exportfailed==false){
                //on le stocke
                rename($filename, "var" . DIRECTORY_SEPARATOR . "archivesaxelis" . DIRECTORY_SEPARATOR . "envoyes" . DIRECTORY_SEPARATOR . "commandes" . DIRECTORY_SEPARATOR . $filename);
            }
			
            //on le stocke
            //  rename($filename, "var" . DIRECTORY_SEPARATOR . "archivesaxelis" . DIRECTORY_SEPARATOR . "envoyes" . DIRECTORY_SEPARATOR . "commandes" . DIRECTORY_SEPARATOR . $filename);

        }

        
        if($exportfailed==false){  
        //on passe toutes les commandes en statut d'export exalis "done"
			foreach ($orders as $order) {

				$order->setExportAxelis('done');
				$order->save();
			}
        }
        
                //on passe toutes les commandes en statut d'export exalis "done"

        /* foreach ($orders as $order) {

            $order->setExportAxelis('done');
            $order->save();
        } */

    }


    public function csvline($line)
    {

        return $line['id'] . ";" . $line['date'] . ";" . $line['deliverydate'] . ';;' . $line['codeclientidbeauty'] . ';' . $line['shipping_method'] . ';' . $line['order_customerreference'] . ';' . $line['dest_name'] . ';' . $line['dest_address'][0] . ';' . $line['dest_address'][1] . ';' . $line['dest_address'][2] . ';' . $line['dest_city'] . ';' . $line['dest_postalcode'] . ';' . $line['dest_country'] . ';' . $line['order_line_price'] . ';' . $line['product_sku'] . ';' . $line['product_qty'] . ';' . $line['product_price'] . ';;' . $line['order_line_number'] . ';;' . $line['lebonmail'] . ';;'; 

    }


    public function resetAction()
    {

        Idbeauty_Axelis_Model_Axelis::checkKey();

        Mage::app()->getCacheInstance()->flush();

        set_time_limit(0);
        error_reporting(E_ALL); ini_set('display_errors','On');
        echo "Recherche des commandes correspondantes...";
        $orders = Mage::getResourceModel('sales/order_collection')
            ->addFieldToSelect('*')
            //->addFieldToFilter('customer_id', Mage::getSingleton('customer/session')->getCustomer()->getId())
            //->addFieldToFilter('state', array('in' => Mage::getSingleton('sales/order_config')->getVisibleOnFrontStates()))
            //->addAttributeToFilter('created_at', array('from' => date('Y-m-d ',strtotime("-2 days")) . '00:00:00', 'to' => date('Y-m-d H:i:s')))
            ->addAttributeToFilter('export_axelis', 'preparing')

            ->setOrder('created_at', 'desc');

        echo sizeof($orders)." commandes <br>";



        foreach ($orders as $order) {
         echo $order->getExportAxelis()."<br>";
                echo $order->getIncrementId() . " "
                    . $order->getExportAxelis() . " "
                    . $order->getStatusLabel();
                $order->setExportAxelis('default');

                $order->save();


        }
        die();
    }
}