<?php

class Idbeauty_Axelis_ImportexpeditionsController extends Mage_Core_Controller_Front_Action
{

    public function cancelshipmentAction()
    {

        Idbeauty_Axelis_Model_Axelis::checkKey();


        Varien_Profiler::enable();
        Mage::setIsDeveloperMode(true);
        ini_set('display_errors', 1);
        umask(0);
        Mage::app('default');
        Mage::register('isSecureArea', 1);
        $orderId = $this->getRequest()->getParam('id');


        $order = Mage::getModel('sales/order')->load($orderId);

// check if has shipments
        if (!$order->hasShipments()) {
            die('No Shipments');
        }

//delete shipment
        $shipments = $order->getShipmentsCollection();
        foreach ($shipments as $shipment) {
            $shipment->delete();
        }

// Reset item shipment qty
// see Mage_Sales_Model_Order_Item::getSimpleQtyToShip()
        $items = $order->getAllVisibleItems();
        foreach ($items as $i) {
            $i->setQtyShipped(0);
            $i->save();
        }

//Reset order state
        $order->setState(Mage_Sales_Model_Order::STATE_PROCESSING, true, 'Undo Shipment');
        $order->save();
        die('OK');


    }

    public function indexAction()
    {

        Idbeauty_Axelis_Model_Axelis::checkKey();
        Mage::log('*Import des expeditions', null, 'axelis.log');

        //Récupération des fichiers de stock
        $filenames = $this->retrievefiles();

        //Traitement de chaque fichier un par un
        foreach ($filenames as $filename) {
            $content = $this->openTrackingfile($filename);
            foreach ($content as $shipment) {

                echo $this->getOrderId($shipment) . " ";

                //          $orders = Mage::getResourceModel('sales/order');

                $this->_createShipment($this->getOrderId($shipment), $this->getCarrierCode($shipment), array(), $this->getTrackingNumber($shipment));

            }
            echo $filename . "<br>";

        }
        die();


        var_dump($content);
    }

    public function retrievefiles()
    {

        $files = Idbeauty_Axelis_Model_Axelis::ftplistfiles("/In/Expeditions");
        foreach ($files as $file) {

            $filepart = explode("/", $file);
            $filename = $filepart[(sizeof($filepart) - 1)];
            $filenames[] = $filename;
            Idbeauty_Axelis_Model_Axelis::ftpdownloadfile($file, "var" . DIRECTORY_SEPARATOR . "archivesaxelis" . DIRECTORY_SEPARATOR . "recus" . DIRECTORY_SEPARATOR . "expeditions" . DIRECTORY_SEPARATOR . $filename);

        }
        return $filenames;
    }


    public function openTrackingfile($filename)
    {
        ini_set("auto_detect_line_endings", true);

        if (substr($filename, -4) == '.csv') {
            $f = fopen("var" . DIRECTORY_SEPARATOR . "archivesaxelis" . DIRECTORY_SEPARATOR . "recus" . DIRECTORY_SEPARATOR . "expeditions" . DIRECTORY_SEPARATOR . $filename, 'r');
            $i = 0;
            if ($f !== FALSE) {
                while (($csv = fgetcsv($f, 4096, ";")) !== FALSE) {

                    if ($i > 0) {
                        $line[] = $csv;
                    }
                    $i++;
                }
                return $line;
            }
        }
    }

    public function getOrderId($shipment)
    {


        $order = Mage::getModel('sales/order')->load($shipment[14]);

        return $order->getIncrementId();
    }

    private function _createShipment($order_id, $carriercode, $itemsQty = array(), $trackingnumber)
    {


        try {
            $shipmentIncrementId = Mage::getModel('sales/order_shipment_api')->create($order_id, $itemsQty, '', true, true);
            echo '<b>' . $shipmentIncrementId . '</b>';
            echo "<br>***" . $order_id . " " . $shipmentIncrementId . " " . $carriercode . " " . ' ' . $trackingnumber;


            if ($shipmentIncrementId) {
                Mage::getModel('sales/order_shipment_api')->addTrack($shipmentIncrementId, $carriercode, 'Suivi', $trackingnumber);
            }
        } catch (Exception $e) {
            Mage::log('*Erreur création shipment : ' . $order_id . ' ' . $e->getMessage(), null, 'axelis.log');
            Mage::log('Exception: ' . $e->getMessage());
        }

        return $shipmentIncrementId ? true : false;
    }

    public function getCarrierCode($shipment)
    {

        $info = $shipment[13];
        switch ($info) {
            case '5111':
            default:
                return 'expert';
                break;


        }

    }

    public function getTrackingNumber($shipment)
    {
        return $shipment[2];
    }


}




